//   $Id: kvi_timer.h,v 1.2 1998/09/20 20:24:07 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_TIMER_H_INCLUDED_
#define _KVI_TIMER_H_INCLUDED_

#include <qstring.h>
#include <qobject.h>
#include <qlist.h>

class KviMdiChild;
class KviUserParser;

typedef struct KviTimerTag{
	int			timerId;
	KviMdiChild *lpWindow;
	QString     szName;
	QString     szCommand;
	uint        interval;
} KviTimerStruct;

class KviTimerManager :public QObject{
	friend class KviUserParser;
	Q_OBJECT
public:
	KviTimerManager(KviUserParser *lpPars);
	~KviTimerManager();
protected:
	KviUserParser *m_lpParser;
	QList<KviTimerStruct> *m_lpTimerList;
public:
	bool stopTimer(const char *name);
	KviTimerStruct * getTimer(const char *name);
	KviTimerStruct * getTimer(int timerId);
	void stopAllTimers();
	bool startNamedTimer(const char *name,const char *command,KviMdiChild *lpWindow,uint interval);
protected:
	virtual void timerEvent(QTimerEvent *e);
};

#endif //_KVI_TIMER_H_INCLUDED_
