//   $Id: kvi_timer.cpp,v 1.2 1998/09/20 20:24:07 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_timer.h"
#include "kvi_debug.h"
#include "kvi_uparser.h"
#include "kvi_mdi.h"

//============ KviTimerManager ============//
KviTimerManager::KviTimerManager(KviUserParser *lpPars) : QObject(0,0)
{
	_debug_entertrace("KviTimerManager");
	m_lpParser=lpPars;
	m_lpTimerList=new QList<KviTimerStruct>;
	m_lpTimerList->setAutoDelete(true);
	_debug_leavetrace("KviTimerManager");
}
//============ ~KviTimerManager ============//
KviTimerManager::~KviTimerManager()
{
	_debug_entertrace("~KviTimerManager");
	stopAllTimers();
	_debug_leavetrace("~KviTimerManager");
}
//============ stopTimer ============//
bool KviTimerManager::stopTimer(const char *name)
{
	_debug_entertrace("stopTimer");
	KviTimerStruct *lpT=getTimer(name);
	if(lpT){
		killTimer(lpT->timerId);
		m_lpTimerList->removeRef(lpT);
		return true;
	} else return false;
	_debug_leavetrace("stopTimer");
}
//============ getTimer ============//
KviTimerStruct * KviTimerManager::getTimer(const char *name)
{
	_debug_entertrace("getTimer");
	KviTimerStruct *lpT=0;
	for(lpT=m_lpTimerList->first();lpT;lpT=m_lpTimerList->next()){
		if(!strcasecmp(name,lpT->szName.data()))return lpT;
	}
	return 0;
	_debug_leavetrace("getTimer");
}
//============ getTimer ============//
KviTimerStruct * KviTimerManager::getTimer(int timerId)
{
	_debug_entertrace("getTimer");
	KviTimerStruct *lpT=0;
	for(lpT=m_lpTimerList->first();lpT;lpT=m_lpTimerList->next()){
		if(lpT->timerId==timerId)return lpT;
	}
	return 0;
	_debug_leavetrace("getTimer");
}
//============ startTimer ============//
bool KviTimerManager::startNamedTimer(const char *name,const char *command,KviMdiChild *lpWindow,uint interval)
{
	_debug_entertrace("startTimer");
	QString szN=name;
	KviTimerStruct *lpT=new KviTimerStruct;
	lpT->szCommand=command;
	lpT->lpWindow=lpWindow;
	lpT->interval=interval;
	lpT->timerId=startTimer(interval);
	if(!strncmp(name,"_SINGLE SHOT_",13)){
		QString szId;
		szId.setNum(lpT->timerId);
		szN+=szId;
	}
	lpT->szName=szN.copy();
	KviTimerStruct *lpOld=getTimer(name);
	if(lpOld)stopTimer(name);
	m_lpTimerList->append(lpT);
	return true;
	_debug_leavetrace("startTimer");
}
//============ stopAllTimers ============//
void KviTimerManager::stopAllTimers()
{
	_debug_entertrace("stopAllTimers");
	killTimers();
	while(!m_lpTimerList->isEmpty())m_lpTimerList->removeLast();	
	_debug_leavetrace("stopAllTimers");
}
//============ timerEvent ============//
void KviTimerManager::timerEvent(QTimerEvent *e)
{
	_debug_entertrace("timerEvent");
	KviTimerStruct *lpT=getTimer(e->timerId());
	if(lpT){
		//If the window is no longer there,kill the timer!!!
		if(m_lpParser->m_lpMdi->m_lpChildList->findRef(lpT->lpWindow)<0){
			stopTimer(lpT->szName.data());
			return;
		}
		QString *pBuffer=new QString(lpT->szCommand.data());
		if(!strncmp(lpT->szName.data(),"_SINGLE SHOT_",13))stopTimer(lpT->szName.data());
		m_lpParser->parseUserInput(lpT->lpWindow,lpT->lpWindow->type(),lpT->lpWindow->name(),(*pBuffer));
		delete pBuffer;
	} else {
		debug("WARNING : timerEvent for an unknown timer!");
	}
	_debug_leavetrace("timerEvent");
}
#include "m_kvi_timer.moc"
