//   $Id: kvi_support.h,v 1.2 1998/10/06 14:42:48 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_SUPPORT_H_INCLUDED_
#define _KVI_SUPPORT_H_INCLUDED_


#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

//
//  Anybody experienced can suggest me if it is better to
//  define the constants below to the numbers used on
//  my linux distribution or to a dummy 'impossible' number ?
//  

//
//  There are some systems that don't define this...(Solaris)
//  Maybe it will be not used on that systems
//  Just a dummy number in that case.It's used only in kvi_socket.cpp
//
#ifndef EREMOTEIO
	#define EREMOTEIO 121
#endif
//
//  These two are for Digital Unix V4.0B
//
//  ENONET : Machine is not on the network
#ifndef ENONET
	#define ENONET 64
#endif
// ECOMM : Communication error on send
#ifndef ECOMM
    #define ECOMM 70  
#endif
//
//  This one is required by BSD
//
//  EPROTO : Protocol error
#ifndef EPROTO
	#define EPROTO 71
#endif


//
//  Try to use memset instead...if is not there it is a problem
//  but we will try to substitute it with my_bzero
//
#ifndef HAVE_BZERO
	#ifdef HAVE_MEMSET
		#warning "Using memset instead of bzero"
		#define bzero(__arg1,__arg2) memset((__arg1),0,(__arg2))
	#else
		#define __KVI_NEED_MY_BZERO__
		#warning "Using own bzero implementation"
		#undef bzero
		#define bzero(__arg1,__arg2) my_bzero(__arg1,__arg2)
		#ifdef _KVI_SUPPORT_CPP_
			void my_bzero(void * s,int n);
		#else
			extern void my_bzero(void * s,int n);			
		#endif
	#endif
#endif //HAVE_BZERO
//
//  Substitute it with my_inet_aton...I hope that it will work
//
#ifndef HAVE_INET_ATON
	#define __KVI_NEED_MY_INET_ATON__
	#warning "Using own inet_aton implementation"
	#undef inet_aton
	#define inet_aton(__arg1,__arg2) my_inet_aton(__arg1,__arg2)
	#ifdef _KVI_SUPPORT_CPP_
		int my_inet_aton(register const char *cp, struct in_addr *addr);
	#else
		extern int my_inet_aton(register const char *cp, struct in_addr *addr);		
	#endif
#endif //HAVE_INET_ATON

#ifndef HAVE_VSNPRINTF
	#define __KVI_NEED_MY_VSNPRINTF__
	#warning "Using own vsnprintf implementation"
	#undef vsnprintf
	#define vsnprintf(__arg1,__arg2,__arg3,__arg4) my_vsnprintf(__arg1,__arg2,__arg3,__arg4)
	#include <stdarg.h>
	#include <stdlib.h>
	#include <string.h>
	#ifdef _KVI_SUPPORT_CPP_
		int my_vsnprintf(char *buffer,int len,const char *fmt,va_list list);
	#else
		extern int my_vsnprintf(char *buffer,int len,const char *fmt,va_list list);
	#endif
#endif

#endif //_KVI_SUPPORT_H_INCLUDED_
