//   $Id: kvi_support.cpp,v 1.2 1998/09/20 20:24:03 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#include "kvi_app.h"
#include <ctype.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>      
#include <qstring.h> //includes <string.h> too

#include <stdio.h>
#include <stdarg.h> //for va_list

#define _KVI_SUPPORT_CPP_

#include "kvi_support.h"

#ifdef __KVI_NEED_MY_INET_ATON__

// 
// Check whether "cp" is a valid ascii representation
// of an Internet address and convert to a binary address.
// Returns 1 if the address is valid, 0 if not.
// This replaces inet_addr, the return value from which
// cannot distinguish between failure and a local broadcast address.
// Taken from ircd source.
//

int my_inet_aton(register const char *cp, struct in_addr *addr)
{
	register unsigned long val;
	register int base, n;
	register char c;
	unsigned int parts[4];
	register unsigned int *pp = parts;

	c = *cp;
	for (;;) {
		//
		// Collect number up to ``.''.
		// Values are specified as for C:
		// 0x=hex, 0=octal, isdigit=decimal.
		//
		if (!isdigit(c))
			return (0);
		val = 0; base = 10;
		if (c == '0') {
			c = *++cp;
			if (c == 'x' || c == 'X')
				base = 16, c = *++cp;
			else
				base = 8;
		}
		for (;;) {
			if (isascii(c) && isdigit(c)) {
				val = (val * base) + (c - '0');
				c = *++cp;
			} else if (base == 16 && isascii(c) && isxdigit(c)) {
				val = (val << 4) |
					(c + 10 - (islower(c) ? 'a' : 'A'));
				c = *++cp;
			} else
				break;
		}
		if (c == '.') {
			//
			// Internet format:
			//	a.b.c.d
			//	a.b.c	(with c treated as 16 bits)
			//	a.b	(with b treated as 24 bits)
			//
			if (pp >= parts + 3)
				return (0);
			*pp++ = val;
			c = *++cp;
		} else
			break;
	}
	// Check for trailing characters.
	if (c != '\0' && (!isascii(c) || !isspace(c)))
		return (0);
	//
	// Concoct the address according to
	// the number of parts specified.
	//
	n = pp - parts + 1;
	switch (n) {

	case 0:
		return (0);		/* initial nondigit */

	case 1:				/* a -- 32 bits */
		break;

	case 2:				/* a.b -- 8.24 bits */
		if (val > 0xffffff)
			return (0);
		val |= parts[0] << 24;
		break;

	case 3:				/* a.b.c -- 8.8.16 bits */
		if (val > 0xffff)
			return (0);
		val |= (parts[0] << 24) | (parts[1] << 16);
		break;

	case 4:				/* a.b.c.d -- 8.8.8.8 bits */
		if (val > 0xff)
			return (0);
		val |= (parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8);
		break;
	}
	if (addr)
		addr->s_addr = htonl(val);
	return (1);
}

#endif //__KVI_NEED_MY_INET_ATON__

#ifdef __KVI_NEED_MY_BZERO__

void my_bzero(void * s,int n)
{
	register char * p=(char *)s;
	while(n){
		*p=(char)0;
		p++;
		n--;
	}
}

#endif //__KVI_NEER_MY_BZERO__

#ifdef __KVI_NEED_MY_VSNPRINTF__

int my_vsnprintf(char *buffer,int len,const char *fmt,va_list list)
{
//	__range_valid(fmt);
//	__range_valid(buffer);
//	__range_valid(len > 0); //printing 0 characters is senseless
	register char *p = buffer;
	char *argString;
	long argValue;
	unsigned long argUValue;
	//9999999999999999999999999999999\0
	char numberBuffer[32]; //enough ? 10 is enough for 32bit unsigned int...
	char *pNumBuf;
	unsigned int tmp;

	for (p=buffer ; *fmt ; ++fmt) {
		if(len < 1)return (-1); //not enough space ... (in fact this could be len < 2 for the terminator)
		//copy up to a '%'
		if (*fmt != '%') {
			*p++ = *fmt;
			--len;
			continue;
		}
		++fmt; //skip this '%'
		switch(*fmt){
			case 's': //string
				argString = va_arg(list,char *);
				if(!argString){
					argString = "[!NULL!]";
					argValue = 8;
				} else argValue = strlen(argString);
				//check for space...
				if(len <= argValue)return (-1); //not enough space for buffer and terminator
				while(*argString)*p++ = *argString++;
				len -= argValue;
				continue;
			case 'd': //signed integer
				argValue = va_arg(list,int);
				if(argValue < 0){ //negative integer
					*p++ = '-';
					if(--len == 0)return (-1);
					argValue = -argValue; //need to have it positive
				}
				//write the number in a temporary buffer
				pNumBuf = numberBuffer;
				do {
					tmp = argValue / 10;
					*pNumBuf++ = argValue - (tmp * 10) + '0';
				} while(argValue = tmp);
				//copy now....
				argUValue = pNumBuf - numberBuffer; //length of the number string
				if(len <= argUValue)return (-1); //not enough space for number and terminator
				do { *p++ = *--pNumBuf; } while(pNumBuf != numberBuffer);
				len -= argUValue;
				continue;
			case 'u': //unsigned integer
				argUValue = va_arg(list,unsigned int); //many implementations place int here
				//write the number in a temporary buffer
				pNumBuf = numberBuffer;
				do {
					tmp = argUValue / 10;
					*pNumBuf++ = argUValue - (tmp * 10) + '0';
				} while(argUValue = tmp);
				//copy now....
				argValue = pNumBuf - numberBuffer; //length of the number string
				if(len <= argValue)return (-1); //not enough space for number and terminator
				do { *p++ = *--pNumBuf; } while(pNumBuf != numberBuffer);
				len -= argValue;
				continue;
			case 'c': //char
				//
				// I'm not sure about this...
				// In the linux kernel source the
				// unsigned char is extracted from an integer type.
				// We assume that gcc stacks a char argument
				// as sizeof(int) bytes value.
				// Is this always true ?
				//
				*p++ = (char)va_arg(list,int);
				--len;
				continue;
			default: //a normal percent
				*p++ = '%';  //write it
				if(--len == 0)return (-1); //not enough space for next char or terminator
				if(*fmt){        //this if is just in case that we have a % at the end of the string.
					*p++ = *fmt; //and write this char
					--len;
				}
				continue;
		}
	}
	if(len < 1)return (-1); //missing space for terminator
	*p = '\0';
	return p-buffer;
}

#endif //__KVI_NEED_MY_VSNPRINTF__
