//   $Id: kvi_stbar.h,v 1.2 1998/09/20 20:24:02 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_STATUSBAR_H_INCLUDED_
#define _KVI_STATUSBAR_H_INCLUDED_

#include <ktoolbar.h>

#include <qframe.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qstring.h>
#include <qtimer.h>

class KviIdentifiers;

class KviLed : public QFrame {
	Q_OBJECT;
public:
	KviLed(QWidget *parent);
	~KviLed();
	int m_iState;
	virtual void drawContents(QPainter *p);
};

class KviStatusBar : public KToolBar {
	Q_OBJECT
public:
	KviStatusBar(QWidget *parent, const char *name = 0);
	~KviStatusBar();
	KviLed *m_lpLed;
	QLabel *m_lpLabel;
	KviIdentifiers *m_lpIdentifiers;
	QString szDefLabelText;
	void resizeEvent( QResizeEvent* );
public:
	void increaseLedState();
	void resetLedState();
	void setDefaultLabelText(const char *szText);
	void setLabelText(const char *szText);
	void activate(KviIdentifiers *ptr);
	QTimer *m_lpFloodTimer;
	QTimer *m_lpMsgTimer;
protected slots:
	void floodTimerSlot();
	void msgTimerSlot();
};


#endif //_KVI_STATUSBAR_H_INCLUDED_
