//
//   File : kvi_stbar.cpp (/usr/cvs/kvirc/kvirc/kvi_stbar.cpp)
//   Last modified : Wed Nov 25 1998 01:54:37 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_defs.h"
#include "kvi_stbar.h"
#include "kvi_app.h"
#include "kvi_debug.h"

#include "kvi_ident.h"

#include <qtooltip.h>



KviLed::KviLed(QWidget *parent):QFrame(parent)
{
	m_iState=0;	
	setFrameStyle(QFrame::Sunken | QFrame::Panel);
	setBackgroundColor(black);
};
KviLed::~KviLed(){};
void KviLed::drawContents(QPainter *p)
{
	QRect cr=contentsRect();
	for(int i=0;i<m_iState;i++){
		switch(i){
			case 0: p->setPen(green);  break;
			case 4: p->setPen(yellow); break;
			case 7: p->setPen(red);    break;
		}
		p->drawLine(cr.x()+1+(i*3),cr.y()+1,cr.x()+1+(i*3),cr.height()-2);
		p->drawLine(cr.x()+2+(i*3),cr.y()+1,cr.x()+2+(i*3),cr.height()-2);
	}
}


// We want a statusbar-fields to be by this amount heigher than fm.height().
// This does NOT include the border width which we set separately for the statusbar.
#define FONT_Y_DELTA 3
#define DEFAULT_BORDERWIDTH 0


KviStatusBar::KviStatusBar(QWidget *parent,const char *name)
:KToolBar(parent,name,20)
{
	_debug_entertrace("KviStatusBar");
	m_lpIdentifiers=0;

	m_lpLabel=new QLabel("",this);
	m_lpLabel->setBackgroundColor(black);
	m_lpLabel->setFrameStyle(Panel | Sunken);
	QPalette labelPal=m_lpLabel->palette();
	QColorGroup aCG=labelPal.normal();
	QColorGroup nCG(aCG.foreground(),aCG.background(),aCG.light(),
			 	aCG.dark(), aCG.mid(),green, aCG.base()); 
	labelPal.setNormal(nCG);
	m_lpLabel->setPalette(labelPal);

	QToolTip::add(m_lpLabel,i18n("Status bar"));

	enableMoving(false);
	szDefLabelText=KVI_STATUS_DEFAULT_TEXT;
	m_lpLed=new KviLed(this);

	QToolTip::add(m_lpLed,i18n("Flood meter"));

	m_lpFloodTimer=new QTimer();
	m_lpMsgTimer=new QTimer();

	connect(m_lpMsgTimer,SIGNAL(timeout()),this,SLOT(msgTimerSlot()));
	connect(m_lpFloodTimer,SIGNAL(timeout()),this,SLOT(floodTimerSlot()));
	_debug_leavetrace("KviStatusBar");
}

KviStatusBar::~KviStatusBar()
{
	delete m_lpLabel;
	delete m_lpLed;
	if(m_lpFloodTimer->isActive())m_lpFloodTimer->stop();
	delete m_lpFloodTimer;
	if(m_lpMsgTimer->isActive())m_lpMsgTimer->stop();
	delete m_lpMsgTimer;
}

//============ activate ============//

void KviStatusBar::activate(KviIdentifiers *ptr)
{
	_debug_entertrace("activate");
	m_lpIdentifiers=ptr;
	_debug_leavetrace("activate");
}

//============ floodTimerSlot ============//

void KviStatusBar::floodTimerSlot()
{
	_debug_entertrace("floodTimerSlot");
	if(m_lpLed->m_iState==1)m_lpFloodTimer->stop();
	m_lpLed->m_iState--;
	m_lpLed->repaint();
	_debug_leavetrace("floodTimerSlot");
}

//============ msgTimerSlot ============//

void KviStatusBar::msgTimerSlot()
{
	_debug_entertrace("msgTimerSlot");
	m_lpMsgTimer->stop();
	QString szT=szDefLabelText.data();
	if(m_lpIdentifiers)m_lpIdentifiers->substitute(0,szT,0);
	m_lpLabel->setText(szT.data());
	_debug_leavetrace("msgTimerSlot");
}

//============ setDefaultLabelText ============//

void KviStatusBar::setDefaultLabelText(const char *szText)
{
	_debug_entertrace("setDefaultLabelText");
	szDefLabelText=szText;
	QString szT=szText;
	if(m_lpIdentifiers)m_lpIdentifiers->substitute(0,szT,0);
	m_lpLabel->setText(szT.data());
	_debug_leavetrace("setDefaultLabelText");
}

void KviStatusBar::setLabelText(const char *szText)
{
	m_lpLabel->setText(szText);
	if(m_lpMsgTimer->isActive())m_lpMsgTimer->stop();
	m_lpMsgTimer->start(KVI_STATUS_MSG_TIMER_TIMEOUT);
}

void KviStatusBar::resizeEvent( QResizeEvent * )
{
	m_lpLabel->setGeometry(0,1,width()-80,height()-1);
	m_lpLed->setGeometry(width()-80,1,80,height()-1);
}

void KviStatusBar::increaseLedState()
{
	_debug_entertrace("increaseLedState");
	if(m_lpLed->m_iState==0){
		if(m_lpFloodTimer->isActive())m_lpFloodTimer->stop();
		m_lpFloodTimer->start(2000);
	} else if(m_lpLed->m_iState==5)setLabelText(i18n("WARNING : You're flooding your server..."));
	m_lpLed->m_iState++;
	m_lpLed->repaint();
	_debug_entertrace("increaseLedtState");
}

//============ resetLedState ============//

void KviStatusBar::resetLedState()
{
	_debug_entertrace("resetLedState");
	m_lpLed->m_iState=0;
	if(m_lpFloodTimer->isActive())m_lpFloodTimer->stop();
	m_lpLed->repaint();
	_debug_leavetrace("resetLedState");
}

#include "m_kvi_stbar.moc"
