//   $Id: kvi_srv.h,v 1.3 1998/09/25 15:58:37 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_SRV_H_INCLUDED_
#define _KVI_SRV_H_INCLUDED_

#include "kvi_types.h"
#include <qfile.h>
#include <qstring.h>


class KviServerManager{
public:
	KviServerManager();
	~KviServerManager();
public:
	QList<KviIrcNetwork> *m_lpNetworkList;

	uint iTimeout;
	bool cacheLookup;
	bool reconnectOnDisconnect;
	bool reconnectOnConnectFailed;
	int iCurNetwork;
	//proxy section
	bool bUseProxy;
	bool bUseSocksV5;

	QList<KviProxyEntry> *m_lpProxyList;
public:
	void clearNetworkList();
	void clearProxyList();
	void cantWriteError();
	void cantReadError();
	void readSettings();
	void saveSettings();
	bool writeNetworkEntry(KviIrcNetwork *lpN,QFile *f);
	bool readNetworkEntry(KviIrcNetwork *lpN,QFile *f);
	bool writeString(QString &szString,QFile *f);
	bool readString(QString &szString,QFile *f);
	bool writeServerEntry(KviServerEntry *lpE,QFile *f);
	bool readServerEntry(KviServerEntry *lpE,QFile *f);
	bool writeProxyEntry(KviProxyEntry *lpE,QFile *f);
	bool readProxyEntry(KviProxyEntry *lpE,QFile *f);
	KviServerEntry * getServer(uint index);
	void getCurNetworkName(QString &szNet);
	void setCurrentServer(QString &szServer,unsigned short int iPort);
//utils:
public:
	void copyProxyList(QList<KviProxyEntry> *dst,QList<KviProxyEntry> *src);
	void copyNetworkList(QList<KviIrcNetwork> *dst,QList<KviIrcNetwork> *src);
	void copyNetworkEntry(KviIrcNetwork *dst,KviIrcNetwork *src);
	void copyProxyEntry(KviProxyEntry *dst,KviProxyEntry *src);
	void copyServerEntry(KviServerEntry *dst,KviServerEntry *src);
//	void readFromMircServersIni(const char *_patch);
};
#endif //_KVI_SRV_H_INCLUDED_
