//   $Id: kvi_script.h,v 1.2 1998/09/20 20:23:37 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_SCRIPT_H_INCLUDED_
#define _KVI_SCRIPT_H_INCLUDED_

#include <qdatastream.h>

class KviMircColors;
class KviOptions;
class KviEventManager;
class KviAliasManager;
class KviPopupManager;
class KviPopupMenu;
class KviInterface;
class KviFrame;

typedef struct kviScriptDescriptionTag{
	QString       szAuthor;
	QString       szDescription;
	QString       szLog;           //Used when checking the file
	Q_UINT16      version;
	Q_UINT16      revision;
	Q_UINT8       hasColorEntries; //Colors for messages
	Q_UINT8       hasColorMap;     //Color remappings for the 16 mirc colors
	Q_UINT8       hasOptions;      //Options
	Q_UINT8       hasEvents;
	Q_UINT8       hasAliases;
	Q_UINT8       hasPopups;
	Q_UINT8       hasInterface;    //fonts .. backgrounds ...
	Q_UINT8       hasAudioFiles;   //Contents of the $HOME/kvirc/Audio dir
	Q_UINT8       hasImages;       //Contents of the $HOME/kvirc/Images dir
	Q_UINT8       hasMiscFiles;    //Contents of the $HOME/kvirc/Misc dir
	Q_UINT8       hasAsciiFiles;
} KviScriptDescription;

class KviScriptManager{
public:
	KviScriptManager(KviFrame *lpFrm);
	~KviScriptManager();
public:
	KviFrame        *m_lpFrm;
	KviMircColors   *m_lpClr;
	KviOptions      *m_lpOpt;
	KviEventManager *m_lpEve;
	KviAliasManager *m_lpAli;
	KviPopupManager *m_lpPop;
	KviInterface    *m_lpInt;
	QString         *m_lpLog;
public:
	bool saveToFile(const char *fileName,KviScriptDescription *pD);
	bool readHeaderFromFile(QDataStream &stream,KviScriptDescription *pD);
	bool preloadHeaderAndCheckFile(const char *fileName,KviScriptDescription *pD);
	bool installFromFile(const char *fileName);
	void scriptExit(const char *szMsg);
private:
	void writeColorEntries(QDataStream &stream);
	void writeColorMap(QDataStream &stream);
	void writeOptions(QDataStream &stream);
	void writeEvents(QDataStream &stream);
	void writeAliases(QDataStream &stream);
	void writePopups(QDataStream &stream);
	void writePopup(QDataStream &stream,KviPopupMenu *m);
	void writeInterface(QDataStream &stream);
	void writeDirContents(const char *szDir,QDataStream &stream);

	void readColorEntries(QDataStream &stream);
	void readColorMap(QDataStream &stream);
	void readOptions(QDataStream &stream);
	void readEvents(QDataStream &stream);
	void readAliases(QDataStream &stream);
	void readPopups(QDataStream &stream);
	void readPopup(QDataStream &stream,KviPopupMenu *m);
	void readInterface(QDataStream &stream);
	void readDirContents(const char *szDir,QDataStream &stream);

	bool checkColorEntries(QDataStream &stream);
	bool checkColorMap(QDataStream &stream);
	bool checkOptions(QDataStream &stream);
	bool checkEvents(QDataStream &stream);
	bool checkAliases(QDataStream &stream);
	bool checkPopups(QDataStream &stream);
	bool checkPopup(QDataStream &stream,KviPopupMenu *m);
	bool checkInterface(QDataStream &stream);
	bool checkDirContents(const char *szDir,QDataStream &stream);
};

#endif //_KVI_SCRIPT_H_INCLUDED_
