//   $Id: kvi_scrdlg.cpp,v 1.5 1998/09/23 12:41:48 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_macros.h"
#include "kvi_script.h"
#include "kvi_scrdlg.h"
#include "kvi_cache.h"
#include "kvi_frame.h"
#include "kvi_app.h"
#include "kvi_debug.h"
#include "kvi_uparser.h"

//#include <kfiledialog.h>
#include <kmsgbox.h>

#include <qtooltip.h>

//============ KviScriptLoadDialog ============//

KviScriptLoadDialog::KviScriptLoadDialog(KviFrame *lpFrm,KviScriptDescription *lpS,
				const char *fileName) : QDialog(lpFrm,0,true)
{
	_debug_entertrace("KviScriptLoadDialog");
	m_lpFrm=lpFrm;
	m_lpScr=lpS;
	setFixedSize(500,505);

	m_szFileName=fileName;

	lpAuth  = new QLabel(lpS->szAuthor.data(),this);
	lpDesc  = new QMultiLineEdit(this);
	lpLog   = new QMultiLineEdit(this);
	QString szF=i18n("File name : ");
	szF+=fileName;
	QLabel *lpL1 = new QLabel(szF.data(),this);
	lpL1->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	lpAuth->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	QLabel *lpL2 = new QLabel(i18n("Author :"),this);
	lpL2->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	szF.sprintf(i18n("Generated using KVirc %u.%u"),lpS->version,lpS->revision);
	QLabel *lpL3 = new QLabel(szF.data(),this);
	lpL3->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	QLabel *lpL4 = new QLabel(i18n("Description :"),this);
	lpL4->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	QLabel *lpL5 = new QLabel(i18n("Pre-read log :"),this);
	lpL5->setFrameStyle(QFrame::Panel | QFrame::Sunken);

	lpDesc->setText(lpS->szDescription.data());
	lpLog->setText(lpS->szLog.data());

	lpDesc->setReadOnly(true);
	lpLog->setReadOnly(true);

	lpL1->setGeometry(10,10,480,26);
	lpL2->setGeometry(10,40,85,26);
	lpAuth->setGeometry(100,40,390,26);
	lpL3->setGeometry(10,70,480,26);
	lpL4->setGeometry(10,100,480,26);
	lpDesc->setGeometry(10,130,480,100);
	lpL5->setGeometry(10,235,480,26);
	lpLog->setGeometry(10,265,480,200);

	lpOk    = new QPushButton(i18n("Install"),this);
	lpCancel= new QPushButton(i18n("Cancel"),this);
	lpHelp  = new QPushButton(i18n("Help"),this);

	lpOk->setGeometry(400,470,90,26);
	lpCancel->setGeometry(300,470,90,26);
	lpHelp->setGeometry(200,470,90,26);

	connect(lpOk,SIGNAL(clicked()),this,SLOT(acceptInstall()));
	connect(lpCancel,SIGNAL(clicked()),this,SLOT(reject()));
	connect(lpHelp,SIGNAL(clicked()),this,SLOT(requestHelp()));

	setCaption(i18n("Script description"));

	if((lpS->version > KVI_UINT_VERSION)||((lpS->version = KVI_UINT_VERSION) &&(lpS->revision > KVI_UINT_REVISION))){
		KMsgBox::message(m_lpFrm,i18n("Script manager warning"),
				 i18n("This script was generated by a higer version of kvirc.\n"
				      "The aliases,popups and event handlers may be not evaluated\n"
				      "correctly."));
	}
	_debug_leavetrace("KviScriptLoadDialog");
}

//============ ~KviScriptLoadDialog ============//

KviScriptLoadDialog::~KviScriptLoadDialog()
{
	_debug_entertrace("~KviScriptLoadDialog");
	delete lpOk;
	delete lpAuth;
	delete lpDesc;
	delete lpLog;
	delete lpCancel;
	delete lpHelp;
	_debug_leavetrace("~KviScriptLoadDialog");
}

//============ acceptInstall ============//

void KviScriptLoadDialog::acceptInstall()
{
	_debug_entertrace("acceptInstall");
	m_lpFrm->m_lpUserParser->m_lpCache->clearCache();
	m_lpFrm->m_lpUserParser->m_lpCache->writeCache();
	if(!m_lpFrm->m_lpScriptManager->installFromFile(m_szFileName.data())){
		KMsgBox::message(m_lpFrm,i18n("Script manager error"),i18n("An error occured while reading the script."));
		reject();
		return;
	}
	accept();
	_debug_leavetrace("acceptInstall");
}

//============ requestHelp ============//

void KviScriptLoadDialog::requestHelp()
{
	_debug_entertrace("requestHelp");
	_debug_leavetrace("requestHelp");
}


//============ KviScriptSaveDialog ============//

KviScriptSaveDialog::KviScriptSaveDialog(KviFrame *lpFrm) : QDialog(lpFrm,0,true)
{
	_debug_entertrace("KviScriptSaveDialog");
	m_lpFrm=lpFrm;
	m_ScrDes.szAuthor=i18n("Put here your name and a little info on you");
	m_ScrDes.szDescription=i18n("Put here a short description of the script");

	lpAuth            = new QLineEdit(this);
	QToolTip::add(lpAuth,i18n("Author name"));
	lpDesc            = new QMultiLineEdit(this);
	QToolTip::add(lpDesc,i18n("Description"));
	lpHasColorEntries = new QCheckBox(i18n("Store mIrc color settings for messages"),this);
	lpHasColorMap     = new QCheckBox(i18n("Store color palette"),this);
	lpHasOptions      = new QCheckBox(i18n("Store default messages and protection settings (mass deop,public flood...)"),this);
	lpHasEvents       = new QCheckBox(i18n("Store event handlers"),this);
	lpHasAliases      = new QCheckBox(i18n("Store aliases"),this);
	lpHasPopups       = new QCheckBox(i18n("Store popups"),this);
	lpHasInterface    = new QCheckBox(i18n("Store interface settings (backgrounds,colors...)"),this);
	lpHasAudioFiles   = new QCheckBox(i18n("Store contents of $HOME/kvirc/Scripts/Audio directory"),this);
	lpHasMiscFiles    = new QCheckBox(i18n("Store contents of $HOME/kvirc/Scripts/Misc directory"),this);
	lpHasImages       = new QCheckBox(i18n("Store contents of $HOME/kvirc/Scripts/Images directory"),this);
	lpHasAsciiFiles   = new QCheckBox(i18n("Store contents of $HOME/kvirc/Scripts/Ascii directory"),this);
	lpOk              = new QPushButton(i18n("Save"),this);
	lpHelp            = new QPushButton(i18n("Help"),this);
	lpCancel          = new QPushButton(i18n("Cancel"),this);

	lpAuth->setText(m_ScrDes.szAuthor.data());
	lpDesc->setText(m_ScrDes.szDescription.data());
	lpHasColorEntries->setChecked(true);
	lpHasColorMap->setChecked(true);
	lpHasOptions->setChecked(true);
	lpHasEvents->setChecked(true);
	lpHasAliases->setChecked(true);
	lpHasPopups->setChecked(true);
	lpHasInterface->setChecked(true);
	lpHasAudioFiles->setChecked(true);
	lpHasMiscFiles->setChecked(true);
	lpHasImages->setChecked(true);
	lpHasAsciiFiles->setChecked(true);

	connect(lpOk,SIGNAL(clicked()),this,SLOT(acceptSave()));
	connect(lpCancel,SIGNAL(clicked()),this,SLOT(reject()));
	connect(lpHelp,SIGNAL(clicked()),this,SLOT(requestHelp()));

	lpAuth->setGeometry(10,10,480,26);
	lpDesc->setGeometry(10,40,480,126);
	lpHasColorEntries->setGeometry(10,170,480,26);
	lpHasColorMap->setGeometry(10,200,480,26);
	lpHasOptions->setGeometry(10,230,480,26);
	lpHasEvents->setGeometry(10,260,480,26);
	lpHasAliases->setGeometry(10,290,480,26);
	lpHasPopups->setGeometry(10,320,480,26);
	lpHasInterface->setGeometry(10,350,480,26);
	lpHasAudioFiles->setGeometry(10,380,480,26);
	lpHasMiscFiles->setGeometry(10,410,480,26);
	lpHasImages->setGeometry(10,440,480,26);
	lpHasAsciiFiles->setGeometry(10,470,480,26);

	lpOk->setGeometry(400,500,90,26);
	lpCancel->setGeometry(300,500,90,26);
	lpHelp->setGeometry(200,500,90,26);

	setFixedSize(500,535);
	setCaption(i18n("Save current script"));
	_debug_leavetrace("KviScriptSaveDialog");
}

//============ ~KviScriptSaveDialog ============//

KviScriptSaveDialog::~KviScriptSaveDialog()
{
	_debug_entertrace("~KviScriptSaveDialog");
	delete lpAuth;
	delete lpDesc;
	delete lpHasColorEntries;
	delete lpHasColorMap;
	delete lpHasOptions;
	delete lpHasEvents;
	delete lpHasAliases;
	delete lpHasPopups;
	delete lpHasInterface;
	delete lpHasAudioFiles;
	delete lpHasMiscFiles;
	delete lpHasImages;
	delete lpHasAsciiFiles;
	delete lpOk;
	delete lpHelp;
	delete lpCancel;
	_debug_leavetrace("~KviScriptSaveDialog");
}

//============ acceptSave ============//

void KviScriptSaveDialog::acceptSave()
{
	_debug_entertrace("acceptSave");
	if(!lpAuth->text()){
		KMsgBox::message(this,i18n("Save script error"),i18n("You must fill the author field!"));
		return;
	}
	if(!lpDesc->text()){
		KMsgBox::message(this,i18n("Save script error"),i18n("You must fill the description field!"));
		return;
	}
	m_ScrDes.szAuthor=lpAuth->text();
	m_ScrDes.szDescription=lpDesc->text();
	m_ScrDes.version=KVI_UINT_VERSION;
	m_ScrDes.revision=KVI_UINT_REVISION;
	m_ScrDes.hasColorEntries=lpHasColorEntries->isChecked();
	m_ScrDes.hasColorMap=lpHasColorMap->isChecked();
	m_ScrDes.hasOptions=lpHasOptions->isChecked();
	m_ScrDes.hasEvents=lpHasEvents->isChecked();
	m_ScrDes.hasAliases=lpHasAliases->isChecked();
	m_ScrDes.hasPopups=lpHasPopups->isChecked();
	m_ScrDes.hasInterface=lpHasInterface->isChecked();
	m_ScrDes.hasAudioFiles=lpHasAudioFiles->isChecked();
	m_ScrDes.hasImages=lpHasImages->isChecked();
	m_ScrDes.hasMiscFiles=lpHasMiscFiles->isChecked();
	m_ScrDes.hasAsciiFiles=lpHasAsciiFiles->isChecked();

	QString szHome=_macro_getKVircHomeDirectory("Scripts");
	QString szFileName=_macro_getSaveFileName(i18n("Save script file as..."),szHome.data(),0);
	if(!szFileName.isEmpty()){
		if(m_lpFrm->m_lpScriptManager->saveToFile(szFileName.data(),&m_ScrDes)){
			KMsgBox::message(this,i18n("Save script"),i18n("Script succesfully saved."));
		} else {
			KMsgBox::message(this,i18n("Save script error"),i18n("An error occured while saving the script."));
		}
	}
	accept();
	_debug_leavetrace("acceptSave");
}

//============ requestHelp ============//

void KviScriptSaveDialog::requestHelp()
{
	_debug_entertrace("requestHelp");
	_debug_leavetrace("requestHelp");
}


#include "m_kvi_scrdlg.moc"

//
// $Log: kvi_scrdlg.cpp,v $
// Revision 1.5  1998/09/23 12:41:48  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.4  1998/09/20 20:23:33  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.3  1998/09/16 17:16:46  fritz
// Starting i18n.
//
// Revision 1.2  1998/09/16 16:13:18  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
