//   $Id: kvi_query.cpp,v 1.2 1998/09/20 20:23:32 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CLASS_NAME_ "KviQueryWnd"

#include "kvi_defs.h"
#include "kvi_macros.h"
#include "kvi_query.h"
#include "kvi_input.h"
#include "kvi_view.h"
#include "kvi_frame.h"
#include "kvi_uparser.h"
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_mdi.h"
#include "kvi_opt.h"
#include "kvi_int.h"
#include "kvi_taskbar.h"
#include "kvi_support.h"

#include <stdarg.h>

KviQueryWnd::KviQueryWnd(KviMdiManager *parent,KviFrame *frame,const char *aname,int aid)
				:KviMdiChild(parent,frame,aname,aid,KVI_WND_TYPE_QUERY)
{
	m_lpInput=new KviInput(this,aid,KVI_WND_TYPE_QUERY,aname,frame,"KviInputClass");
	m_lpOutput=new KviView(this,frame,"KviViewClass");
	m_lpOutput->m_lpQueryParent=this;
	setFocusOwner(m_lpInput);
	connect(this,SIGNAL(closeButtonPressed()),this,SLOT(closeSlot()));
	applyOptions();
}

KviQueryWnd::~KviQueryWnd()
{
	m_lpFrm->m_lpUserParser->m_szLastQueryTarget="";
	delete m_lpInput;
	delete m_lpOutput;
}

//============ closeSlot ============//

void KviQueryWnd::closeSlot()
{
	_debug_entertrace("closeSlot");
	hide();
	_macro_kviApplication->processEvents();
	blockSignals(true);
//	if(this==m_lpMdi->m_lpMaximizedChild)m_lpMdi->m_lpMaximizedChild=0;
	m_lpMdi->m_lpTaskBar->removeButton(id());
	m_lpMdi->m_lpChildList->setAutoDelete(false);
	m_lpMdi->m_lpChildList->removeRef(this);
	m_lpMdi->focusTopChild();
	m_lpMdi->fillWinListPopup();
	m_lpFrm->queryExternalDestroy(this);
	_debug_leavetrace("closeSlot");
}





void KviQueryWnd::applyOptions(){
	m_lpInput->enableColorBox(m_lpFrm->m_lpOpt->bShowColorBox);
	m_lpInput->setDefaultBackgroundColor(m_lpInt->clr_bk_input);
	m_lpInput->setDefaultForegroundColor(m_lpInt->clr_fr_input);
	m_lpInput->setMarkBackgroundColor(m_lpInt->clr_bk_sel_input);
	m_lpInput->setMarkForegroundColor(m_lpInt->clr_fr_sel_input);
	m_lpInput->setCursorColor(m_lpInt->clr_cursor_input);
	m_lpInput->setFont(m_lpInt->fnt_input);
	if(!m_lpInt->pix_bk_input.isNull())m_lpInput->setBackgroundPixmap(m_lpInt->pix_bk_input);
	m_lpOutput->setFont(m_lpInt->fnt_output);
	m_lpOutput->m_bTimestamp=m_lpFrm->m_lpOpt->bTimestamp;
	m_lpOutput->m_bShowPixmaps=m_lpFrm->m_lpOpt->bShowPixmaps;

	const QSize sz=size();
	QResizeEvent e(sz,sz);
	resizeEvent(&e);
}

void KviQueryWnd::resizeEvent(QResizeEvent *){
	_debug_entertrace("resizeEvent");
	updateRects();
	QRect rct=viewSizeHint();
	QFontMetrics fnt=m_lpInput->fontMetrics();
	int input_hght=fnt.lineSpacing()+8;
	m_lpInput->setGeometry(rct.left(),rct.top()+rct.height()-input_hght,rct.width(),input_hght);
	m_lpOutput->setGeometry(rct.left(),rct.top(),rct.width(),rct.height()-(input_hght+KVI_MDI_VIEW_SEP));
	_debug_leavetrace("resizeEvent");
}
void KviQueryWnd::doFmtOutput(int nType,const char *szFmt,...){
	char szText[600]; //It should be big enough... I hope...
	va_list list;
	va_start(list,szFmt);
	if(vsnprintf(szText,600,szFmt,list)==-1)debug("WARNING : Output string truncated"); // Fritz: vsnprintf
	va_end(list);
	m_lpMdi->highlightWindow(m_iId);
	m_lpOutput->appendText(nType,(const char *) &szText);
}
void KviQueryWnd::doOutput(int nType,const char *szText){
	m_lpMdi->highlightWindow(m_iId);
	m_lpOutput->appendText(nType,szText);
}
#include "m_kvi_query.moc"
