//   $Id: kvi_proxy.h,v 1.1 1998/09/25 15:51:44 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_PROXY_H_INCLUDED_
#define _KVI_PROXY_H_INCLUDED_

#include "kvi_types.h"
#include <qstring.h>

#define KVI_PROXY_INACTIVE 0
// ready to negotiate (not used?)
#define KVI_PROXY_READY 100
// waiting for final agree
#define KVI_PROXY_FINAL 101
// waiting for method selection
#define KVI_PROXY_SELECT 102
// waiting for authorisation reply
#define KVI_PROXY_AUTH 103

class KviIrcSocket;
class KviFrame;
class KviStatusWnd;

class KviProxy{
public:
	KviProxy(KviIrcSocket *lpSocket,KviFrame *lpFrm);
	~KviProxy();
public:
	KviIrcSocket *m_lpSock;
	KviFrame *m_lpFrm;
	KviHostDescription m_host;
	KviStatusWnd *m_lpConsole;
	int m_iProto; //stands for state
	QString m_szUserName;
	QString m_szPassword;
	Q_UINT32 m_iHost;
	Q_UINT16 m_iPort;
	bool m_bIsActive;
public:
	int state();
	bool isActive();
	void clear();
	bool setup(bool bUseV5,QString &szHost,QString &szIp,unsigned short int iPort);
	bool getProxyReply(unsigned char replycode,QString &szBuffer);
	bool setHost(QString &szHost,QString &szIp,unsigned short int iPort);
	bool resolveHost();
	void beginNegotiate(KviHostDescription *kh,QString &szUsername,QString &szPass);
	void methodSelected(unsigned char chReply);
	void authComplete();
};
#endif //_KVI_PROXY_H_INCLUDED_
