//   $Id: kvi_popup.h,v 1.2 1998/09/20 20:23:29 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_POPUP_H_INCLUDED_
#define _KVI_POPUP_H_INCLUDED_

#include <qstring.h>
#include <qpopupmenu.h>
#include <qlist.h>
#include <qfile.h>

class KviPopupMenu;

typedef struct kviPopupItemTag{
	QString szText;
	QString szAction;
	KviPopupMenu *lpMenu;
	bool isSep;
	int id;
} KviPopupItem;

class KviPopupMenu : public QPopupMenu{
	Q_OBJECT
public:
	KviPopupMenu();
	~KviPopupMenu();
public:
	QList<KviPopupItem> *m_lpData;
public:
	void clearPopup();
	void addItem(KviPopupItem *lpItem,int index=-1);
	KviPopupItem * getPopupItem(int id);
	void removePopupItem(uint index);
	bool readSelf(QFile *f);
	bool writeSelf(QFile *f);
protected slots:
	void actionRedirect(const char *szAction);
	void itemSelected(int id);
signals:
	void actionSelected(const char *szAction);
};

class KviPopupManager{
public:
	KviPopupManager();
	~KviPopupManager();
public:
	KviPopupMenu *m_lpUserNickListPopup;
	KviPopupMenu *m_lpUserChanPopup;
	KviPopupMenu *m_lpUserActionPopup;
	KviPopupMenu *m_lpUserChatPopup;
	KviPopupMenu *m_lpUserQueryPopup;

	QString szNickListPopup;
	QString szChanPopup;
	QString szActionPopup;
	QString szChatPopup;
	QString szQueryPopup;

	int m_iLastPopupEdited;

public:
	void readFromFile();
	void saveToFile();
private:
	void cantWriteError();
	void cantReadError();
};
#endif //_KVI_ALIAS_H_INCLUDED_
