//   $Id: kvi_popup.cpp,v 1.3 1998/09/20 20:23:28 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#define _KVI_DEBUG_CLASS_NAME_ "KviPopupMenu"

#include "kvi_macros.h"
#include "kvi_popup.h"
#include "kvi_debug.h"
#include "kvi_app.h"

#include <kiconloader.h>
#include <kmsgbox.h>

//============ KviPopupMenu ============//

KviPopupMenu::KviPopupMenu() : QPopupMenu()
{
	_debug_entertrace("KviPopupMenu");
	m_lpData=new QList<KviPopupItem>;
	m_lpData->setAutoDelete(true);
	connect(this,SIGNAL(activated(int)),this,SLOT(itemSelected(int)));
	_debug_leavetrace("KviPopupMenu");
}

//============ ~KviPopupMenu ============//

KviPopupMenu::~KviPopupMenu()
{
	_debug_entertrace("~KviPopupMenu");
	clearPopup();
	delete m_lpData;
	_debug_leavetrace("~KviPopupMenu");
}

//============ clearPopup ============//

void KviPopupMenu::clearPopup()
{
	_debug_entertrace("clearPopup");
	clear();
	KviPopupItem *lpI=0;
	for(lpI=m_lpData->first();lpI;lpI=m_lpData->next()){
		if(lpI->lpMenu){
			lpI->lpMenu->clearPopup();
			delete lpI->lpMenu;
		}
	}
	while(!m_lpData->isEmpty())m_lpData->removeLast();
	_debug_leavetrace("clearPopup");
}

//============ writeSelf ============//

bool KviPopupMenu::writeSelf(QFile *f)
{
	_debug_entertrace("writeSelf");
	if(!f)return false;
	KviPopupItem *lpI=0;
	uint len=m_lpData->count();
	if(f->writeBlock((char *)&len,sizeof(len))<0)return false;
	if(!len)return true;
	for(lpI=m_lpData->first();lpI;lpI=m_lpData->next()){
		if(f->writeBlock((char *)&lpI->id,sizeof(lpI->id))<0)return false;
		int type=2;
		if(lpI->isSep)type=0;
		else {
			if(lpI->lpMenu)type=1;
		}
		if(f->writeBlock((char *)&type,sizeof(type))<0)return false;
		if(type){
			int textLen=lpI->szText.length();
			if(f->writeBlock((char *)&textLen,sizeof(textLen))<0)return false;
			if(f->writeBlock(lpI->szText.data(),textLen)<0)return false;
			if(type==1){
				if(!lpI->lpMenu->writeSelf(f))return false;
			} else {
				textLen=lpI->szAction.length();
				if(f->writeBlock((char *)&textLen,sizeof(textLen))<0)return false;
				if(f->writeBlock(lpI->szAction.data(),textLen)<0)return false;
			}
		}
	}
	return true;
	_debug_leavetrace("writeSelf");
}

//============ readSelf ============//

bool KviPopupMenu::readSelf(QFile *f)
{
	_debug_entertrace("readSelf");
	if(!f)return false;
	uint len;
	if(f->readBlock((char *)&len,sizeof(len))<0)return false;
	if(!len)return true;
	while(len){
		int theId;
		if(f->readBlock((char *)&theId,sizeof(theId))<0){
			clearPopup();
			return false;
		}
		int theType;
		if(f->readBlock((char *)&theType,sizeof(theType))<0){
			clearPopup();
			return false;
		}
		//0->separator 1->popup 2->item
		KviPopupItem *lpI;
		int textLen;
		QString szText;
		QString szAction;
		char dummy[4096];
		switch(theType){
			case 0: //separator
				lpI=new KviPopupItem;
				lpI->isSep=true;
				lpI->lpMenu=0;
				lpI->id=theId;
				lpI->szAction="";
				addItem(lpI);
				break;
			case 1: //menu
				if(f->readBlock((char *)&textLen,sizeof(textLen))<0)return false;
				if(f->readBlock(dummy,textLen)<textLen)return false;
				szText=QString(dummy,textLen+1);
				lpI=new KviPopupItem;
				lpI->id=theId;
				lpI->isSep=false;
				lpI->lpMenu=new KviPopupMenu();
				lpI->szText=szText.copy();
				lpI->szAction="";
				if(!lpI->lpMenu->readSelf(f)){
					delete lpI->lpMenu;
					delete lpI;
				}
				addItem(lpI);
				break;
			case 2: //item
				if(f->readBlock((char *)&textLen,sizeof(textLen))<0)return false;
				if(f->readBlock(dummy,textLen)<textLen)return false;
				szText=QString(dummy,textLen+1);
				if(f->readBlock((char *)&textLen,sizeof(textLen))<0)return false;
				if(f->readBlock(dummy,textLen)<textLen)return false;
				szAction=QString(dummy,textLen+1);
				lpI=new KviPopupItem;
				lpI->id=theId;
				lpI->isSep=false;
				lpI->lpMenu=0;
				lpI->szText=szText.copy();
				lpI->szAction=szAction.copy();
				addItem(lpI);
				break;
			default:
				debug("KviPopupItem Type <> 0,1,2...someone messed with my kvi.popup.config file...");
				return false;
				break;
		}
		len--;
	}
	return true;
	_debug_leavetrace("readSelf");
}


//============ removePopupItem ============//

void KviPopupMenu::removePopupItem(uint index)
{
	_debug_entertrace("removePopupItem");
//	debug("removeing %u",index);
//	if(idAt(index)==-1){
//		debug("\nWARNING : No popup item at index %u\n",index);
//		exit(-1);
//	}
//	removeItemAt(index);
	KviPopupItem *lpI=m_lpData->at(index);
//	debug("removing popup item at %d : %s : id = (%d:Kvi:%d)",index,lpI->szText.data(),idAt(index),lpI->id);
	if(!lpI){
		debug("\nWARNING : No KviPopupItem at index %u\n",index);
		exit(-1);
	} else removeItemAt(index);
	if(lpI->lpMenu)delete lpI->lpMenu;
	m_lpData->remove(index);
	if(m_lpData->count() == 0)clear();
	_debug_leavetrace("removePopupItem");
}

//============ getPopupItem ============//

KviPopupItem * KviPopupMenu::getPopupItem(int id)
{
	_debug_entertrace("getPopupItem");
	KviPopupItem *lpI=0;
//	debug("looking for %d",id);
	for(lpI=m_lpData->first();lpI;lpI=m_lpData->next()){
//		debug("popup : %s , %d",lpI->szText.data(),lpI->id);
		if(lpI->id==id)return lpI;
	}
//	debug("(not found)");
	return 0;
	_debug_leavetrace("getPopupItem");
}

//============ addItem ============//

void KviPopupMenu::addItem(KviPopupItem *lpItem,int index)
{
	KIconLoader *lpIL=_macro_kviIconLoader;
	_debug_entertrace("addItem");
	if(m_lpData->count() == 0)clear();
	if(index<0)m_lpData->append(lpItem);
	else m_lpData->insert(index,lpItem);
	if(lpItem->isSep){
		insertSeparator(index);
		lpItem->id=0;
	} else if(lpItem->lpMenu){
		lpItem->id=insertItem(lpIL->loadIcon("kvii_menu.gif"),lpItem->szText.data(),lpItem->lpMenu,-2,index);
		connect(lpItem->lpMenu,SIGNAL(actionSelected(const char *)),this,SLOT(actionRedirect(const char *)));
	} else {
		lpItem->id=insertItem(lpIL->loadIcon("kvii_popu.gif"),lpItem->szText.data(),-2,index);
	}
//	debug("inserted %s id:%d index:%d",lpItem->szText.data(),lpItem->id,index);
//	debug("Data count = %d , item count %d",m_lpData->count(),count());
	_debug_leavetrace("addItem");
}

//============ itemSelected ============//

void KviPopupMenu::itemSelected(int id)
{
	_debug_entertrace("itemSelected");
	KviPopupItem *lpI=getPopupItem(id);
	if(!lpI){
		debug("\nWARNING : selected item without a real popup object %d\n",id);
		exit(-1);
	}
	emit actionSelected(lpI->szAction.data());
	_debug_leavetrace("itemSelected");
}

//============ actionRedirect ============//

void KviPopupMenu::actionRedirect(const char *szAction)
{
	_debug_entertrace("actionRedirect");
	emit actionSelected(szAction);
	_debug_leavetrace("actionRedirect");
}

//***********************//
// Class KviPopupManager //
//***********************//

#undef _KVI_DEBUG_CLASS_NAME_
#define _KVI_DEBUG_CLASS_NAME_ "KviPopupManager"

//============ KviPopupManager ============//

KviPopupManager::KviPopupManager()
{
	_debug_entertrace("KviPopupManager");
	m_lpUserNickListPopup=new KviPopupMenu();
	m_lpUserChanPopup=new KviPopupMenu();
	m_lpUserActionPopup=new KviPopupMenu();
	m_lpUserQueryPopup=new KviPopupMenu();
	m_lpUserChatPopup=new KviPopupMenu();
	szNickListPopup="Personal";
	szChanPopup="Personal";
	szActionPopup="&Personal";
	szChatPopup="Personal";
	szQueryPopup="Personal";
	readFromFile();
	m_iLastPopupEdited=0;
	_debug_leavetrace("KviPopupManager");
}

//============ ~KviPopupManager ============//

KviPopupManager::~KviPopupManager()
{
	_debug_entertrace("~KviPopupManager");
	saveToFile();
	delete m_lpUserNickListPopup;
	delete m_lpUserChanPopup;
	delete m_lpUserActionPopup;
	delete m_lpUserChatPopup;
	delete m_lpUserQueryPopup;
	_debug_leavetrace("~KviPopupManager");
}

//============ readFromFile ============//

void KviPopupManager::readFromFile()
{
	_debug_entertrace("readFromFile");
	QString szFileName(_macro_getKVircHomeDirectory("Config/kvi.popup.conf"));

	QFile config(szFileName.data());
	if(!config.exists()){
		config.open(IO_WriteOnly);
		config.close();
		return;
	}

	if(!config.open(IO_ReadOnly)){ cantReadError(); return; }
	char dummyBuf[100];
	if(config.readBlock(dummyBuf,46)<0){ cantReadError(); return; };
	//read popup names
	int iLen;
	char dummy[4096];

	if(config.readBlock((char *)&iLen,sizeof(iLen))<0){ cantReadError(); return;};
	if(config.readBlock((char *)dummy,iLen)<iLen){ cantReadError(); return;};
	szNickListPopup=QString(dummy,iLen+1);
	if(config.readBlock((char *)&iLen,sizeof(iLen))<0){ cantReadError(); return;};
	if(config.readBlock((char *)dummy,iLen)<iLen){ cantReadError(); return;};
	szChanPopup=QString(dummy,iLen+1);
	if(config.readBlock((char *)&iLen,sizeof(iLen))<0){ cantReadError(); return;};
	if(config.readBlock((char *)dummy,iLen)<iLen){ cantReadError(); return;};
	szActionPopup=QString(dummy,iLen+1);
	if(config.readBlock((char *)&iLen,sizeof(iLen))<0){ cantReadError(); return;};
	if(config.readBlock((char *)dummy,iLen)<iLen){ cantReadError(); return;};
	szChatPopup=QString(dummy,iLen+1);
	if(config.readBlock((char *)&iLen,sizeof(iLen))<0){ cantReadError(); return;};
	if(config.readBlock((char *)dummy,iLen)<iLen){ cantReadError(); return;};
	szQueryPopup=QString(dummy,iLen+1);

	if(!m_lpUserNickListPopup->readSelf(&config)){ cantReadError(); return; };
	if(!m_lpUserChanPopup->readSelf(&config)){ cantReadError(); return; };
	if(!m_lpUserActionPopup->readSelf(&config)){ cantReadError();return; };
	if(!m_lpUserChatPopup->readSelf(&config)){ cantReadError();return;};
	if(!m_lpUserQueryPopup->readSelf(&config)){ cantReadError();return;};

	config.close();
	_debug_leavetrace("readFromFile");
}

//============ saveToFile ============//

void KviPopupManager::saveToFile()
{
	_debug_entertrace("saveToFile");
	QString szFileName(_macro_getKVircHomeDirectory("Config/kvi.popup.conf"));

	QFile config(szFileName.data());
	if(!config.open(IO_WriteOnly|IO_Truncate)){ cantWriteError(); return; }
	if(config.writeBlock("KVIrc CONFIGURATION FILE - PLEASE DO NOT EDIT\n",46)<0){ cantWriteError(); return; };
	//write popup names
	int iLen=szNickListPopup.length();
	if(config.writeBlock((char *)&iLen,sizeof(iLen))<0){ cantWriteError(); return;};
	if(config.writeBlock((char *)szNickListPopup.data(),iLen)<iLen){ cantWriteError(); return;};
	iLen=szChanPopup.length();
	if(config.writeBlock((char *)&iLen,sizeof(iLen))<0){ cantWriteError(); return;};
	if(config.writeBlock((char *)szChanPopup.data(),iLen)<iLen){ cantWriteError(); return;};
	iLen=szActionPopup.length();
	if(config.writeBlock((char *)&iLen,sizeof(iLen))<0){ cantWriteError(); return;};
	if(config.writeBlock((char *)szActionPopup.data(),iLen)<iLen){ cantWriteError(); return;};
	iLen=szChatPopup.length();
	if(config.writeBlock((char *)&iLen,sizeof(iLen))<0){ cantWriteError(); return;};
	if(config.writeBlock((char *)szChatPopup.data(),iLen)<iLen){ cantWriteError(); return;};
	iLen=szQueryPopup.length();
	if(config.writeBlock((char *)&iLen,sizeof(iLen))<0){ cantWriteError(); return;};
	if(config.writeBlock((char *)szQueryPopup.data(),iLen)<iLen){ cantWriteError(); return;};

	if(!m_lpUserNickListPopup->writeSelf(&config)){ cantWriteError(); return; };
	if(!m_lpUserChanPopup->writeSelf(&config)){ cantWriteError(); return; };
	if(!m_lpUserActionPopup->writeSelf(&config)){ cantWriteError(); return; };
	if(!m_lpUserChatPopup->writeSelf(&config)){ cantWriteError(); return;};
	if(!m_lpUserQueryPopup->writeSelf(&config)){ cantWriteError(); return;};

	config.close();
	_debug_leavetrace("saveToFile");
}
//============ cantWriteError ============//
void KviPopupManager::cantWriteError()
{
	_debug_entertrace("cantWriteError");
	KMsgBox::message(0,"WARNING File I/O Error","Can't write to the kvi.popup.conf file.\nThe current popups will be lost.");
	_debug_leavetrace("cantWriteError");
}
//============ cantReadError ============//
void KviPopupManager::cantReadError()
{
	_debug_entertrace("cantReadError");
	KMsgBox::message(0,"WARNING File I/O Error","Can't read the kvi.popup.conf file.\nThe current popups will be lost.");
	_debug_leavetrace("cantReadError");
}
#include "m_kvi_popup.moc"

//
// $Log: kvi_popup.cpp,v $
// Revision 1.3  1998/09/20 20:23:28  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.2  1998/09/16 16:13:18  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
