//   $Id: kvi_popdlg.cpp,v 1.3 1998/09/20 20:23:25 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#define _KVI_DEBUG_CLASS_NAME_ "KviPopupDialog"

#include "kvi_popdlg.h"
#include "kvi_frame.h"
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_mlined.h"

#include <qtooltip.h>
#include <qpushbutton.h>
#include <qlistbox.h>

//============ KviPopupDialog ============//

KviPopupDialog::KviPopupDialog(KviFrame *lpParent,KviPopupManager *lpManager):QDialog(lpParent,0,true)
{
	_debug_entertrace("KviPopupDialog");
	resize(300,100);
	m_lpFrm=lpParent;
	m_lpPopupManager = lpManager;
	m_lpOk    = new QPushButton(i18n("OK"),this);
	m_lpName  = new QLineEdit(this);
	m_lpBox   = new QComboBox(this);
	m_lpEdit  = new QPushButton(i18n("Edit"),this);
	m_lpBox->setGeometry(10,10,280,26);
	m_lpName->setGeometry(10,40,280,26);
	m_lpEdit->setGeometry(10,70,135,26);
	m_lpOk->setGeometry(150,70,135,26);
	setFixedSize(300,100);
	setCaption(i18n("Popups"));
	m_lpBox->setInsertionPolicy(QComboBox::NoInsertion);
	m_lpBox->insertItem(i18n("Menu bar popup"));
	m_lpBox->insertItem(i18n("Nick list popup"));
	m_lpBox->insertItem(i18n("Channel popup"));
	m_lpBox->insertItem(i18n("DCC Chat popup"));
	m_lpBox->insertItem(i18n("Query popup"));
	if(m_lpPopupManager->m_iLastPopupEdited<0)m_lpPopupManager->m_iLastPopupEdited=0;
	m_lpBox->setCurrentItem(m_lpPopupManager->m_iLastPopupEdited);
	connect(m_lpBox,SIGNAL(activated(int)),this,SLOT(selected(int)));
	m_iLastIndex=-1;
	selected(m_lpPopupManager->m_iLastPopupEdited);
	connect(m_lpOk,SIGNAL(clicked()),this,SLOT(accept()));
	connect(m_lpEdit,SIGNAL(clicked()),this,SLOT(editCurrent()));
	setFixedSize(300,100);
	_debug_leavetrace("KviPopupDialog");
}

//============ ~KviPopupDialog ============//

KviPopupDialog::~KviPopupDialog()
{
	_debug_entertrace("~KviPopupDialog");
	//remember the last popup edited in this session
	m_lpPopupManager->m_iLastPopupEdited=m_lpBox->currentItem();
	if(m_lpPopupManager->m_iLastPopupEdited<0)m_lpPopupManager->m_iLastPopupEdited=0;
	if(m_iLastIndex==-1)m_iLastIndex=m_lpPopupManager->m_iLastPopupEdited;
	selected(0);
	delete m_lpBox;
	delete m_lpName;
	delete m_lpEdit;
	delete m_lpOk;
	_debug_leavetrace("~KviPopupDialog");
}

//============ getPointersFromIndex ============//

void KviPopupDialog::getPointersFromIndex(int idx,QString **lpName,KviPopupMenu **lpMenu)
{
	_debug_entertrace("getPointersFromIndex");
	switch(idx){
		case 0:
			*lpName=&(m_lpPopupManager->szActionPopup);
			*lpMenu=m_lpPopupManager->m_lpUserActionPopup;
			break;
		case 1:
			*lpName=&(m_lpPopupManager->szNickListPopup);
			*lpMenu=m_lpPopupManager->m_lpUserNickListPopup;
			break;
		case 2:
			*lpName=&(m_lpPopupManager->szChanPopup);
			*lpMenu=m_lpPopupManager->m_lpUserChanPopup;
			break;
		case 3:
			*lpName=&(m_lpPopupManager->szChatPopup);
			*lpMenu=m_lpPopupManager->m_lpUserChatPopup;
			break;
		case 4:
			*lpName=&(m_lpPopupManager->szQueryPopup);
			*lpMenu=m_lpPopupManager->m_lpUserQueryPopup;
			break;
		default:
			_debug_fatal("Your qt must be drunk...:)");
			break;
	}
	_debug_leavetrace("getPointersFromIndex");
}

//============ selected ============//

void KviPopupDialog::selected(int index)
{
	_debug_entertrace("selected");
	
	KviPopupMenu *lpMenu;
	QString *lpName;
	if(m_iLastIndex>=0){
		getPointersFromIndex(m_iLastIndex,&lpName,&lpMenu);
		*lpName=(m_lpName->text() ? m_lpName->text() : i18n("Personal"));
//     	debug("1.count = %d , menu items=%d",lpMenu->m_lpData->count(),lpMenu->count());

//		debug("setting : %s of index %d",lpName->data(),m_iLastIndex);
	}
	getPointersFromIndex(index,&lpName,&lpMenu);
	m_lpName->setText(lpName->data());
	m_iLastIndex=index;
	_debug_leavetrace("selected");
}

//============ editCurrent ============//

void KviPopupDialog::editCurrent()
{
	_debug_entertrace("editCurrent");
	KviPopupMenu *lpMenu;
	QString *lpName;
	int idx=m_lpBox->currentItem();
	if(idx==-1)return;
	getPointersFromIndex(idx,&lpName,&lpMenu);
//	debug("1.count = %d , menu items=%d",lpMenu->m_lpData->count(),lpMenu->count());

	KviPopupEditDialog *pDlg=new KviPopupEditDialog(this,lpName->data(),lpMenu,m_lpFrm);

	pDlg->exec();
//	debug("1.count = %d , menu items=%d",lpMenu->m_lpData->count(),lpMenu->count());

	delete pDlg;
	_debug_leavetrace("editCurrent");
}

#undef _KVI_DEBUG_CLASS_NAME_
#define _KVI_DEBUG_CLASS_NAME_ "KviPopupEditDialog"

//============ KviPopupEditDialog ============//

KviPopupEditDialog::KviPopupEditDialog(QWidget *parent,const char *caption,KviPopupMenu *lpMenu,KviFrame *lpFrm):QDialog(parent,0,true)
{
	_debug_entertrace("KviPopupEditDialog");
	m_lpMenu =lpMenu;
	m_szCaption=caption;
	m_iLastSelection=-1;
	m_lpFrm=lpFrm;

	resize(600,440);

	m_lpListGroup  = new QGroupBox(i18n("Item list"),this);
	m_lpItemBox    = new QListBox(m_lpListGroup);
	m_lpOk         = new QPushButton(i18n("OK"),this);
	m_lpNew        = new QPushButton(i18n("New"),m_lpListGroup);
	m_lpRemove     = new QPushButton(i18n("Remove"),m_lpListGroup);
	m_lpMoveUp     = new QPushButton(i18n("Move up"),m_lpListGroup);
	m_lpMoveDown   = new QPushButton(i18n("Move down"),m_lpListGroup);
	m_lpItemGroup  = new QGroupBox(i18n("Item properties"),this);
	m_lpTypeBox    = new QComboBox(m_lpItemGroup);
	m_lpNameEdit   = new QLineEdit(m_lpItemGroup);
	m_lpEditPopup  = new QPushButton(i18n("Edit..."),m_lpItemGroup);
	m_lpActionEdit = new KviMultiLineEdit(m_lpItemGroup,lpFrm);

	QToolTip::add(m_lpItemBox,i18n("This is the list of items\nthat will appear in the popup"));
	QToolTip::add(m_lpNew,i18n("Appends a new item"));
	QToolTip::add(m_lpRemove,i18n("Removes the currently selected item"));
	QToolTip::add(m_lpMoveUp,i18n("Moves the current item up"));
	QToolTip::add(m_lpMoveDown,i18n("Moves the current item down"));
	QToolTip::add(m_lpTypeBox,i18n("This is the type of the currently selected item"));
	QToolTip::add(m_lpNameEdit,i18n("This is the name for the current item\nthat will appear in the popup"));
	QToolTip::add(m_lpEditPopup,i18n("Edits the currently selected popup menu item"));
	QToolTip::add(m_lpActionEdit,i18n("This is the action that the current item will perform"));
	QToolTip::add(m_lpOk,i18n("Press this button when you're satisfied of your work. :)"));

	m_lpListGroup->setGeometry(10,10,220,380);
	m_lpItemGroup->setGeometry(235,10,355,380);

	m_lpItemBox->setGeometry(10,15,200,295);
	m_lpMoveUp->setGeometry(10,315,98,26);
	m_lpMoveDown->setGeometry(112,315,98,26);
	m_lpNew->setGeometry(10,345,98,26);
	m_lpRemove->setGeometry(112,345,98,26);

	m_lpTypeBox->setGeometry(10,15,260,26);
	m_lpTypeBox->setInsertionPolicy(QComboBox::NoInsertion);
	m_lpTypeBox->insertItem(i18n("Menu item"));
	m_lpTypeBox->insertItem(i18n("Separator"));
	m_lpTypeBox->insertItem(i18n("Popup menu"));
	m_lpEditPopup->setGeometry(275,15,70,26);

	QLabel *lp1=new QLabel(i18n("Name :"),m_lpItemGroup);
	lp1->setGeometry(10,45,75,26);
	m_lpNameEdit->setGeometry(90,45,255,26);
	m_lpActionEdit->setGeometry(10,75,335,295);

	m_lpOk->setGeometry(10,400,580,26);

	connect(m_lpItemBox,SIGNAL(highlighted(int)),this,SLOT(itemSelected(int)));
	connect(m_lpOk,SIGNAL(clicked()),this,SLOT(okPressed()));
	connect(m_lpNew,SIGNAL(clicked()),this,SLOT(addNewItem()));
	connect(m_lpRemove,SIGNAL(clicked()),this,SLOT(removeOldItem()));
	connect(m_lpMoveUp,SIGNAL(clicked()),this,SLOT(moveUp()));
	connect(m_lpMoveDown,SIGNAL(clicked()),this,SLOT(moveDown()));
	connect(m_lpTypeBox,SIGNAL(activated(int)),this,SLOT(typeSelected(int)));
	connect(m_lpNameEdit,SIGNAL(textChanged(const char *)),this,SLOT(itemNameChanged(const char *)));
	connect(m_lpEditPopup,SIGNAL(clicked()),this,SLOT(editPopup()));

	setFixedSize(600,440);

	QString szCaption=i18n("Edit popup : ");
	szCaption+=caption;
	setCaption(szCaption.data());

	fillBox();
	_debug_leavetrace("KviPopupEditDialog");
}

//============ ~KviPopupEditDialog ============//

KviPopupEditDialog::~KviPopupEditDialog()
{
	_debug_entertrace("~KviPopupEditDialog");
	delete m_lpItemBox;
	delete m_lpOk;
	delete m_lpNew;
	delete m_lpRemove;
	delete m_lpMoveUp;
	delete m_lpMoveDown;
	delete m_lpTypeBox;
	delete m_lpNameEdit;
	delete m_lpEditPopup;
	delete m_lpActionEdit;

	delete m_lpListGroup;
	delete m_lpItemGroup;
	_debug_leavetrace("~KviPopupEditDialog");
}

//============ fillBox ============//

void KviPopupEditDialog::fillBox()
{
	_debug_entertrace("fillBox");
//	debug("1.count = %d , menu items=%d",m_lpMenu->m_lpData->count(),m_lpMenu->count());
	if(m_lpMenu->m_lpData->count()==0)m_lpMenu->clear();

	m_lpItemBox->setAutoUpdate(false);
	m_lpItemBox->setEnabled(false);
	m_lpItemBox->clear();
	if(m_lpMenu->m_lpData->count()<2){
		m_lpMoveUp->setEnabled(false);
		m_lpMoveDown->setEnabled(false);
	} else {
		m_lpMoveUp->setEnabled(true);
		m_lpMoveDown->setEnabled(true);
	}
	if(m_lpMenu->m_lpData->isEmpty()){
		m_lpTypeBox->setEnabled(false);
		m_lpActionEdit->setEnabled(false);
		m_lpEditPopup->setEnabled(false);
		m_lpNameEdit->setEnabled(false);
		m_lpNameEdit->setText("");
		m_lpActionEdit->setText("");
		m_lpRemove->setEnabled(false);
		m_lpItemBox->setAutoUpdate(true);
		m_lpItemBox->repaint();
		return;
	}
	KviPopupItem *lpI=0;
	for(lpI=m_lpMenu->m_lpData->first();lpI;lpI=m_lpMenu->m_lpData->next()){
		insertBoxItem(lpI);
	}
	m_lpItemBox->setEnabled(true);
	if((m_iLastSelection>=0) && (m_iLastSelection<(int)m_lpItemBox->count()))m_lpItemBox->setCurrentItem(m_iLastSelection);
	else m_lpItemBox->setCurrentItem(0);
	m_lpItemBox->setAutoUpdate(true);
	m_lpItemBox->repaint();
	_debug_leavetrace("fillBox");
}

//============ insertBoxItem ============//

void KviPopupEditDialog::insertBoxItem(KviPopupItem *lpI,int index)
{
	_debug_entertrace("insertBoxItem");
	if(lpI->isSep)m_lpItemBox->insertItem("---------------",index);
	else {
		if(lpI->szText.isEmpty())lpI->szText=i18n("No name");
		QString szT="";
		if(lpI->lpMenu)szT=i18n("Popup ");
		szT+=lpI->szText.data();
		m_lpItemBox->insertItem(szT.data(),index);
	}
	_debug_leavetrace("insertBoxItem");
}


//============ copyItem ============//

void KviPopupEditDialog::copyItem(KviPopupItem *lpDest,KviPopupItem *lpSrc)
{
	_debug_entertrace("copyItem");
	lpDest->szAction=lpSrc->szAction.copy();
	lpDest->szText=lpSrc->szText.copy();
	lpDest->id=lpSrc->id;
	lpDest->isSep=lpSrc->isSep;
	if(lpSrc->lpMenu){
		lpDest->lpMenu=new KviPopupMenu();
		KviPopupItem *lpI=0;
		for(lpI=lpSrc->lpMenu->m_lpData->first();lpI;lpI=lpSrc->lpMenu->m_lpData->next()){
			KviPopupItem *lpNew=new KviPopupItem;
			copyItem(lpNew,lpI);
			lpDest->lpMenu->addItem(lpNew);
		}
	} else lpDest->lpMenu=0;
	_debug_leavetrace("copyItem");
}


//============ okPressed ============//

void KviPopupEditDialog::okPressed()
{
	_debug_entertrace("okPressed");
	int cur=m_lpItemBox->currentItem();
	if(cur>=0)updateItem(cur);
	accept();
	_debug_leavetrace("okPressed");
}

//============ updateItem ============//

void KviPopupEditDialog::updateItem(int index)
{
	_debug_entertrace("updateItem");
//	debug("1.index = %d , count = %d , menu items=%d",index,m_lpMenu->m_lpData->count(),m_lpMenu->count());
	if((index>=0) && (index<(int)m_lpMenu->m_lpData->count())){
		KviPopupItem *lpNew=new KviPopupItem;
		KviPopupItem *lpOld=0;
		int curType=m_lpTypeBox->currentItem();
		if(curType<0 || curType>2)curType=1;
		switch(curType){
			case 2: //popup menu
				lpOld=m_lpMenu->m_lpData->at(index);
				if(lpOld){
					if(lpOld->lpMenu)copyItem(lpNew,lpOld);
					else lpNew->lpMenu=new KviPopupMenu;
				} else {
					lpNew->lpMenu=new KviPopupMenu;
				}
				lpNew->szAction="";
				lpNew->szText=(m_lpNameEdit->text() ? m_lpNameEdit->text() : i18n("No name"));
				lpNew->isSep=false;
				break;
			case 1: //separator
				lpNew->lpMenu=0;
				lpNew->szAction="";
				lpNew->szText="";
				lpNew->isSep=true;
				break;
			case 0: //item
				lpNew->lpMenu=0;
				lpNew->szAction=m_lpActionEdit->text();
				if(lpNew->szAction.isEmpty())lpNew->szAction="/<\n    halt;\n>;";
				lpNew->szText=(m_lpNameEdit->text() ? m_lpNameEdit->text() : i18n("No name"));
				lpNew->isSep=false;
				break;
			default:
				_debug_fatal("Unknown item type");
				break;
		}
//		debug("2.index = %d , count = %d , menu items=%d",index,m_lpMenu->m_lpData->count(),m_lpMenu->count());
		m_lpMenu->removePopupItem(index);
		m_lpMenu->addItem(lpNew,index);
//		debug("3.index = %d , count = %d , menu items=%d",index,m_lpMenu->m_lpData->count(),m_lpMenu->count());
	}
	_debug_leavetrace("updateItem");
}

//============ itemSelected ============//

void KviPopupEditDialog::itemSelected(int index)
{
	_debug_entertrace("itemSelected");
	if(m_lpMenu->m_lpData->isEmpty()){
		m_lpMenu->clear();
		return;
	}
	updateItem(m_iLastSelection);
	m_iLastSelection=index;

	if(index<0){
		m_lpTypeBox->setEnabled(false);
		m_lpActionEdit->setEnabled(false);
		m_lpEditPopup->setEnabled(false);
		m_lpNameEdit->setEnabled(false);
		m_lpNameEdit->setText("");
		m_lpActionEdit->setText("");
		m_lpMoveUp->setEnabled(false);
		m_lpMoveDown->setEnabled(false);
		m_lpRemove->setEnabled(false);
		return;
	}
	m_lpRemove->setEnabled(true);
	if(m_lpMenu->m_lpData->count()<2){
		m_lpMoveUp->setEnabled(false);
		m_lpMoveDown->setEnabled(false);
	} else {
		m_lpMoveDown->setEnabled((index+1)<(int)m_lpMenu->m_lpData->count());
		m_lpMoveUp->setEnabled(index>0);
	}
	KviPopupItem *lpI=m_lpMenu->m_lpData->at(index);
	if(lpI){
		m_lpTypeBox->setEnabled(true);
		if(lpI->isSep){
			m_lpTypeBox->setCurrentItem(1);
			m_lpActionEdit->setEnabled(false);
			m_lpEditPopup->setEnabled(false);
			m_lpNameEdit->setEnabled(false);
			m_lpNameEdit->setText("");
			m_lpActionEdit->setText("");
		} else {
			m_lpNameEdit->setEnabled(true);
			if(lpI->szText.isEmpty())lpI->szText=i18n("No name");
			m_lpNameEdit->setText(lpI->szText);
			m_lpActionEdit->setEnabled(!lpI->lpMenu);
			m_lpEditPopup->setEnabled(lpI->lpMenu);
			if(lpI->lpMenu)m_lpTypeBox->setCurrentItem(2);
			else {
				m_lpTypeBox->setCurrentItem(0);
				if(lpI->szAction.isEmpty())lpI->szAction="/<\n    halt\n>;";
				m_lpActionEdit->setText(lpI->szAction.data());
			}
		}
	} else _debug_fatal("Unable to find the selected menu item");
	_debug_leavetrace("itemSelected");
}

//============ addNewItem ============//

void KviPopupEditDialog::addNewItem()
{
	_debug_entertrace("addNewItem");
	int index=m_lpItemBox->currentItem();
	if(index>=0)updateItem(index);
	else m_lpRemove->setEnabled(true);
	KviPopupItem *lpNew=new KviPopupItem;
	lpNew->lpMenu=0;
	lpNew->szAction="/<\n    halt;\n>;";
	lpNew->szText=i18n("No name");
	lpNew->isSep=false;
	if(m_lpMenu->m_lpData->count()==0)m_lpMenu->clear();
	m_lpMenu->addItem(lpNew);
	fillBox();
	m_lpItemBox->setCurrentItem(m_lpMenu->m_lpData->count()-1);
	_debug_leavetrace("addNewItem");
}

//============ removeOldItem ============//

void KviPopupEditDialog::removeOldItem()
{
	_debug_entertrace("removeOldItem");
	int cur=m_lpItemBox->currentItem();
	if(cur<0)return;
	updateItem(cur);
	m_lpMenu->removePopupItem(cur);
	if(m_lpMenu->m_lpData->count()==0)m_lpMenu->clear();
	m_iLastSelection=-1;
	fillBox();
	if(cur<(int)m_lpItemBox->count())m_lpItemBox->setCurrentItem(cur);
	else {
		if(m_lpItemBox->count())m_lpItemBox->setCurrentItem(0);
		else m_lpRemove->setEnabled(false);
	}
	_debug_leavetrace("removeOldItem");
}

//============ moveUp ============//

void KviPopupEditDialog::moveUp()
{
	_debug_entertrace("moveUp");
	int cur=m_lpItemBox->currentItem();
	if(cur<1)return;
	if(cur>=(int)m_lpMenu->m_lpData->count())return;
	updateItem(cur);
	KviPopupItem *lpCur=m_lpMenu->m_lpData->at(cur);
	if(!lpCur)_debug_fatal("Can not find the item to move");
	KviPopupItem *lpI=new KviPopupItem;
	copyItem(lpI,lpCur);
	removeOldItem();
	cur--;
	m_lpMenu->addItem(lpI,cur);
	m_iLastSelection=-1;
	fillBox();
	if(cur<(int)m_lpItemBox->count())m_lpItemBox->setCurrentItem(cur);
	else {
		if(m_lpItemBox->count())m_lpItemBox->setCurrentItem(0);
	}
	_debug_leavetrace("moveUp");
}

//============ moveDown ============//

void KviPopupEditDialog::moveDown()
{
	_debug_entertrace("moveDown");
	int cur=m_lpItemBox->currentItem();
	if(cur<0)return;
	if(cur>=(int)(m_lpMenu->m_lpData->count()-1))return;
	updateItem(cur);
	KviPopupItem *lpCur=m_lpMenu->m_lpData->at(cur);
	if(!lpCur)_debug_fatal("Can not find the item to move");
	KviPopupItem *lpI=new KviPopupItem;
	copyItem(lpI,lpCur);
	removeOldItem();
	cur++;
	m_lpMenu->addItem(lpI,cur);
	m_iLastSelection=-1;
	fillBox();
	if(cur<(int)m_lpItemBox->count())m_lpItemBox->setCurrentItem(cur);
	else {
		if(m_lpItemBox->count())m_lpItemBox->setCurrentItem(0);
	}
	_debug_leavetrace("moveDown");
}

//============ typeSelected ============//

void KviPopupEditDialog::typeSelected(int)
{
	_debug_entertrace("typeSelected");
	int idx=m_lpItemBox->currentItem();
	if(idx<0)return;
	KviPopupItem *lpI=m_lpMenu->m_lpData->at(idx);
	if(lpI){
		updateItem(idx);
		fillBox();
	}
	else _debug_fatal("Unable to find the popup item requested");
	_debug_leavetrace("typeSelected");
}

//============ itemNameChanged ============//

void KviPopupEditDialog::itemNameChanged(const char *text)
{
	_debug_entertrace("itemNameChanged");
	int idx=m_lpItemBox->currentItem();
	if(idx<0)return;
	KviPopupItem *lpI=m_lpMenu->m_lpData->at(idx);
	if(lpI){
		if(lpI->isSep)return;
		QString szT;
		if(lpI->lpMenu)szT=i18n("Popup ");
		szT+=text;
		m_lpItemBox->changeItem(szT.data(),idx);
		lpI->szText=text;
	} else _debug_fatal("Unable to find the popup item that changed name...");
	_debug_leavetrace("itemNameChanged");
}

//============ editPopup ============//

void KviPopupEditDialog::editPopup()
{
	_debug_entertrace("editPopup");
	int idx=m_lpItemBox->currentItem();
	if(idx<0)return;
	KviPopupItem *lpI=m_lpMenu->m_lpData->at(idx);
	if(!lpI)_debug_fatal("Unable to find the popup item requested.");
	if(!lpI->lpMenu)_debug_fatal("The popup item has no menu field set");
	QString szC=m_szCaption.copy();
	szC+='/';
	szC+=lpI->szText.data();
	KviPopupEditDialog *pDlg=new KviPopupEditDialog(this,szC,lpI->lpMenu,m_lpFrm);
	pDlg->exec();
	delete pDlg;
	updateItem(idx);
	_debug_leavetrace("editPopup");
}

#include "m_kvi_popdlg.moc"
