//
//   File : kvi_optdlg.cpp (/usr/cvs/kvirc/kvirc/kvi_optdlg.cpp)
//   Last modified : Fri Nov 27 1998 21:35:46 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//


#define _KVI_DEBUG_CLASS_NAME_ "KviNewOptDialog"

#include "kvi_macros.h"
#include "kvi_optdlg.h"
#include "kvi_translate.h"
#include "kvi_frame.h"
#include "kvi_app.h"
#include "kvi_opt.h"
#include "kvi_chng.h"
#include "kvi_debug.h"

#include "kvi_qhelp.h"

//#include <kfiledialog.h>
#include <kseparator.h>
#include <kmsgbox.h>

/////////////////////////////////////////////////////////////////////////////////////////////
// Base options dialog
/////////////////////////////////////////////////////////////////////////////////////////////

//============ KviNewOptBaseDialog ============//

KviNewOptBaseDialog::KviNewOptBaseDialog(KviFrame *lpFrm,KviOptions *lpOpt)
:QTabDialog(lpFrm,0,true)
{
	_debug_entertrace("KviNewOptBaseDialog");
	m_lpFrm=lpFrm;
	m_lpOpt=lpOpt;
	_debug_leavetrace("KviNewOptBaseDialog");
}
//============ ~KviNewOptBaseDialog ============//

KviNewOptBaseDialog::~KviNewOptBaseDialog()
{
	_debug_entertrace("~KviNewOptBaseDialog");
	_debug_leavetrace("~KviNewOptBaseDialog");
}

//============ addWidget ============//

void KviNewOptBaseDialog::addWidget(QWidget *w,QGridLayout *g,int x,int y,int x1,int y1)
{
	_debug_entertrace("addWidget");
	w->adjustSize();
	w->setMinimumSize(w->size());
	if((x1==-1)&&(y1==-1))g->addWidget(w,x,y);
	else g->addMultiCellWidget(w,x,y,x1,y1);
	_debug_leavetrace("addWidget");
}

//============= addBoolChanger ===========//

KviNewBoolChanger * KviNewOptBaseDialog::addBoolChanger(const char *text,QWidget *tab,
	QGridLayout *g,bool *bVarPtr,int x,int y,int resId,bool bEnabled,int x1,int y1)
{
	_debug_entertrace("addBoolChanger");
	KviNewBoolChanger *w=new KviNewBoolChanger(this,tab,text,bVarPtr,bEnabled);
	addWidget(w,g,x,y,x1,y1);
	addQuickHelp(w,resId);
	_debug_leavetrace("addBoolChanger");
	return w;
}

//============ addLined ============//

QLineEdit * KviNewOptBaseDialog::addLined(const char *text,QWidget *tab,QGridLayout *g,int x,int y,int resId)
{
	_debug_entertrace("addLined");
	QLineEdit *w=new QLineEdit(tab);
	w->setText(text);
	addWidget(w,g,x,y);
	addQuickHelp(w,resId);
	_debug_leavetrace("addLined");
	return w;
}

//============ addIntChanger =============//

KviNewIntChanger * KviNewOptBaseDialog::addIntChanger(int *value,QWidget *tab,QGridLayout *g,int x,int y,
	int resId,bool bEnabled=true,int lowLimit=-1,int highLimit=-1)
{
	_debug_entertrace("addIntChanger");
	KviNewIntChanger *w=new KviNewIntChanger(this,tab,value,bEnabled,lowLimit,highLimit);
	addWidget(w,g,x,y);
	addQuickHelp(w,resId);
	_debug_leavetrace("addIntChanger");
	return w;
}

//============ addUIntChanger =============//

KviNewUIntChanger * KviNewOptBaseDialog::addUIntChanger(uint *value,QWidget *tab,QGridLayout *g,int x,int y,
	int resId,bool bEnabled=true,int lowLimit=-1,int highLimit=-1)
{
	_debug_entertrace("addIntChanger");
	KviNewUIntChanger *w=new KviNewUIntChanger(this,tab,value,bEnabled,lowLimit,highLimit);
	addWidget(w,g,x,y);
	addQuickHelp(w,resId);
	_debug_leavetrace("addIntChanger");
	return w;
}

//============ addShortIntChanger =============//

KviNewShortIntChanger * KviNewOptBaseDialog::addShortIntChanger(unsigned short int *value,QWidget *tab,QGridLayout *g,int x,int y,
	int resId,bool bEnabled=true,int lowLimit=-1,int highLimit=-1)
{
	_debug_entertrace("addShortIntChanger");
	KviNewShortIntChanger *w=new KviNewShortIntChanger(this,tab,value,bEnabled,lowLimit,highLimit);
	addWidget(w,g,x,y);
	addQuickHelp(w,resId);
	_debug_leavetrace("addShortIntChanger");
	return w;
}
//============ addQuickHelp ============//

void KviNewOptBaseDialog::addQuickHelp(QWidget *w,int resId)
{
	_debug_entertrace("addQuickHelp");
	addKviQuickHelp(w,KVI_QH_DLG_OPTIONS,resId);
	_debug_leavetrace("addQuickHelp");
}

//============ addLabel ============//

QLabel * KviNewOptBaseDialog::addLabel(const char *text,QWidget *tab,QGridLayout *g,int x,int y,int x1,int y1)
{
	_debug_entertrace("addLabel");
	QLabel *l=new QLabel(text,tab);
	addWidget(l,g,x,y,x1,y1);
	_debug_leavetrace("addLabel");
	return l;
}

///////////////////////////////////////////////////////////////////////////////////////////
// KviNewOptDialog
///////////////////////////////////////////////////////////////////////////////////////////

//============ KviNewOptDialog ============//

KviNewOptDialog::KviNewOptDialog(KviFrame *lpFrm,KviOptions *lpOpt)
:KviNewOptBaseDialog(lpFrm,lpOpt)
{
	_debug_entertrace("KviNewOptDialog");

	setCaption("Misc options");
	//
	// Messages tab
	//

	QWidget *tab=new QWidget(this);
	QGridLayout *g=new QGridLayout(tab,9,2,10,4);

	lpCaption  = addLined(m_lpOpt->szCaption.data(),tab,g,0,1,KVI_QH_RES_CAPTION_LINED);
	lpQuit     = addLined(m_lpOpt->szQuitMsg.data(),tab,g,1,1,KVI_QH_RES_QUIT_LINED);
	lpPart     = addLined(m_lpOpt->szPartMsg.data(),tab,g,2,1,KVI_QH_RES_PART_LINED);
	lpKick     = addLined(m_lpOpt->szKickMsg.data(),tab,g,3,1,KVI_QH_RES_KICK_LINED);
	lpAway     = addLined(m_lpOpt->szAwayMsg.data(),tab,g,4,1,KVI_QH_RES_AWAY_LINED);
	lpFinger   = addLined(m_lpOpt->szFinger.data(),tab,g,5,1,KVI_QH_RES_FINGER_LINED);
	lpUserInfo = addLined(m_lpOpt->szUserInfo.data(),tab,g,6,1,KVI_QH_RES_USERINFO_LINED);
	lpScript   = addLined(m_lpOpt->szScriptVer.data(),tab,g,7,1,KVI_QH_RES_SCRIPT_LINED);
	lpStatus   = addLined(m_lpOpt->szStatusMsg.data(),tab,g,8,1,KVI_QH_RES_STATUS_LINED);

	addLabel(i18n("Caption text"),tab,g,0,0);
	addLabel(i18n("Quit message"),tab,g,1,0);
	addLabel(i18n("Part message"),tab,g,2,0);
	addLabel(i18n("Kick message"),tab,g,3,0);
	addLabel(i18n("Away message"),tab,g,4,0);
	addLabel(i18n("Finger reply"),tab,g,5,0);
	addLabel(i18n("Userinfo reply"),tab,g,6,0);
	addLabel(i18n("Script version"),tab,g,7,0);
	addLabel(i18n("Status bar text"),tab,g,8,0);

	g->setColStretch(1,2);
	g->activate();

	addTab(tab,i18n("Messages"));

	//
	// Protection tab
	//

	tab=new QWidget(this);
	g=new QGridLayout(tab,8,5,10,4);

	addLabel(i18n("Allow max"),tab,g,0,0);
	addIntChanger(&(m_lpOpt->iMaxCTCP),tab,g,0,1,KVI_QH_RES_MAXCTCP_LINED,true,0,9999);
	addLabel(i18n("ctcp request(s) in"),tab,g,0,2);
	addIntChanger(&(m_lpOpt->iTimerCTCP),tab,g,0,3,KVI_QH_RES_TIMERCTCP_LINED,true,0,9999);
	addLabel(i18n("second(s)"),tab,g,0,4);

	KSeparator *sep=new KSeparator(KSeparator::HLine,tab);
	addWidget(sep,g,1,1,0,4);

	addLabel(i18n("Bring 'Peace & Love' to your #channel : avoid using the settings below :)"),tab,g,2,2,0,4);

	addLabel(i18n("Event_OnMassOp fires after"),tab,g,3,0);
	addUIntChanger(&(m_lpOpt->massOpDeadline),tab,g,3,1,KVI_QH_RES_MASSOPDEADLINE_LINED,true,2,99999);
	addLabel(i18n("op(s) in"),tab,g,3,2);
	addUIntChanger(&(m_lpOpt->massOpTime),tab,g,3,3,KVI_QH_RES_MASSOPTIME_LINED,true,100,99999);
	addLabel(i18n("millisecond(s)"),tab,g,3,4);

	addLabel(i18n("Event_OnMassBan fires after"),tab,g,4,0);
	addUIntChanger(&(m_lpOpt->massBanDeadline),tab,g,4,1,KVI_QH_RES_MASSBANDEADLINE_LINED,true,2,99999);
	addLabel(i18n("ban(s) in"),tab,g,4,2);
	addUIntChanger(&(m_lpOpt->massBanTime),tab,g,4,3,KVI_QH_RES_MASSBANTIME_LINED,true,100,99999);
	addLabel(i18n("millisecond(s)"),tab,g,4,4);

	addLabel(i18n("Event_OnMassDeop fires after"),tab,g,5,0);
	addUIntChanger(&(m_lpOpt->massDeopDeadline),tab,g,5,1,KVI_QH_RES_MASSDEOPDEADLINE_LINED,true,2,99999);
	addLabel(i18n("deop(s) in"),tab,g,5,2);
	addUIntChanger(&(m_lpOpt->massDeopTime),tab,g,5,3,KVI_QH_RES_MASSDEOPTIME_LINED,true,100,99999);
	addLabel(i18n("millisecond(s)"),tab,g,5,4);

	addLabel(i18n("Event_OnMassKick fires after"),tab,g,6,0);
	addUIntChanger(&(m_lpOpt->massKickDeadline),tab,g,6,1,KVI_QH_RES_MASSKICKDEADLINE_LINED,true,2,99999);
	addLabel(i18n("kick(s) in"),tab,g,6,2);
	addUIntChanger(&(m_lpOpt->massKickTime),tab,g,6,3,KVI_QH_RES_MASSKICKTIME_LINED,true,100,99999);
	addLabel(i18n("millisecond(s)"),tab,g,6,4);

	addLabel(i18n("Event_OnPublicFlood fires after"),tab,g,7,0);
	addUIntChanger(&(m_lpOpt->publicFloodDeadline),tab,g,7,1,KVI_QH_RES_PUBLICFLOODDEADLINE_LINED,true,2,99999);
	addLabel(i18n("line(s) in"),tab,g,7,2);
	addUIntChanger(&(m_lpOpt->publicFloodTime),tab,g,7,3,KVI_QH_RES_PUBLICFLOODTIME_LINED,true,100,99999);
	addLabel(i18n("millisecond(s)"),tab,g,7,4);

	g->activate();

	addTab(tab,i18n("Protection"));

	//
	// Charset map
	//

	tab=new QWidget(this);
	g=new QGridLayout(tab,5,1,10,4);

	KviNewBoolChanger *b1;
	KviNewBoolChanger *b2;

	b1=addBoolChanger(i18n("Use charset translation map (You need the correct font too.)"),tab,g,&(m_lpOpt->bUseTranslation),0,0,KVI_QH_RES_USETRANSLATION_CHK);

	QString szText=i18n("Map file : ");
	szText+=m_lpOpt->szTranslationFile.data();
	QLabel *l1=addLabel(szText.data(),tab,g,1,0);
	connect(this,SIGNAL(translationMapChanged(const char *)),l1,SLOT(setText(const char *)));
	connect(b1,SIGNAL(toggled(bool)),l1,SLOT(setEnabled(bool)));
	l1->setEnabled(m_lpOpt->bUseTranslation);

	QPushButton *bt=new QPushButton(i18n("Choose translation file..."),tab);
	addWidget(bt,g,2,0);
	connect(bt,SIGNAL(clicked()),this,SLOT(changeTranslationMap()));
	connect(b1,SIGNAL(toggled(bool)),bt,SLOT(setEnabled(bool)));
	bt->setEnabled(m_lpOpt->bUseTranslation);

	b2=addBoolChanger(i18n("Skip translation for DCC Chat outgoing data"),tab,g,&(m_lpOpt->bNotTranslateDCC),3,0,KVI_QH_RES_DONOTTRANSLATEDCC_CHK,m_lpOpt->bUseTranslation);
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setEnabled(bool)));

	sep=new KSeparator(KSeparator::HLine,tab);
	addWidget(sep,g,4,0);

	g->activate();

	addTab(tab,i18n("Charset translation"));

	//
	// Commandline
	//

	tab=new QWidget(this);
	g=new QGridLayout(tab,10,4,10,4);

	QString szPrefix="";
	szPrefix+=m_lpOpt->chPersonalCommandPrefix;
	lpCmdPrefix = addLined(szPrefix.data(),tab,g,0,3,KVI_QH_RES_CMDPREFIX_LINED);
	lpCmdPrefix->setMaxLength(1);
	addLabel(i18n("Personal command prefix"),tab,g,0,0,0,2);

	addBoolChanger(i18n("Popup color box on CTRL+K"),tab,g,&(m_lpOpt->bShowColorBox),1,1,KVI_QH_RES_POPUPCTRLK_CHK,true,0,3);
	addBoolChanger(i18n("Auto nick completion on return ('Ni: text'->'Nick: text')"),tab,g,&(m_lpOpt->bAutoNickCompletion),2,2,KVI_QH_RES_AUTONICKCOMPLETION_CHK,true,0,3);
	addBoolChanger(i18n("Identifiers parsing off by default"),tab,g,&(m_lpOpt->bIdentParsingOff),3,3,KVI_QH_RES_IDENTPARSINGOFF_CHK,true,0,3);

	sep=new KSeparator(KSeparator::HLine,tab);
	addWidget(sep,g,4,4,0,3);

	lpUserBuf[1] = addLined(m_lpOpt->szTextUserBuffer[1].data(),tab,g,5,1,KVI_QH_RES_TEXTUSERBUF_LINED);
	lpUserBuf[2] = addLined(m_lpOpt->szTextUserBuffer[2].data(),tab,g,6,1,KVI_QH_RES_TEXTUSERBUF_LINED);
	lpUserBuf[3] = addLined(m_lpOpt->szTextUserBuffer[3].data(),tab,g,7,1,KVI_QH_RES_TEXTUSERBUF_LINED);
	lpUserBuf[4] = addLined(m_lpOpt->szTextUserBuffer[4].data(),tab,g,8,1,KVI_QH_RES_TEXTUSERBUF_LINED);
	lpUserBuf[5] = addLined(m_lpOpt->szTextUserBuffer[5].data(),tab,g,9,1,KVI_QH_RES_TEXTUSERBUF_LINED);

	addLabel(i18n("CTRL+1"),tab,g,5,0);
	addLabel(i18n("CTRL+2"),tab,g,6,0);
	addLabel(i18n("CTRL+3"),tab,g,7,0);
	addLabel(i18n("CTRL+4"),tab,g,8,0);
	addLabel(i18n("CTRL+5"),tab,g,9,0);

	lpUserBuf[6] = addLined(m_lpOpt->szTextUserBuffer[6].data(),tab,g,5,3,KVI_QH_RES_TEXTUSERBUF_LINED);
	lpUserBuf[7] = addLined(m_lpOpt->szTextUserBuffer[7].data(),tab,g,6,3,KVI_QH_RES_TEXTUSERBUF_LINED);
	lpUserBuf[8] = addLined(m_lpOpt->szTextUserBuffer[8].data(),tab,g,7,3,KVI_QH_RES_TEXTUSERBUF_LINED);
	lpUserBuf[9] = addLined(m_lpOpt->szTextUserBuffer[9].data(),tab,g,8,3,KVI_QH_RES_TEXTUSERBUF_LINED);
	lpUserBuf[0] = addLined(m_lpOpt->szTextUserBuffer[0].data(),tab,g,9,3,KVI_QH_RES_TEXTUSERBUF_LINED);

	addLabel(i18n("CTRL+6"),tab,g,5,2);
	addLabel(i18n("CTRL+7"),tab,g,6,2);
	addLabel(i18n("CTRL+8"),tab,g,7,2);
	addLabel(i18n("CTRL+9"),tab,g,8,2);
	addLabel(i18n("CTRL+0"),tab,g,9,2);

	g->activate();

	addTab(tab,i18n("Commandline"));


	tab=new QWidget(this);
	g=new QGridLayout(tab,5,2,10,4);

	//url catcher

	b1 = addBoolChanger(i18n("Run browser on url double click"),tab,g,(&m_lpOpt->bRunBrowserOnUrl),0,0,KVI_QH_RES_UNDEFINED,true,0,1);
	b2 = addBoolChanger(i18n("Use netscape remote control instead of running the program below"),tab,g,(&m_lpOpt->bUseNetscape),1,1,KVI_QH_RES_UNDEFINED,m_lpOpt->bRunBrowserOnUrl,0,1);

	l1 = addLabel(i18n("Browser commandline (use % as filename)"),tab,g,2,0);
	l1->setEnabled(m_lpOpt->bRunBrowserOnUrl);

	lpBrowserCmd  = addLined(m_lpOpt->szBrowserCmdLine.data(),tab,g,2,1,KVI_QH_RES_UNDEFINED);
	lpBrowserCmd->setEnabled(m_lpOpt->bRunBrowserOnUrl);

	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setEnabled(bool)));
	connect(b1,SIGNAL(toggled(bool)),l1,SLOT(setEnabled(bool)));
	connect(b1,SIGNAL(toggled(bool)),lpBrowserCmd,SLOT(setEnabled(bool)));

	sep=new KSeparator(KSeparator::HLine,tab);
	addWidget(sep,g,3,3,0,1);

	b1 = addBoolChanger(i18n("Highlight urls using the mIrc color (0-15)"),tab,g,(&m_lpOpt->bHighlightUrl),4,0,KVI_QH_RES_UNDEFINED,true);
	lpUrlColor = addLined(&(m_lpOpt->urlHighlightForeColor),tab,g,4,1,KVI_QH_RES_UNDEFINED);
	lpUrlColor->setEnabled(m_lpOpt->bHighlightUrl);
	connect(b1,SIGNAL(toggled(bool)),lpUrlColor,SLOT(setEnabled(bool)));


	addTab(tab,i18n("Url catcher"));

//////////////////////

	tab=new QWidget(this);
	g=new QGridLayout(tab,10,1,10,4);

	addBoolChanger(i18n("Enable clone scan on join"),tab,g,&(m_lpOpt->bCloneScanOnJoin),0,0,KVI_QH_RES_UNDEFINED);
	addBoolChanger(i18n("Show inverse colored nick in channel messages"),tab,g,&(m_lpOpt->bInverseNick),1,0,KVI_QH_RES_UNDEFINED);
	addBoolChanger(i18n("Prefix channel messages with ':'"),tab,g,&(m_lpOpt->bPrefixMsg),2,0,KVI_QH_RES_UNDEFINED);
	addBoolChanger(i18n("Autorejoin channel when kicked"),tab,g,&(m_lpOpt->bAutoRejoinOnKick),3,0,KVI_QH_RES_UNDEFINED);
	addBoolChanger(i18n("Timestamp messages on the output box"),tab,g,&(m_lpOpt->bTimestamp),4,0,KVI_QH_RES_UNDEFINED);
	addBoolChanger(i18n("Align text after a line break"),tab,g,&(m_lpOpt->bAlignText),5,0,KVI_QH_RES_UNDEFINED);
	addBoolChanger(i18n("Show message-images in the output box"),tab,g,&(m_lpOpt->bShowPixmaps),6,0,KVI_QH_RES_UNDEFINED);
	addBoolChanger(i18n("Auto join channel when invited"),tab,g,&(m_lpOpt->bAutoJoinOnInvite),7,0,KVI_QH_RES_UNDEFINED);
	addBoolChanger(i18n("Private notices to active window"),tab,g,&(m_lpOpt->bPrivNoticeToActive),8,0,KVI_QH_RES_UNDEFINED);
	addBoolChanger(i18n("Ctcp requests to active window"),tab,g,&(m_lpOpt->bCtcpRequestsToActive),9,0,KVI_QH_RES_UNDEFINED);

	addTab(tab,i18n("Misc 1"));

	tab=new QWidget(this);
	g=new QGridLayout(tab,10,2,10,4);

	addBoolChanger(i18n("Auto log channels"),tab,g,&(m_lpOpt->bAutoLogChannels),0,0,KVI_QH_RES_UNDEFINED,true,0,1);
	addBoolChanger(i18n("Auto log queries"),tab,g,&(m_lpOpt->bAutoLogQueries),1,1,KVI_QH_RES_UNDEFINED,true,0,1);
	addBoolChanger(i18n("Auto log chats"),tab,g,&(m_lpOpt->bAutoLogChats),2,2,KVI_QH_RES_UNDEFINED,true,0,1);
	addBoolChanger(i18n("Auto minimize query windows"),tab,g,&(m_lpOpt->bMinimizeQuery),3,3,KVI_QH_RES_UNDEFINED,true,0,1);
	addBoolChanger(i18n("Beep on private conversation requests"),tab,g,&(m_lpOpt->bBeepOnPrivmsg),4,4,KVI_QH_RES_UNDEFINED,true,0,1);
	addBoolChanger(i18n("Beep on DCC requests"),tab,g,&(m_lpOpt->bBeepOnDCCRequest),5,5,KVI_QH_RES_UNDEFINED,true,0,1);
	addBoolChanger(i18n("Beep on CTCP requests"),tab,g,&(m_lpOpt->bBeepOnCTCPRequest),6,6,KVI_QH_RES_UNDEFINED,true,0,1);

	b1 = addBoolChanger(i18n("Enable user list update every (seconds)"),tab,g,&(m_lpOpt->bEnableUserListUpdate),7,0,KVI_QH_RES_UNDEFINED);
	KviNewIntChanger *ic = addIntChanger(&(m_lpOpt->iUserListUpdateTime),tab,g,7,1,KVI_QH_RES_UNDEFINED,m_lpOpt->bEnableUserListUpdate,1,9999);
	connect(b1,SIGNAL(toggled(bool)),ic,SLOT(setEnabled(bool)));

	addLabel(i18n("Max file requests"),tab,g,8,0);
	addIntChanger(&(m_lpOpt->iMaxFileRequests),tab,g,8,1,KVI_QH_RES_UNDEFINED,true,1,9999);

	addLabel(i18n("Local Ip address"),tab,g,9,0);
	lpLocalIp = addLined(m_lpOpt->szLocalIp.data(),tab,g,9,1,KVI_QH_RES_UNDEFINED);

	addTab(tab,i18n("Misc 2"));

	tab=new QWidget(this);
	g=new QGridLayout(tab,8,2,10,4);

	b1 = addBoolChanger(i18n("Listen to CTCP sound"),tab,g,(&m_lpOpt->bListenToCtcpSound),0,0,KVI_QH_RES_UNDEFINED,true,0,1);
	b2 = addBoolChanger(i18n("Play default.wav on Ctcp sound , when file not found"),tab,g,(&m_lpOpt->bPlayDefSound),1,1,KVI_QH_RES_UNDEFINED,m_lpOpt->bListenToCtcpSound,0,1);
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setEnabled(bool)));
	b2 = addBoolChanger(i18n("Send !nick <soundname> request on sound file not found"),tab,g,(&m_lpOpt->bSendSoundRequest),2,2,KVI_QH_RES_UNDEFINED,m_lpOpt->bListenToCtcpSound,0,1);
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setEnabled(bool)));
	b2 = addBoolChanger(i18n("Listen to !nick <soundname> requests."),tab,g,(&m_lpOpt->bListenToFileRequest),3,3,KVI_QH_RES_UNDEFINED,m_lpOpt->bListenToCtcpSound,0,1);
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setEnabled(bool)));
	b1 = addBoolChanger(i18n("Au player command line (%=file)"),tab,g,&(m_lpOpt->bExternalAuPlayer),4,0,KVI_QH_RES_UNDEFINED);
	lpAuPlayerCmd  = addLined(m_lpOpt->szAuPlayerCmd.data(),tab,g,4,1,KVI_QH_RES_UNDEFINED);
	lpAuPlayerCmd->setEnabled(m_lpOpt->bExternalAuPlayer);
	connect(b1,SIGNAL(toggled(bool)),lpAuPlayerCmd,SLOT(setEnabled(bool)));
	b1 = addBoolChanger(i18n("Mid player command line (%=file)"),tab,g,&(m_lpOpt->bExternalMidPlayer),5,0,KVI_QH_RES_UNDEFINED);
	lpMidPlayerCmd  = addLined(m_lpOpt->szMidPlayerCmd.data(),tab,g,5,1,KVI_QH_RES_UNDEFINED);
	lpMidPlayerCmd->setEnabled(m_lpOpt->bExternalMidPlayer);
	connect(b1,SIGNAL(toggled(bool)),lpMidPlayerCmd,SLOT(setEnabled(bool)));
	b1 = addBoolChanger(i18n("Mp3 player command line (%=file)"),tab,g,&(m_lpOpt->bExternalMp3Player),6,0,KVI_QH_RES_UNDEFINED);
	lpMp3PlayerCmd  = addLined(m_lpOpt->szMp3PlayerCmd.data(),tab,g,6,1,KVI_QH_RES_UNDEFINED);
	lpMp3PlayerCmd->setEnabled(m_lpOpt->bExternalMp3Player);
	connect(b1,SIGNAL(toggled(bool)),lpMp3PlayerCmd,SLOT(setEnabled(bool)));
	b1 = addBoolChanger(i18n("Wav player command line (%=file)"),tab,g,&(m_lpOpt->bExternalWavPlayer),7,0,KVI_QH_RES_UNDEFINED);
	lpWavPlayerCmd  = addLined(m_lpOpt->szWavPlayerCmd.data(),tab,g,7,1,KVI_QH_RES_UNDEFINED);
	lpWavPlayerCmd->setEnabled(m_lpOpt->bExternalWavPlayer);
	connect(b1,SIGNAL(toggled(bool)),lpWavPlayerCmd,SLOT(setEnabled(bool)));




	addTab(tab,i18n("Sound"));

	setCancelButton();
	connect(this,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
	_debug_leavetrace("KviNewOptDialog");
}

//============ ~KviNewOptDialog ============//

KviNewOptDialog::~KviNewOptDialog()
{
	_debug_entertrace("~KviNewOptDialog");
	_debug_leavetrace("~KviNewOptDialog");
}

//============ changeTranslationMap ============//

void KviNewOptDialog::changeTranslationMap()
{
	_debug_entertrace("changeTranslationMap");
	QString szHome(_macro_getKVircHomeDirectory("Translation"));
	QString szCmd=QString(_macro_getOpenFileName(i18n("Open translation map file..."),szHome.data(),0));
	if(!szCmd.isEmpty()){
		if(m_lpFrm->m_lpTranslator->setTranslationMap(szCmd.data())){
			m_lpOpt->szTranslationFile=szCmd.data();
			QString szText=i18n("Map file : ");
			szText+=m_lpOpt->szTranslationFile.data();
			emit translationMapChanged(szText.data());
		} else {
			m_lpFrm->m_lpTranslator->setDefaultTranslationMap();
			m_lpOpt->szTranslationFile=i18n(KVI_STR_NONE);
			QString szText=i18n("Map file : ");
			szText+=KVI_STR_NONE;
			emit translationMapChanged(szText.data());
		}
	}
	_debug_leavetrace("changeTranslationMap");
}
//============ applySlot ============//

void KviNewOptDialog::applySlot()
{
	_debug_entertrace("applySlot");
	//Messages tab (1)
	m_lpOpt->szCaption  =(lpCaption->text()   ? lpCaption->text() : "");
	m_lpOpt->szQuitMsg  =(lpQuit->text()      ? lpQuit->text()    : "");
	m_lpOpt->szPartMsg  =(lpPart->text()      ? lpPart->text()    : "");
	m_lpOpt->szKickMsg  =(lpKick->text()      ? lpKick->text()    : "");
	m_lpOpt->szFinger   =(lpFinger->text()    ? lpFinger->text()  : "");
	m_lpOpt->szAwayMsg  =(lpAway->text()      ? lpAway->text()    : "");
	m_lpOpt->szUserInfo =(lpUserInfo->text()  ? lpUserInfo->text(): "");
	m_lpOpt->szScriptVer=(lpScript->text()    ? lpScript->text()  : "");
	m_lpOpt->szStatusMsg=(lpStatus->text()    ? lpStatus->text()  : "");
	m_lpOpt->szBrowserCmdLine =(lpBrowserCmd->text() ? lpBrowserCmd->text() : "");
	m_lpOpt->szAuPlayerCmd = (lpAuPlayerCmd->text() ? lpAuPlayerCmd->text() : "");
	m_lpOpt->szMidPlayerCmd = (lpMidPlayerCmd->text() ? lpMidPlayerCmd->text() : "");
	m_lpOpt->szMp3PlayerCmd = (lpMp3PlayerCmd->text() ? lpMp3PlayerCmd->text() : "");
	m_lpOpt->szWavPlayerCmd = (lpWavPlayerCmd->text() ? lpWavPlayerCmd->text() : "");
	m_lpOpt->szLocalIp = (lpLocalIp->text() ? lpLocalIp->text() : "");

	if(!strcasecmp(m_lpOpt->szTranslationFile.data(),KVI_STR_NONE))m_lpOpt->bUseTranslation=false;
	//Command prefix
	QString szPrfx      =(lpCmdPrefix->text() ? lpCmdPrefix->text():"");
	if(!szPrfx.isEmpty() && (szPrfx.length()==1))m_lpOpt->chPersonalCommandPrefix=szPrfx[0];
	else m_lpOpt->chPersonalCommandPrefix='/';

	for(int i=0;i<10;i++){
		m_lpOpt->szTextUserBuffer[i]=(lpUserBuf[i]->text() ? lpUserBuf[i]->text() : "");
	}
	QString szUrl = lpUrlColor->text() ? lpUrlColor->text() : "15";
	bool bOk = false;
	m_lpOpt->urlHighlightForeColor = szUrl.toInt(&bOk);
	if((m_lpOpt->urlHighlightForeColor < 0) || (m_lpOpt->urlHighlightForeColor > 15) || (!bOk))m_lpOpt->urlHighlightForeColor = 15;
	accept();
	_debug_leavetrace("applySlot");
}

///////////////////////////////////////////////////////////////////////////////////////////
// KviNewOptDccDialog
///////////////////////////////////////////////////////////////////////////////////////////

//============ KviNewDccOptDialog ============//

KviNewDccOptDialog::KviNewDccOptDialog(KviFrame *lpFrm,KviOptions *lpOpt)
:KviNewOptBaseDialog(lpFrm,lpOpt)
{
	_debug_entertrace("KviNewDccOptDialog");

	setCaption("DCC Options");

	//
	// General tab
	//

	QWidget *tab=new QWidget(this);
	QGridLayout *g=new QGridLayout(tab,8,2,10,4);

	KviNewBoolChanger *b1;
	KviNewBoolChanger *b2;

	b1=addBoolChanger(i18n("Ignore DCC Chat"),tab,g,&(m_lpOpt->bIgnoreDCCChat),0,0,KVI_QH_RES_IGNORECHAT_CHK);
	b2=addBoolChanger(i18n("Auto accept DCC Chat"),tab,g,&(m_lpOpt->bAutoAcceptDCCChat),0,1,KVI_QH_RES_AUTOCHAT_CHK,!m_lpOpt->bIgnoreDCCChat);
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setNotEnabled(bool)));
	b1=addBoolChanger(i18n("Ignore DCC Send"),tab,g,&(m_lpOpt->bIgnoreDCCSend),1,0,KVI_QH_RES_IGNORESEND_CHK);
	b2=addBoolChanger(i18n("Auto accept DCC Send"),tab,g,&(m_lpOpt->bAutoAcceptDCCSend),1,1,KVI_QH_RES_AUTOSEND_CHK,!m_lpOpt->bIgnoreDCCSend);
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setNotEnabled(bool)));
	b1=addBoolChanger(i18n("Ignore DCC Voice"),tab,g,&(m_lpOpt->bIgnoreDCCVoice),2,0,KVI_QH_RES_IGNOREVOICE_CHK);
	b2=addBoolChanger(i18n("Auto accept DCC Voice"),tab,g,&(m_lpOpt->bAutoAcceptDCCVoice),2,1,KVI_QH_RES_AUTOVOICE_CHK,!m_lpOpt->bIgnoreDCCVoice);
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setNotEnabled(bool)));
	b1=addBoolChanger(i18n("Auto close DCC Send window"),tab,g,&(m_lpOpt->bAutoCloseDCCChatOnSuccess),3,0,KVI_QH_RES_CLOSESEND_CHK);
	b2=addBoolChanger(i18n("Minimize DCC Send window"),tab,g,&(m_lpOpt->bMinimizeDCCSend),3,1,KVI_QH_RES_MINIMIZESEND_CHK);

	KSeparator *sep=new KSeparator(KSeparator::HLine,tab);
	addWidget(sep,g,4,4,0,1);

	addLabel(i18n("Dcc request timeout [10-9999 sec.]"),tab,g,5,0);
	addIntChanger(&(m_lpOpt->iDCCCHATTimeout),tab,g,5,1,KVI_QH_RES_CHATTIMEOUT_LINED,true,10,9999);

	addLabel(i18n("Dcc Send packet size [64-4096 bytes]"),tab,g,6,0);
	KviNewNumericValueSelector *s=new KviNewNumericValueSelector(this,tab,&(m_lpOpt->iDCCSendPacketSize),
		"64 128 256 384 512 768 1024 1536 2048 2560 3072 4096",i18n("bytes per packet"),512,true);
	addWidget(s,g,6,1);
	addQuickHelp(s,KVI_QH_RES_SENDPACKET_COMBO);

	b1=addBoolChanger(i18n("Enable Fast DCC Send using"),tab,g,&(m_lpOpt->bUseFastSend),7,0,KVI_QH_RES_USEFASTSEND_CHK);
	s=new KviNewNumericValueSelector(this,tab,&(m_lpOpt->iFSPacketsPerSec),
		"1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20",i18n("packets per second"),5,m_lpOpt->bUseFastSend);
	addWidget(s,g,7,1);
	addQuickHelp(s,KVI_QH_RES_FASTSENDPACKETS_COMBO);
	connect(b1,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));

	g->activate();

	addTab(tab,i18n("General settings"));

	//
	// DCC Daemon
	//

	tab=new QWidget(this);
	g=new QGridLayout(tab,6,2,10,4);

	b1=addBoolChanger(i18n("Enable DCC Daemon"),tab,g,&(m_lpOpt->bUseDCCDaemon),
		0,0,KVI_QH_RES_DCCDAEMON_CHK,true,0,1);

	QLabel *l1=addLabel(i18n("Listen on port"),tab,g,1,0);
	l1->setEnabled(m_lpOpt->bUseDCCDaemon);
	connect(b1,SIGNAL(toggled(bool)),l1,SLOT(setEnabled(bool)));
	
	KviNewShortIntChanger *i1=addShortIntChanger(&(m_lpOpt->iDCCDaemonPort),tab,g,1,1,KVI_QH_RES_DCCDAEMONPORT_LINED,m_lpOpt->bUseDCCDaemon,1,16383);
	connect(b1,SIGNAL(toggled(bool)),i1,SLOT(setEnabled(bool)));

	l1=addLabel(i18n("Login timeout (seconds)"),tab,g,2,0);
	l1->setEnabled(m_lpOpt->bUseDCCDaemon);
	connect(b1,SIGNAL(toggled(bool)),l1,SLOT(setEnabled(bool)));

	KviNewIntChanger *i2=addIntChanger(&(m_lpOpt->iDCCDLoginTimeout),tab,g,2,1,KVI_QH_RES_DCCDLOGINTIMEOUT_LINED,m_lpOpt->bUseDCCDaemon,10,9999);
	connect(b1,SIGNAL(toggled(bool)),i2,SLOT(setEnabled(bool)));

	sep=new KSeparator(KSeparator::HLine,tab);
	addWidget(sep,g,3,3,0,1);

	b2=addBoolChanger(i18n("DCC Chat service available"),tab,g,&(m_lpOpt->bDCCChatServiceAvailable),
		4,4,KVI_QH_RES_DCCDAEMONCHAT_CHK,m_lpOpt->bUseDCCDaemon,0,1);
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setEnabled(bool)));

	b2=addBoolChanger(i18n("DCC Send service available"),tab,g,&(m_lpOpt->bDCCSendServiceAvailable),
		5,5,KVI_QH_RES_DCCDAEMONSEND_CHK,m_lpOpt->bUseDCCDaemon,0,1);
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setEnabled(bool)));

	g->activate();

	addTab(tab,i18n("DCC Daemon"));

	//
	// DCC Message of the day
	//

	tab=new QWidget(this);
	g=new QGridLayout(tab,2,2,10,4);

	lpShowMotdInDcc = addBoolChanger(i18n("Send MOTD on Incoming DCC Chat"),tab,g,&(m_lpOpt->bShowMotdOnInDcc),0,0,KVI_QH_RES_MOTDIN_CHK);
	lpShowMotdOutDcc= addBoolChanger(i18n("Send MOTD on Outgoing DCC Chat"),tab,g,&(m_lpOpt->bShowMotdOnOutDcc),0,1,KVI_QH_RES_MOTDOUT_CHK);

	connect(lpShowMotdInDcc,SIGNAL(toggled(bool)),this,SLOT(enableMotd(bool)));
	connect(lpShowMotdOutDcc,SIGNAL(toggled(bool)),this,SLOT(enableMotd(bool)));

	lpMotd=new QMultiLineEdit(tab);
	if(!m_lpOpt->lpListDccMotd->isEmpty()){
		const char *szS=0;
		for(szS=m_lpOpt->lpListDccMotd->first();szS;szS=m_lpOpt->lpListDccMotd->next()){
			lpMotd->append(szS);
		}
	}
	lpMotd->adjustSize();
	QSize sz(50,50);
	lpMotd->setMinimumSize((lpMotd->height() > 50) ? lpMotd->size() : sz);
	g->addMultiCellWidget(lpMotd,1,1,0,1);
	addQuickHelp(lpMotd,KVI_QH_RES_MOTD_MLINED);

	enableMotd(true);

	g->setRowStretch(1,2);
	g->activate();

	addTab(tab,i18n("Message of the day"));

	setCancelButton();

	connect(this,SIGNAL(applyButtonPressed()),this,SLOT(applySlot()));
	_debug_leavetrace("KviNewDccOptDialog");
}

//============ ~KviNewDccOptDialog ============//

KviNewDccOptDialog::~KviNewDccOptDialog()
{
	_debug_entertrace("~KviNewDccOptDialog");
	_debug_leavetrace("~KviNewDccOptDialog");
}

//============ enableMotd ============//

void KviNewDccOptDialog::enableMotd(bool)
{
	_debug_entertrace("enableMotd");
	lpMotd->setEnabled(lpShowMotdInDcc->isChecked() || lpShowMotdOutDcc->isChecked());
	_debug_leavetrace("enableMotd");
}

//============ applySlot ============//

void KviNewDccOptDialog::applySlot()
{
	_debug_entertrace("applySlot");
	//MOTD
	while(!m_lpOpt->lpListDccMotd->isEmpty())m_lpOpt->lpListDccMotd->removeLast();
	int nLines=lpMotd->numLines();
	if(nLines>0){
		for(int i=0;i<nLines;i++){
			const char *szTextLine=lpMotd->textLine(i);
			if(szTextLine){
				QString szLine=szTextLine;
				if(!szLine.isEmpty()){
					int idx=szLine.find('\n');
					if(idx == -1){
						m_lpOpt->lpListDccMotd->append(szLine.data());
					} else {
						szLine.remove(idx,1);
						if(!szLine.isEmpty())m_lpOpt->lpListDccMotd->append(szLine.data());
					}
				}
			}
		}
	}
	accept();
	_debug_leavetrace("applySlot");
}

#include "m_kvi_optdlg.moc"

//
// $Log: kvi_optdlg.cpp,v $
// Revision 1.10  1998/10/06 14:42:39  pragma
// Tons of changes
//
// Revision 1.9  1998/10/01 00:54:47  pragma
// 'Ctcp requests to active window' option added
//
// Revision 1.8  1998/09/28 13:52:00  pragma
// Minor bugfixes
//
// Revision 1.7  1998/09/23 23:15:11  pragma
// Ignore list. Still needs testing.
// Added some ASSERT-Like macros to kvi_chan.cpp and kvi_listbox.cpp
// to discover a strange bug :
// Sometimes the a single nick on a random channel gets wrong username...
// Just like a hollow pointer...but still can't guess how to reproduce it.
// It happened only a couple of times...
//
// Revision 1.6  1998/09/23 12:41:46  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.5  1998/09/20 20:23:22  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.4  1998/09/17 16:14:36  pragma
// Moving to handle mp3 , au and mid files by external players.
//
// Revision 1.3  1998/09/16 17:16:40  fritz
// Starting i18n.
//
// Revision 1.2  1998/09/16 16:13:16  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
