//   $Id: kvi_netscape.cpp,v 1.3 1998/10/06 14:42:35 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.

//
// Source code hacked from :
//
// *
// * remote.c --- remote control of Netscape Navigator for Unix.
// * version 1.1.3, for Netscape Navigator 1.1 and newer.
// *
// * Copyright  1996 Netscape Communications Corporation, all rights reserved.
// * Created: Jamie Zawinski <jwz@netscape.com>, 24-Dec-94.
// *
// * Permission to use, copy, modify, distribute, and sell this software and its
// * documentation for any purpose is hereby granted without fee, provided that
// * the above copyright notice appear in all copies and that both that
// * copyright notice and this permission notice appear in supporting
// * documentation.  No representations are made about the suitability of this
// * software for any purpose.  It is provided "as is" without express or 
// * implied warranty.
// *
//

//
//  The my_XmuClientWindow is a hack of XmuClientWindow from :
//
//  $XConsortium: ClientWin.c,v 1.4 94/04/17 20:15:50 rws Exp $ */
// 
//  Copyright (c) 1989  X Consortium
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
//  X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
//  AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//  Except as contained in this notice, the name of the X Consortium shall not be
//  used in advertising or otherwise to promote the sale, use or other dealings
//  in this Software without prior written authorization from the X Consortium.
//
//

#define _KVI_DEBUG_CLASS_NAME_ "KviNetscapeController"

#include <X11/Xatom.h>

#include "kvi_netscape.h"
#include "kvi_debug.h"
#include "kvi_support.h"

#include <kprocess.h>

//#include <X11/Xmu/WinUtil.h>	/* for XmuClientWindow() */

#define MOZILLA_VERSION_PROP   "_MOZILLA_VERSION"
#define MOZILLA_LOCK_PROP      "_MOZILLA_LOCK"
#define MOZILLA_COMMAND_PROP   "_MOZILLA_COMMAND"
#define MOZILLA_RESPONSE_PROP  "_MOZILLA_RESPONSE"

//============ KviNetscapeController ============//

KviNetscapeController::KviNetscapeController()
{
	_debug_entertrace("KviNetscapeController");
	_debug_leavetrace("KviNetscapeController");
}

//============ ~KviNetscapeController ============//

KviNetscapeController::~KviNetscapeController()
{
	_debug_entertrace("~KviNetscapeController");
	_debug_leavetrace("~KviNetscapeController");
}

//============ openURL ============//

bool KviNetscapeController::openURL(const char *url)
{
	_debug_entertrace("openURL");
	KviNetscapeRemote remote;
	QString szCmd="openURL(";
	szCmd+=url;
	szCmd+=')';
	if(!remote.executeCommand(szCmd.data())){
		//Attempt to run a new Netscape Instance
		KProcess *proc=new KProcess();
		(*proc) << "netscape" << url;
		bool bResult=proc->start(KProcess::DontCare,KProcess::NoCommunication);
		delete proc;
		return bResult;
	} else return true;
	_debug_leavetrace("openURL");
}

//#ifdef _KVI_DEBUG_CLASS_NAME_
//#undef _KVI_DEBUG_CLASS_NAME_
//#endif

//#define _KVI_DEBUG_CLASS_NAME_ "KviNetscapeRemote"

//============ KviNetscapeRemote ============//

KviNetscapeRemote::KviNetscapeRemote()
{
	_debug_entertrace("KviNetscapeRemote");
	window=0;
	m_bInitSuccess=false;
	m_bUsed=false;
	lock_data="";
	XA_MOZILLA_VERSION=0;
	XA_MOZILLA_LOCK   =0;
	XA_MOZILLA_COMMAND=0;
	XA_MOZILLA_COMMAND=0;
	_debug_leavetrace("KviNetscapeRemote");
}

//============ ~KviNetscapeRemote ============//

KviNetscapeRemote::~KviNetscapeRemote()
{
	_debug_entertrace("~KviNetscapeRemote");
	_debug_leavetrace("~KviNetscapeRemote");
}

//============ initialize ============//

bool KviNetscapeRemote::initialize()
{
	_debug_entertrace("initialize");
	if(m_bUsed)return false;
	m_bUsed=true;
	mozillaRemoteInitAtoms();
	window = mozillaRemoteFindWindow();
	if(window)m_bInitSuccess=true;
	return m_bInitSuccess;
	_debug_leavetrace("initialize");
}

//============ mozillaRemoteInitAtoms ============//

void KviNetscapeRemote::mozillaRemoteInitAtoms()
{
	_debug_entertrace("mozillaRemoteInitAtoms");
	Display *dpy=qt_xdisplay();
	if (! XA_MOZILLA_VERSION) XA_MOZILLA_VERSION  = XInternAtom (dpy, MOZILLA_VERSION_PROP, False);
	if (! XA_MOZILLA_LOCK)    XA_MOZILLA_LOCK     = XInternAtom (dpy, MOZILLA_LOCK_PROP, False);
	if (! XA_MOZILLA_COMMAND) XA_MOZILLA_COMMAND  = XInternAtom (dpy, MOZILLA_COMMAND_PROP, False);
	if (! XA_MOZILLA_RESPONSE)XA_MOZILLA_RESPONSE = XInternAtom (dpy, MOZILLA_RESPONSE_PROP, False);
	_debug_leavetrace("mozillaRemoteInitAtoms");
}

//
// Find a window with WM_STATE, else return win itself, as per ICCCM 
//
// This one is here to avoid linkage problems to the Xmu library.
// This is the only function needed from there...so we will be
// able to remove it from the linker library list.
//

//============ my_XmuClientWindow ============//

Window KviNetscapeRemote::my_XmuClientWindow(Display *dpy,Window win)
{
	_debug_entertrace("my_XmuClientWindow");
	Atom WM_STATE;
	Atom type = None;
	int format;
	unsigned long nitems, after;
	unsigned char *data;
	Window inf;
	WM_STATE = XInternAtom(dpy, "WM_STATE", True);
	if (!WM_STATE)return win;
	XGetWindowProperty(dpy,win,WM_STATE,0,0,false,AnyPropertyType,&type, &format, &nitems, &after, &data);
	if (type)return win;
	inf = my_XmuClientWindowTryChildren(dpy, win, WM_STATE);
	if (!inf)inf = win;
	_debug_leavetrace("my_XmuClientWindow");
	return inf;
}

//============ my_XmuClientWindowTryChildren ============//

Window KviNetscapeRemote::my_XmuClientWindowTryChildren(Display *dpy,Window win,Atom WM_STATE)
{
	_debug_entertrace("my_XmuClientWindowTryChildren");
	Window root, parent;
	Window *children;
	unsigned int nchildren;
	unsigned int i;
	Atom type = None;
	int format;
	unsigned long nitems, after;
	unsigned char *data;
	Window inf = 0;
	if (!XQueryTree(dpy, win, &root, &parent, &children, &nchildren))return 0;
	for (i = 0; !inf && (i < nchildren); i++) {
		XGetWindowProperty(dpy,children[i],WM_STATE,0,0,False,AnyPropertyType,&type,&format,&nitems,&after, &data);
		if(type)inf = children[i];
    }
	for (i = 0; !inf && (i < nchildren); i++)inf = my_XmuClientWindowTryChildren(dpy, children[i], WM_STATE);
	if(children)XFree((char *)children);
	_debug_leavetrace("my_XmuClientWindowTryChildren");
	return inf;
}


//============ mozillaRemoteFindWindow ============//

Window KviNetscapeRemote::mozillaRemoteFindWindow()
{
	_debug_entertrace("mozillaRemoteFindWindow");
	Display *dpy=qt_xdisplay();
	Window root = RootWindowOfScreen(DefaultScreenOfDisplay(dpy));
	Window root2, parent, *kids;
	unsigned int nkids;
	Window result = 0;
	Window tenative = 0;
	unsigned char *tenative_version = 0;
	if(!XQueryTree(dpy,root,&root2,&parent,&kids,&nkids))return 0;
	if(!(kids && nkids))return 0;
	for (int i = nkids-1; i >= 0; i--){
		Atom type;
		int format;
		unsigned long nitems, bytesafter;
		unsigned char *version = 0;
		//debug("\nGot kid = %u",kids[i]);
		// solve linking problems
		Window w = my_XmuClientWindow(dpy, kids[i]);
		// solve linking problems
		//debug("After XmuClientWindow = %u",w);
 		int status = XGetWindowProperty (dpy,w,XA_MOZILLA_VERSION,0,(65536 / sizeof (long)),false,XA_STRING,
											&type,&format,&nitems,&bytesafter,&version);
		if(!version)continue;
		if(strcmp ((char *) version, "1.1") && !tenative){
			tenative = w;
			tenative_version = version;
			continue;
		}
		XFree(version);
		if((status == Success) && (type != None)){
//			debug("And it was the right one");
			result = w;
			break;
		}
	}

	if(kids)XFree((char *)kids); //<------...someone forgot to delete it? :)

	if (result && tenative){
		XFree (tenative_version);
		return result;
	} else if (tenative){
		XFree (tenative_version);
		return tenative;
    } else if (result){
		return result;
	} else return 0;
	_debug_leavetrace("mozillaRemoteFindWindow");
}

//============ executeCommand ============//

bool KviNetscapeRemote::executeCommand(const char *command)
{
	_debug_entertrace("executeCommand");
	if(!m_bUsed)initialize();
	if(!m_bInitSuccess)return false;
	Display *dpy=qt_xdisplay();
	int status = 0;
	XSelectInput(dpy, window, (PropertyChangeMask|StructureNotifyMask));
	if(!mozillaRemoteObtainLock())return false;
	else status = mozillaRemoteCommand (command);
	/* When status = 6, it means the window has been destroyed */
	/* It is invalid to free the lock when window is destroyed. */
	if ( status != 6 )mozillaRemoteFreeLock();
	return (status==0);
	_debug_leavetrace("executeCommand");
}

//============ mozillaRemoteObtainLock ============//

bool KviNetscapeRemote::mozillaRemoteObtainLock()
{
	_debug_entertrace("mozillaRemoteObtainLock");
	Display *dpy=qt_xdisplay();
	Bool locked = false;
	Bool waited = false;
	if (lock_data.isEmpty()){
		char hnm[101];
		bzero(hnm,101);
		lock_data.sprintf("pid%d@", getpid ());
		int bytescopied=gethostname (hnm, 100); //return false;
		if(bytescopied<0)return false;
		QString szHnm(hnm,bytescopied+1);
		lock_data+=szHnm;
		
    }
	int tentatives=150; //maybe to much.....when unlycky 150 blocking tentatives may take too much time
	do{
		int result;
		Atom actual_type;
		int actual_format;
		unsigned long nitems, bytes_after;
		unsigned char *data = 0;
//		debug("TENTATIVE");
		XGrabServer (dpy);   /* ################################# DANGER! */
		// check if we can lock it
//		debug("GRABBED");
		result = XGetWindowProperty(dpy,window,XA_MOZILLA_LOCK,0,(65536 / sizeof (long)),false,XA_STRING,
										&actual_type, &actual_format,&nitems, &bytes_after,&data);
//		debug("GOT PROPERTY");
		if (result != Success || actual_type == None){
			//Yes, we can lock
//			debug("CAN LOCK");
			XChangeProperty(dpy,window,XA_MOZILLA_LOCK,XA_STRING,8,PropModeReplace,
									(unsigned char *) lock_data.data(),lock_data.length());
//			debug("CANT LOCK");
			locked = true;
		}
//		debug("UNGRABBING");
		XUngrabServer (dpy); /* ################################# danger over */
//		debug("UNGRABBED");
		XSync (dpy, false);
//		debug("SYNChED");
		if (!locked){
			waited = true;
			while (1){
				XEvent event;
				XNextEvent (dpy, &event);
				if (event.xany.type == DestroyNotify && event.xdestroywindow.window == window)return false;
				else if (event.xany.type == PropertyNotify && event.xproperty.state == PropertyDelete &&
			       event.xproperty.window == window && event.xproperty.atom == XA_MOZILLA_LOCK){
					break;
				}
			}
		}
		if(data)XFree(data);
		tentatives--;
	} while((!locked)&&tentatives);
	_debug_leavetrace("mozillaRemoteObtainLock");
	return locked;
}

//============ mozillaRemoteFreeLock ============//

void KviNetscapeRemote::mozillaRemoteFreeLock()
{
	_debug_entertrace("mozillaRemoteFreeLock");
	Display *dpy=qt_xdisplay();
	Atom actual_type;
	int actual_format;
	unsigned long nitems, bytes_after;
	unsigned char *data = 0;
	if(XGetWindowProperty(dpy, window, XA_MOZILLA_LOCK,0, (65536 / sizeof (long)),true,XA_STRING,
								&actual_type, &actual_format,&nitems, &bytes_after,&data)!= Success){
		debug("WARNING : Unable to free the Netscape Lock");
	}
	if(data)XFree (data);
	_debug_leavetrace("mozillaRemoteFreeLock");
}

//============ mozzillaRemoteCommand ===========//

int KviNetscapeRemote::mozillaRemoteCommand(const char *command)
{
	_debug_entertrace("mozzillaRemoteCommand");
//	debug("ENTERING getting display");
	Display *dpy=qt_xdisplay();
//	for(int h=0;h<1000;h++)debug("got display %d",h);
	int result=5;
	bool done = False;

//	for(int t=0;t<1000;t++)debug("Create new string %d",t);
//	debug("Cmd : %s",command);
//	char * new_command=(char *)malloc(strlen(command)+1);
//	strcpy (new_command, command);

//	debug("NOW ATOM XA_MOZILLA_COMMAND=%s",XGetAtomName(dpy,XA_MOZILLA_COMMAND));
	QString szNewCmd=command;
	
//	for(int l=0;l<1000;l++)debug("Selected new input %d",l);
	XSelectInput(dpy, window, (PropertyChangeMask|StructureNotifyMask));
//	debug("INPUT SELECTED");
//	for(int i=0;i<1000;i++)debug("wainting %d",i);
	XChangeProperty(dpy,window,XA_MOZILLA_COMMAND,XA_STRING,8,PropModeReplace,
				(unsigned char *)szNewCmd.data(),strlen (command));
//	for(int k=0;k<1000;k++)debug("done %d",k);
	while (!done){
		XEvent event;
		XNextEvent (dpy, &event);
		if (event.xany.type == DestroyNotify && event.xdestroywindow.window == window){
//			debug("window closed");
			//exit if the window is closed.
			result = 6;
			goto DONE;
		} else if ((event.xany.type == PropertyNotify) && (event.xproperty.state == PropertyDelete) &&
						(event.xproperty.window == window)  && (event.xproperty.atom == XA_MOZILLA_COMMAND)){
//			debug("succesgful");
			//exit if the command has been received
			result=0;
			goto DONE;
		} else if ((event.xany.type == PropertyNotify) && (event.xproperty.state == PropertyNewValue) &&
						(event.xproperty.window == window) && (event.xproperty.atom == XA_MOZILLA_RESPONSE)){
//			debug("newer here");
			//response processing....in face we'll newer be here
			Atom actual_type;
			int actual_format;
			unsigned long nitems, bytes_after;
			unsigned char *data = 0;
			result = XGetWindowProperty (dpy, window, XA_MOZILLA_RESPONSE,0, (65536 / sizeof (long)),True,
									       XA_STRING,&actual_type, &actual_format,&nitems, &bytes_after,&data);
			done = true;
			if (result != Success)result = 6; //Like window destroyed
			else if (!data || strlen((char *) data) < 5)result = 6; //same as above
			else if (*data == '1')done=false; //wait for other replies
			else if (!strncmp ((char *)data, "200", 3))result = 0; //Positive reply
			else if (*data == '2')result = 0; //Positive reply for us
			else if ((*data == '4')||(*data == '5')||(*data=='3'))result = (*data - '0'); //some error
			else result = 6;
			if (data)XFree (data);
		}
	}
DONE:
//	if(new_command)free(new_command);
	_debug_leavetrace("mozillaRemoteCommand");
	return result;
}

