//   $Id: kvi_mirdlg.h,v 1.2 1998/09/20 20:23:12 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_MIRCDLG_H_INCLUDED_
#define _KVI_MIRCDLG_H_INCLUDED_

#include <kcolorbtn.h>

#include <qgroupbox.h>
#include <qdialog.h>
#include <qcombobox.h>

class KviFrame;
class KviMircColors;
class KviView;

class KviMircColorsDialog : public QDialog{
	Q_OBJECT
public:
	KviMircColorsDialog(KviFrame *parent,KviMircColors *lpClr);
	~KviMircColorsDialog();
public:
	KviMircColors *m_lpClr;
	KviFrame		*m_lpFrm;

	QPushButton		*lpOK;
	QPushButton		*lpSample;
	QPushButton     *lpDefault;
	QPushButton     *lpHelp;
	KviView			*lpView;
	QGroupBox		*lpFrGrp;
	QGroupBox		*lpBkGrp;
	QComboBox		*lpFrClr;
	QComboBox		*lpBkClr;
	QComboBox		*lpNames;
	QPixmap			*lpPix[16];
	KColorButton    *lpBtn[16];

	void createPixmaps();
	void recreatePixmaps();
	void destroyPixmaps();
	void fillColorBoxes();
public slots:
	void defaultPalette();
	void sampleSlot();
	void bkSlot(int idx);
	void frSlot(int idx);
	void nameSlot(int idx);
	void colorChanged(const QColor & newColor);
};

#endif //_KVI_MIRCDLG_H_INCLUDED_
