//   $Id: kvi_mirc.h,v 1.2 1998/09/20 20:23:11 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_MIRC_H_INCLUDED_
#define _KVI_MIRC_H_INCLUDED_

#include "kvi_defs.h"

#include <qcolor.h>

class KviFrame;

class KviMircColors{
public:
	KviMircColors(KviFrame *lpFrm);
	~KviMircColors();
	static int defClr[KVI_NUM_PIXMAPS];
	static QRgb mapClr[16];
public:
	KviFrame *m_lpFrm;

	char chOutForeColor[KVI_NUM_PIXMAPS];
	char chOutBackColor[KVI_NUM_PIXMAPS];
	char chNormalTextColor;
	char chNormalBackColor;
public:
	void readSettings();
	void saveSettings();
	void createFrameColors();
	void destroyFrameColors();
	void resetFrameColors();
};

#endif //_KVI_MIRC_H_INCLUDED_
