//   $Id: kvi_mirc.cpp,v 1.2 1998/09/20 20:23:10 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CLASS_NAME_ "KviMircColors"

#include "kvi_macros.h"
#include "kvi_mirc.h"
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_frame.h"

#include <kconfig.h>

//16 base mirc colors

QRgb KviMircColors::mapClr[16] = {
	qRgb(255,255,255),qRgb(0,0,0),	qRgb(0,0,140),	qRgb(0,100,0),
	qRgb(230,0,0),	qRgb(150,0,0),	qRgb(80,0,80),	qRgb(255,90,0),
	qRgb(255,255,0),qRgb(0,255,0),	qRgb(0,150,180),qRgb(170,170,255),
	qRgb(15,15,255),qRgb(200,0,200),qRgb(80,80,80),	qRgb(170,170,170)
};

int KviMircColors::defClr[KVI_NUM_PIXMAPS]={
	KVI_WHITE       ,KVI_YELLOW      ,KVI_RED         ,KVI_WHITE       ,
	KVI_LIGHTGRAY   ,KVI_WHITE       ,KVI_WHITE       ,KVI_LIGHTGRAY   ,
	KVI_WHITE       ,KVI_WHITE       ,KVI_WHITE       ,KVI_WHITE       ,
	KVI_WHITE       ,KVI_WHITE       ,KVI_LIGHTGRAY   ,KVI_LIGHTGRAY   ,
	KVI_DARKGRAY    ,KVI_DARKGRAY    ,KVI_DARKGRAY    ,KVI_WHITE       ,
	KVI_WHITE       ,KVI_LIGHTGRAY   ,KVI_LIGHTGRAY   ,KVI_DARKGRAY    ,
	KVI_RED         ,KVI_WHITE       ,KVI_YELLOW      ,KVI_LIGHTGRAY   ,
	KVI_LIGHTGRAY   ,KVI_LIGHTGRAY   ,KVI_LIGHTGRAY   ,KVI_LIGHTBLUE   ,
	KVI_LIGHTGRAY   ,KVI_LIGHTGRAY   ,KVI_LIGHTGRAY   ,KVI_LIGHTGRAY   ,
	KVI_LIGHTGRAY   ,KVI_LIGHTGRAY   ,KVI_LIGHTGRAY   ,KVI_LIGHTGRAY   ,
	KVI_WHITE       ,KVI_WHITE       ,KVI_WHITE       ,KVI_LIGHTGRAY
};

//============ KviMircColors ============//

KviMircColors::KviMircColors(KviFrame *lpFrm)
{
	_debug_entertrace("KviMircColors");
	m_lpFrm=lpFrm;
	createFrameColors();
	readSettings();
	_debug_leavetrace("KviMircColors");
}

//============ ~KviMircColors ============//

KviMircColors::~KviMircColors()
{
	_debug_entertrace("~KviMircColors");
	saveSettings();
	destroyFrameColors();
	_debug_leavetrace("~KviMircColors");
}

//============ readSettings ============//

void KviMircColors::readSettings()
{
	_debug_entertrace("readSettings");
	KConfig *lpC=_macro_kviConfig;

	lpC->setGroup("KviMircColors");
	
	QString szSZ;
	QString szN;

	for(int i=0;i<KVI_NUM_PIXMAPS;i++){
		szSZ="ColorBack";
		szN.setNum(i);
		szSZ+=szN;
		chOutBackColor[i]=(char)lpC->readNumEntry(szSZ.data(),KVI_TRANSPARENT);
		szSZ="ColorFore"+szN;
		chOutForeColor[i]=(char)lpC->readNumEntry(szSZ.data(),defClr[i]);
	}
	chNormalTextColor=(char)lpC->readNumEntry("chNormalTextColor",KVI_LIGHTGRAY);
	chNormalBackColor=(char)lpC->readNumEntry("chNormalBackColor",KVI_TRANSPARENT);
	
	for(int i=0;i<16;i++){
		szSZ="mircColor";
		szN.setNum(i);
		szSZ+=szN;
		QColor theClr(mapClr[i]);
		(*m_lpFrm->m_lpColor[i])=lpC->readColorEntry(szSZ.data(),&theClr);
	}

	_debug_leavetrace("readSettings");
}

//============ saveSettings ============//

void KviMircColors::saveSettings()
{
	_debug_entertrace("saveSettings");
	KConfig *lpC=_macro_kviConfig;

	QString szSZ;
	QString szN;

	lpC->setGroup("KviMircColors");
	for(int i=0;i<KVI_NUM_PIXMAPS;i++){
		szSZ="ColorBack";
		szN.setNum(i);
		szSZ+=szN;
		lpC->writeEntry(szSZ.data(),chOutBackColor[i]);
		szSZ="ColorFore"+szN;
		lpC->writeEntry(szSZ.data(),chOutForeColor[i]);
	}

	lpC->writeEntry("chNormalTextColor",chNormalTextColor);
	lpC->writeEntry("chNormalBackColor",chNormalBackColor);

	for(int i=0;i<16;i++){
		szSZ="mircColor";
		szN.setNum(i);
		szSZ+=szN;
		lpC->writeEntry(szSZ.data(),(*m_lpFrm->m_lpColor[i]));
	}
	_debug_leavetrace("saveSettings");
}

//============ createFrameColors ============//

void KviMircColors::createFrameColors()
{
	_debug_entertrace("createFrameColors");
	for(int i=0;i<16;i++)m_lpFrm->m_lpColor[i]=new QColor(mapClr[i]);
	_debug_leavetrace("createFrameColors");
}

//============ destroyFrameColors ============//

void KviMircColors::destroyFrameColors()
{
	_debug_entertrace("destroyFrameColors");
	for(int i=0;i<16;i++)delete m_lpFrm->m_lpColor[i];
	_debug_leavetrace("destroyFrameColors");
}

//============ resetFrameColors ============//

void KviMircColors::resetFrameColors()
{
	_debug_entertrace("resetFrameColors");
	for(int i=0;i<16;i++)(*m_lpFrm->m_lpColor[i])=QColor(mapClr[i]);
	_debug_leavetrace("resetFrameColors");
}
