//   $Id: kvi_logdlg.cpp,v 1.5 1998/09/23 12:41:41 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#define _KVI_DEBUG_CLASS_NAME_ "KviLogDialog"

#include "kvi_defs.h"
#include "kvi_macros.h"
#include "kvi_logdlg.h"
#include "kvi_child.h"
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_view.h"
#include "kvi_chat.h"
#include "kvi_send.h"

//#include <kfiledialog.h>

//============ KviLogDialog ============//

KviLogDialog::KviLogDialog(KviMdiChild *window,KviView *view) : QDialog(window,0,true)
{
	_debug_entertrace("KviLogDialog");
	m_lpWindow=window;
	m_lpView=view;
	lpOk           = new QPushButton(i18n("OK"),this);
	lpHelp         = new QPushButton(i18n("Help"),this);
	lpCancel       = new QPushButton(i18n("Cancel"),this);
	lpChooseFile   = new QPushButton(i18n("Browse..."),this);
	lpFileName     = new QLabel(m_lpView->m_logStruct.szLogFile.data(),this);
	lpLog          = new QCheckBox(i18n("Enable logging"),this);
	lpLogAll       = new QCheckBox(i18n("Log all text"),this);
	lpTimestamp    = new QCheckBox(i18n("Timestamp logs"),this);
	lpLogText      = new QCheckBox(i18n("Log users text,notices and actions"),this);
	lpLogJoin      = new QCheckBox(i18n("Log joins,parts and quits"),this);
	lpLogKick      = new QCheckBox(i18n("Log kicks,bans,ops,deops..."),this);
	lpLogWhois     = new QCheckBox(i18n("Log whois and dns"),this);
	lpLogChan      = new QCheckBox(i18n("Log channel modes,topics,nick changes..."),this);

	setCaption(i18n("Logging options"));
	lpLog->setGeometry(10,10,300,26);
	lpFileName->setGeometry(10,40,230,26);
	lpChooseFile->setGeometry(245,40,65,26);
	lpLogAll->setGeometry(10,70,300,26);
	lpTimestamp->setGeometry(10,100,300,26);
	lpLogText->setGeometry(10,130,300,26);
	lpLogJoin->setGeometry(10,160,300,26);
	lpLogKick->setGeometry(10,190,300,26);
	lpLogWhois->setGeometry(10,220,300,26);
	lpLogChan->setGeometry(10,250,300,26);

	lpOk->setGeometry(215,280,95,26);
	lpCancel->setGeometry(110,280,100,26);
	lpHelp->setGeometry(10,280,95,26);

	setFixedSize(320,320);

	connect(lpOk,SIGNAL(clicked()),this,SLOT(acceptChanges()));
	connect(lpCancel,SIGNAL(clicked()),this,SLOT(reject()));
	connect(lpHelp,SIGNAL(clicked()),this,SLOT(requestHelp()));

	connect(lpChooseFile,SIGNAL(clicked()),this,SLOT(chooseFile()));

	connect(lpLog,SIGNAL(toggled(bool)),this,SLOT(logToggled(bool)));
	connect(lpLogAll,SIGNAL(toggled(bool)),this,SLOT(logAllToggled(bool)));

	lpLog->setChecked(m_lpView->m_logStruct.bEnableLog);
	lpLogAll->setChecked(m_lpView->m_logStruct.bLogAll);
	lpTimestamp->setChecked(m_lpView->m_logStruct.bTimestamp);
	lpLogText->setChecked(m_lpView->m_logStruct.bLogText);
	lpLogJoin->setChecked(m_lpView->m_logStruct.bLogJoin);
	lpLogKick->setChecked(m_lpView->m_logStruct.bLogKick);
	lpLogWhois->setChecked(m_lpView->m_logStruct.bLogWhois);
	lpLogChan->setChecked(m_lpView->m_logStruct.bLogChan);

	lpFileName->setFrameStyle(QFrame::Sunken|QFrame::Panel);

	lpLogAll->setEnabled(lpLog->isChecked());
	lpTimestamp->setEnabled(lpLog->isChecked());
	lpLogText->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogJoin->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogKick->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogWhois->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogChan->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));

	_debug_leavetrace("KviLogDialog");
}
//============ ~KviLogDialog ============//
KviLogDialog::~KviLogDialog()
{
	_debug_entertrace("~KviLogDialog");
	delete lpOk;
	delete lpHelp;
	delete lpCancel;
	delete lpChooseFile;
	delete lpFileName;
	delete lpLog;
	delete lpLogAll;
	delete lpTimestamp;
	delete lpLogText;
	delete lpLogJoin;
	delete lpLogKick;
	delete lpLogWhois;
	delete lpLogChan;
	_debug_leavetrace("~KviLogDialog");
}
//============ chooseFile ============//
void KviLogDialog::chooseFile()
{
	_debug_entertrace("chooseFile");
	QString szF=(lpFileName->text() ? lpFileName->text() : "");
	if(szF.isEmpty()){
		szF=_macro_getKVircHomeDirectory("Logs/");
		if((m_lpWindow->type()==KVI_WND_TYPE_CHAN)||
			(m_lpWindow->type()==KVI_WND_TYPE_QUERY)){
			szF+=m_lpWindow->name();
		} else {
			if(m_lpWindow->type()==KVI_WND_TYPE_CHAT){
				szF+="CHAT-";
				szF+=((KviChatWnd *)m_lpWindow)->m_szRemoteNick;
			} else if(m_lpWindow->type()==KVI_WND_TYPE_SEND){
				szF+="SEND-";
				szF+=((KviSendWnd *)m_lpWindow)->m_szRemoteNick;
			} else szF+="LOG-";
		}
		QDate date=QDate::currentDate();
		szF+="-";
		szF+=date.dayName(date.dayOfWeek());
		QString szNum;
		szNum.setNum(date.day());
		szF+=szNum;
		szF+=date.monthName(date.month());
		szNum.setNum(date.year());
		szF+=szNum;
	}
	QString szFle(_macro_getSaveFileName(0,szF,0));
	if(!szFle.isEmpty()){
//		m_lpView->m_logStruct.szLogFile=szFle.copy();
		lpFileName->setText(szFle.data());
	}
	_debug_leavetrace("chooseFile");
}
//============ requestHelp ============//
void KviLogDialog::requestHelp()
{
	_debug_entertrace("requestHelp");
	_debug_leavetrace("requestHelp");
}
//============ logAllToggled ============//
void KviLogDialog::logAllToggled(bool)
{
	_debug_entertrace("logAllToggled");
	lpTimestamp->setEnabled(lpLog->isChecked());
	lpLogText->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogJoin->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogKick->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogWhois->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogChan->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	_debug_leavetrace("logAllToggled");
}
//============ logToggled ============//
void KviLogDialog::logToggled(bool)
{
	_debug_entertrace("logToggled");
	lpLogAll->setEnabled(lpLog->isChecked());
	lpTimestamp->setEnabled(lpLog->isChecked());
	lpLogText->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogJoin->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogKick->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogWhois->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	lpLogChan->setEnabled(lpLog->isChecked() && (!lpLogAll->isChecked()));
	_debug_leavetrace("logToggled");
}
//============ acceptChanges ============//
void KviLogDialog::acceptChanges()
{
	_debug_entertrace("acceptChanges");
	m_lpView->closeLog();
	m_lpView->m_logStruct.bEnableLog=lpLog->isChecked();
	m_lpView->m_logStruct.bLogAll=lpLogAll->isChecked();
	m_lpView->m_logStruct.bTimestamp=lpTimestamp->isChecked();
	m_lpView->m_logStruct.bLogText=lpLogText->isChecked();
	m_lpView->m_logStruct.bLogJoin=lpLogJoin->isChecked();
	m_lpView->m_logStruct.bLogKick=lpLogKick->isChecked();
	m_lpView->m_logStruct.bLogWhois=lpLogWhois->isChecked();
	m_lpView->m_logStruct.bLogChan=lpLogChan->isChecked();
	if(lpLog->isChecked()){
		QString szFile=( lpFileName->text() ? lpFileName->text() : "");
		if(szFile.isEmpty())m_lpView->m_logStruct.bEnableLog=false;
		else {
			m_lpView->m_logStruct.szLogFile=szFile.copy();
			m_lpView->openLog(szFile.data());			
		}
	}
	accept();
	_debug_leavetrace("acceptChanges");
}


#include "m_kvi_logdlg.moc"

//
// $Log: kvi_logdlg.cpp,v $
// Revision 1.5  1998/09/23 12:41:41  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.4  1998/09/20 20:23:05  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.3  1998/09/16 17:16:34  fritz
// Starting i18n.
//
// Revision 1.2  1998/09/16 16:13:15  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
