//   $Id: kvi_link.h,v 1.2 1998/09/20 20:23:01 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_LINK_H_INCLUDED_
#define _KVI_LINK_H_INCLUDED_

#include "kvi_child.h"

#include <knewpanner.h>

#include <qlistview.h>
#include <qlist.h>

//Workaround class
typedef struct kviLinkStructTag{
	QString host;
	QString parenthost;
	QString description;
	QString hops;
	int nHops;
} KviLinkStruct;

class KviListViewItem : public QListViewItem
{
public:
	KviListViewItem(QListView *parent,const char *str1,const char *str2,const char *str3,const char *str4);
	KviListViewItem(KviListViewItem *parent,const char *str1,const char *str2,const char *str3,const char *str4);
	~KviListViewItem();
public:
	virtual void paintBranches(QPainter *p,const QColorGroup &cg,int w,int y,int h,GUIStyle s);
};

class KviLinkWnd : public KviMdiChild
{
	Q_OBJECT
public:	
	KviLinkWnd(KviMdiManager *parent,KviFrame *frame,int aid);
	~KviLinkWnd();
	
	KNewPanner      *m_lpPanner;
	QListView       *m_lpView;
	QList<KviLinkStruct> *m_lpLinkList;

	bool m_bDone;
public:
	void endOfLinks();
	KviListViewItem *getChildItem(KviListViewItem *parent,const char *parenthost);
	KviListViewItem *getItemByHost(const char *parenthost);
	void insertLink(const char *host,const char *parenthost,const char *description);
	void insertLinkInternal(const char *host,const char *parenthost,const char *hops,const char *description);

	void applyOptions();
	void doFmtOutput(int nType,const char *szFmt,...);
	void doOutput(int nType,const char *szText);
protected:
	virtual void resizeEvent(QResizeEvent *);
public slots:
	void closeSlot();
};

#endif // _KVI_QUERY_H_INCLUDED_
