//   $Id: kvi_int.cpp,v 1.3 1998/09/28 13:55:49 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CLASS_NAME_ "KviInterface"

#include "kvi_macros.h"
#include "kvi_int.h"
#include "kvi_defs.h"
#include "kvi_debug.h"
#include "kvi_app.h"

#include "kconfig.h"
#include "kiconloader.h"

//============ KviInterface ============//

KviInterface::KviInterface()
{
	_debug_entertrace("KviInterface");
	//Main Mdi Manager background
	pix_bk_mdi.resize(0,0);
	pix_bk_caption.resize(0,0);
	pix_bk_input.resize(0,0);
	pix_bk_output.resize(0,0);
	pix_bk_listbox.resize(0,0);
	pix_bk_chanlabels.resize(0,0);
	readSettings();
	_debug_leavetrace("KviInterface");
}

//============ ~KviInterface ============//

KviInterface::~KviInterface()
{
	_debug_entertrace("~KviInterface");
	saveSettings();
	_debug_leavetrace("~KviInterface");
}

//============ readSettings ============//

void KviInterface::readSettings()
{
	_debug_entertrace("readSettings");
	KConfig *lpC=_macro_kviConfig;
	KIconLoader *lpI=_macro_kviIconLoader;
	QColor	dummyBlack(0,0,0);
	QColor	dummyRed(255,0,0);
	QColor	dummyGray(80,80,80);
	QColor  dummyWhite(255,255,255);
	QColor	dummyLightGray(180,180,180);
	QColor  dummyGreen(0,180,0);
	QColor  dummyBlue(30,40,230);
	QColor  dummyLightGreen(40,230,0);
	QColor  dummyMaroon(80,110,0);
	QFont	dummyFont1("helvetica",10);
	QFont	dummyFont2("helvetica",24);
	QFont	dummyFont3("clean",12);
	lpC->setGroup("KviInterface");
	//Main mdi manager background
	clr_bk_mdi	=	lpC->readColorEntry("clr_bk_mdi",&dummyBlack);
	str_bk_mdi	=	lpC->readEntry("str_bk_mdi",KVI_STR_NONE);
	if((!str_bk_mdi.isEmpty())&&(str_bk_mdi != KVI_STR_NONE)){
		pix_bk_mdi=lpI->loadIcon(str_bk_mdi.data());
		pix_bk_mdi.optimize(true);
	} else pix_bk_mdi.resize(0,0);
	//Captions
	clr_bk_act_caption	=	lpC->readColorEntry("clr_bk_act_caption",&dummyBlack);
	clr_bk_ina_caption	=	lpC->readColorEntry("clr_bk_ina_caption",&dummyGray);
	clr_fr_act_caption	=	lpC->readColorEntry("clr_fr_act_caption",&dummyRed);
	clr_fr_ina_caption	=	lpC->readColorEntry("clr_fr_ina_caption",&dummyLightGray);
	fnt_caption			=	lpC->readFontEntry("fnt_caption",&dummyFont1);
	str_bk_caption		=	lpC->readEntry("str_bk_caption",KVI_STR_NONE);
	if((!str_bk_caption.isEmpty())&&(str_bk_caption != KVI_STR_NONE)){
		pix_bk_caption=lpI->loadIcon(str_bk_caption.data());
		pix_bk_caption.optimize(true);
	} else pix_bk_caption.resize(0,0);
	clr_bk_input		=	lpC->readColorEntry("clr_bk_input",&dummyBlack);
	clr_fr_input		=	lpC->readColorEntry("clr_fr_input",&dummyLightGray);
	clr_bk_sel_input	=	lpC->readColorEntry("clr_bk_sel_input",&dummyGray);
	clr_fr_sel_input	=	lpC->readColorEntry("clr_fr_sel_input",&dummyLightGray);
	clr_cursor_input	=	lpC->readColorEntry("clr_cursor_input",&dummyRed);
	fnt_input			=	lpC->readFontEntry("fnt_input",&dummyFont2);
	str_bk_input		=	lpC->readEntry("str_bk_input",KVI_STR_NONE);
	if((!str_bk_input.isEmpty())&&(str_bk_input != KVI_STR_NONE)){
		pix_bk_input=lpI->loadIcon(str_bk_input.data());
		pix_bk_input.optimize(true);
	} else pix_bk_input.resize(0,0);
	clr_bk_output		=	lpC->readColorEntry("clr_bk_output",&dummyBlack);
	clr_bk_sel_output	=	lpC->readColorEntry("clr_bk_sel_output",&dummyLightGray);
	clr_fr_sel_output	=	lpC->readColorEntry("clr_fr_sel_output",&dummyBlack);
	fnt_output			=	lpC->readFontEntry("fnt_output",&dummyFont3);
	str_bk_output		=	lpC->readEntry("str_bk_output",KVI_STR_NONE);
	if((!str_bk_output.isEmpty())&&(str_bk_output != KVI_STR_NONE)){
		pix_bk_output=lpI->loadIcon(str_bk_output.data());
		pix_bk_output.optimize(true);
	} else pix_bk_output.resize(0,0);
	clr_bk_listbox		=	lpC->readColorEntry("clr_bk_listbox",&dummyBlack);
	clr_fr_normal_listbox=	lpC->readColorEntry("clr_fr_normal_listbox",&dummyLightGray);
	clr_fr_op_listbox	=	lpC->readColorEntry("clr_fr_op_listbox",&dummyRed);
	clr_fr_voice_listbox=	lpC->readColorEntry("clr_fr_voice_listbox",&dummyGray);
	clr_bk_sel_listbox	=	lpC->readColorEntry("clr_bk_sel_listbox",&dummyLightGray);
	clr_fr_sel_listbox	=	lpC->readColorEntry("clr_fr_sel_listbox",&dummyBlack);
	fnt_listbox			=	lpC->readFontEntry("fnt_listbox",&dummyFont1);
	str_bk_listbox		=	lpC->readEntry("str_bk_listbox",KVI_STR_NONE);
	if((!str_bk_listbox.isEmpty())&&(str_bk_listbox != KVI_STR_NONE)){
		pix_bk_listbox=lpI->loadIcon(str_bk_listbox.data());
		pix_bk_listbox.optimize(true);
	} else pix_bk_listbox.resize(0,0);
	clr_bk_chanlabels	=	lpC->readColorEntry("clr_bk_chanlabels",&dummyBlack);
	clr_fr_chanlabels	=	lpC->readColorEntry("clr_fr_chanlabels",&dummyGray);
	clr_fr_act_chanlabels=  lpC->readColorEntry("clr_fr_act_chanlabels",&dummyWhite);
	str_bk_chanlabels	=	lpC->readEntry("str_bk_chanlabels",KVI_STR_NONE);
	if((!str_bk_chanlabels.isEmpty())&&(str_bk_chanlabels != KVI_STR_NONE)){
		pix_bk_chanlabels=lpI->loadIcon(str_bk_chanlabels.data());
		pix_bk_chanlabels.optimize(true);
	} else pix_bk_chanlabels.resize(0,0);
	fnt_chanlabels		=	lpC->readFontEntry("fnt_chanlabels",&dummyFont1);
	//script editor
	clr_edit_back       =   lpC->readColorEntry("clr_edit_back",&dummyBlack);
	clr_edit_fore       =   lpC->readColorEntry("clr_edit_fore",&dummyLightGreen);
	clr_edit_cursor     =   lpC->readColorEntry("clr_edit_cursor",&dummyWhite);
	clr_edit_comment    =   lpC->readColorEntry("clr_edit_comment",&dummyGreen);
	clr_edit_command    =   lpC->readColorEntry("clr_edit_command",&dummyLightGray);
	clr_edit_variable   =   lpC->readColorEntry("clr_edit_variable",&dummyBlue);
	clr_edit_brace      =   lpC->readColorEntry("clr_edit_brace",&dummyRed);
	clr_edit_operator   =   lpC->readColorEntry("clr_edit_operator",&dummyMaroon);
	clr_edit_channel    =   lpC->readColorEntry("clr_edit_channel",&dummyGray);
	_debug_leavetrace("readSettings");
}

//============ saveSettings ============//

void KviInterface::saveSettings()
{
	_debug_entertrace("saveSettings");
	KConfig *lpC=_macro_kviConfig;

	lpC->setGroup("KviInterface");
	lpC->writeEntry("clr_bk_mdi",clr_bk_mdi);
	lpC->writeEntry("str_bk_mdi",str_bk_mdi);
	lpC->writeEntry("clr_bk_act_caption",clr_bk_act_caption);
	lpC->writeEntry("clr_bk_ina_caption",clr_bk_ina_caption);
	lpC->writeEntry("clr_fr_act_caption",clr_fr_act_caption);
	lpC->writeEntry("clr_fr_ina_caption",clr_fr_ina_caption);
	lpC->writeEntry("fnt_caption",fnt_caption);
	lpC->writeEntry("str_bk_caption",str_bk_caption);
	lpC->writeEntry("clr_bk_input",clr_bk_input);
	lpC->writeEntry("clr_fr_input",clr_fr_input);
	lpC->writeEntry("clr_bk_sel_input",clr_bk_sel_input);
	lpC->writeEntry("clr_fr_sel_input",clr_fr_sel_input);
	lpC->writeEntry("clr_cursor_input",clr_cursor_input);
	lpC->writeEntry("fnt_input",fnt_input);
	lpC->writeEntry("str_bk_input",str_bk_input);
	lpC->writeEntry("clr_bk_output",clr_bk_output);
	lpC->writeEntry("clr_bk_sel_output",clr_bk_sel_output);
	lpC->writeEntry("clr_fr_sel_output",clr_fr_sel_output);
	lpC->writeEntry("fnt_output",fnt_output);
	lpC->writeEntry("str_bk_output",str_bk_output);
	lpC->writeEntry("clr_bk_listbox",clr_bk_listbox);
	lpC->writeEntry("clr_fr_normal_listbox",clr_fr_normal_listbox);
	lpC->writeEntry("clr_fr_op_listbox",clr_fr_op_listbox);
	lpC->writeEntry("clr_fr_voice_listbox",clr_fr_voice_listbox);
	lpC->writeEntry("clr_bk_sel_listbox",clr_bk_sel_listbox);
	lpC->writeEntry("clr_fr_sel_listbox",clr_fr_sel_listbox);
	lpC->writeEntry("fnt_listbox",fnt_listbox);
	lpC->writeEntry("str_bk_listbox",str_bk_listbox);
	lpC->writeEntry("clr_bk_chanlabels",clr_bk_chanlabels);
	lpC->writeEntry("clr_fr_chanlabels",clr_fr_chanlabels);
	lpC->writeEntry("clr_fr_act_chanlabels",clr_fr_act_chanlabels);
	lpC->writeEntry("str_bk_chanlabels",str_bk_chanlabels);
	lpC->writeEntry("fnt_chanlabels",fnt_chanlabels);
	lpC->writeEntry("clr_edit_back",clr_edit_back);
	lpC->writeEntry("clr_edit_fore",clr_edit_fore);
	lpC->writeEntry("clr_edit_cursor",clr_edit_cursor);
	lpC->writeEntry("clr_edit_comment",clr_edit_comment);
	lpC->writeEntry("clr_edit_command",clr_edit_command);
	lpC->writeEntry("clr_edit_variable",clr_edit_variable);
	lpC->writeEntry("clr_edit_brace",clr_edit_brace);
	lpC->writeEntry("clr_edit_operator",clr_edit_operator);
	lpC->writeEntry("clr_edit_channel",clr_edit_channel);
	_debug_leavetrace("saveSettings");
}


