//   $Id: kvi_input.h,v 1.3 1998/09/28 13:55:48 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_INPUT_H_INCLUDED_
#define _KVI_INPUT_H_INCLUDED_

#include <qlist.h>
#include <qwidget.h>
#include <qstring.h>
#include <qcolor.h>
#include <qevent.h>
#include <qpopupmenu.h>

class KviClrBox;
class KviUserParser;
class KviMdiChild;
class KviFrame;

class KviInput : public QWidget
{
	Q_OBJECT
public:
	KviInput(KviMdiChild *parent,int parentID,int parentType,const char *szParentName,KviFrame *lpFrame,const char *name=0);
	~KviInput();
public:		//Member Vars...
	int				m_ParentID;
	int				m_ParentType;
	QString			m_szParentName;
	uint			m_CommandListIndex;

	char			m_curForeColor;
	char			m_curBackColor;
	bool			m_bUnderline;
	bool			m_bBold;

	const char *text() const;
	void setDefaultBackgroundColor(const QColor &acolor);
	void setDefaultForegroundColor(const QColor &acolor);
	void setMarkBackgroundColor(const QColor &acolor);
	void setMarkForegroundColor(const QColor &acolor);
	void setCursorColor(const QColor &acolor);
	void enableColorBox(bool bEnable);
	bool getTextPieceAndSetAttributes(QString &szData,QString &szText);
	void setAttributesFromString(QString &szData);
public slots:
	void setText(const char * );
	void tabPressed();
	void returnPressed();
	void copySlot();
	void pasteSlot();
protected:
    void	mousePressEvent( QMouseEvent * );
    void	mouseMoveEvent( QMouseEvent * );
    void	mouseReleaseEvent( QMouseEvent * );
    void	mouseDoubleClickEvent( QMouseEvent * );
    void	keyPressEvent( QKeyEvent * );
    void	focusInEvent( QFocusEvent * );
    void	focusOutEvent( QFocusEvent * );
    void	paintEvent( QPaintEvent * );
    void	timerEvent( QTimerEvent * );
    void	resizeEvent( QResizeEvent * e);
private:
	void	pasteUserBuffer(int nBuf);
    void	pixmapPaint( const QRect& clip );
	void    autoCompleteNick();
    void	paintText( QPainter *, const QSize &);
    void	moveCursorLeft( bool mark, int steps = 1 );
    void	moveCursorRight( bool mark, int steps = 1 );
    void	backspace();
    void	del();
    void	home( bool mark );
    void	end( bool mark );
    void	newMark( int pos);
    void	markWord( int pos );
    int		lastCharVisible() const;
    int		minMark() const;
    int		maxMark() const;

	int             m_iLastTabCursorPos;
	int             m_iLastTabIndex;
	QString         m_szLastNickCompletionBuffer;

	KviClrBox 		*m_lpClrBox;
	KviMdiChild		*m_lpParent;
	KviFrame 		*m_lpFrame;
	KviUserParser	*m_lpUserParser;
	QList<QString>	*m_lpCommandList;
	QColor 			m_backgroundColor;
	QColor			m_foregroundColor;
	QColor			m_markBackColor;
	QColor			m_markForeColor;
	QColor			m_cursorColor;
	QString			m_textBuffer;
	QPopupMenu		*m_lpContextPopup;
	bool			m_bColorBoxVisible;
	bool			m_bColorBoxEnabled;
	bool            m_bNickCompleted;
    QPixmap			*m_lpMemBuffer;
    int				m_cursorPos;
    int				m_offset;
    int				m_markAnchor;
    int				m_markDrag;
    bool			m_bCursorActive;
    bool			m_bDragScrolling;
    bool			m_bScrollLeft;
};

#define kviInputRepaint repaint(!hasFocus())
#define kviInputHasSelection (m_markAnchor!=m_markDrag)

#endif
