//   $Id: kvi_event.cpp,v 1.4 1998/09/20 20:22:27 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_macros.h"
#include "kvi_event.h"
#include "kvi_debug.h"
#include "kvi_app.h"

#include <kmsgbox.h>

#include <qfile.h>

const char * KviEventManager::appStr[KVI_EVENTS_NUMBER*2]={
	"Event_OnStartup","<$0> Version",         // %0=KVI_VERSION
	"Event_OnShutdown","<$0> Version",   // %0=KVI_VERSION
	"Event_OnConnect","<$1> Server_Name,<$2> Server_Ip,<$3> Network_Name,<$4> Local_Host", // %0=server_name server_ip network_name port local_host
	"Event_OnDisconnect","<$1> Server_Name,<$2> Server_Ip", // %0=server_name server_ip
	"Event_OnLoggedIn","<$1> Nickname,<$2> User_Name,<$3> Real_Name", // %0=nick user_name real_name (called when RPL_WELCOME is received)
	"Event_OnMeJoin","<$1> Channel", // %0=channel (executed from the channel window) //END_OF_NAMESLIST
	"Event_OnMePart","<$1> Channel", // %0=channel (same as above but executed from the console)
	"Event_OnJoin","<$1> Channel,<$2> Source_Nick,<$3> User_Name,<$4> Host_Name", // %0=channel nick user host //Just before the JOIN is shown and executed from chan
	"Event_OnPart","<$1> Channel,<$2> Source_Nick,<$3> User_Name,<$4> Host_Name", // %0=channel nick user host //Nick is not longer on the chan (before showing)
	"Event_OnTopicChange","<$1> Channel,<$2> Source_Nick,<$3-> New_Topic", // %0=channel nick topic
	"Event_OnMeKick","<$1> Channel,<$2> Source_Nick,<$3-> Reason", // %0=channel nick_that_kicked_me reason
	"Event_OnKick","<$1> Channel,<$2> Source_Nick,<$3> Target_Nick,<$4-> Reason", // %0=channel kickeR kickeD reason
	"Event_OnNick","<$1> Old_Nick,<$2> New_Nick", // %0=old_nick new_nick (exec from console)
	"Event_OnOp","<$1> Channel,<$2> Source_Nick,<$3> Target_Nick", // %0=channel oper oped
	"Event_OnDeop","<$1> Channel,<$2> Source_Nick,<$3> Target_Nick", // %0=channel deoper deoped
	"Event_OnVoice","<$1> Channel,<$2> Source_Nick,<$3> Target_Nick", // %0=channel voicer voiced
	"Event_OnDevoice","<$1> Channel,<$2> Source_Nick,<$3> Target_Nick", // %0=channel devoicer devoiced
	"Event_OnBan","<$1> Channel,<$2> Source_Nick,<$3> Target_Mask", // %0=channel banner banned_mask
	"Event_OnUnban","<$1> Channel,<$2> Source_Nick,<$3> Target_Mask", // %0=channel unbanner unbanned_mask
	"Event_OnQuit","<$1> Source_Nick,<$2-> Quit_Message",            // %0=nick_that_quits quit_msg (one word per param...)
	"Event_OnCtcpRequest","<$1> Source_Nick,<$2> Source_mask,<$3> Ctcp_type,<$4-> Ctcp_params",
	"Event_OnCtcpReply","<$1> Source_Nick,<$2> Source_mask,<$3> Ctcp_type,<$4-> Ctcp_params",
	"Event_OnCtcpFlood","<$1> Source_Nick,<$2> Source_mask,<$3> Ctcp_type,<$4-> Ctcp_params",
	"Event_OnClone","<$1> Channel,<$2> Clone_mask,<$3> Nick_list",
	"Event_OnMeOp","<$1> Channel,<$2> Source_Nick",
	"Event_OnMeDeop","<$1> Channel,<$2> Source_Nick",
	"Event_OnMeVoice","<$1> Channel,<$2> Source_Nick",
	"Event_OnMeDevoice","<$1> Channel,<$2> Source_Nick",
	"Event_OnMeBan","<$1> Channel,<$2> Source_Nick,<$3> Ban_Mask",
	"Event_OnMeUnban","<$1> Channel,<$2> Source_Nick,<$3> Ban_Mask",
	"Event_OnProcessStarted","<$1> Pid,<$2-> Commandline",
	"Event_OnProcessExited","<$1> Pid",
	"Event_OnProcessStdout","<$1> Pid,<$2-> Process_stdout_message",
	"Event_OnProcessStderr","<$1> Pid,<$2-> Process_stderr_message",
	"Event_OnUnhandledServerReply","<$1> Reply_Number,<$2-> Reply_string",
	"Event_OnUnhandledServerError","<$1> Error_Number,<$2-> Error_String",
	"Event_OnChannelPrivmsg","<$1> Channel,<$2> Source_Nick,<$3-> Text",
	"Event_OnMePrivmsg","<$1> Source_Nick,<$2-> Text",
	"Event_OnChannelNotice","<$1> Channel,<$2> Source_Nick,<$3-> Text",
	"Event_OnMeNotice","<$1> Source_Nick,<$2-> Text",
	"Event_OnServerNotice","<$1> Server_Mask,<$2-> Text",
	"Event_OnDCCChatText","<$1> Remote_Nick,<$2-> Text",
	"Event_OnUserWndInput","<$1> Window_name,<$2-> Text",
	"Event_OnMassOp","<$1> Channel,<$2> Source_Nick",
	"Event_OnMassDeop","<$1> Channel,<$2> Source_Nick",
	"Event_OnMassKick","<$1> Channel,<$2> Source_Nick",
	"Event_OnMassBan","<$1> Channel,<$2> Source_Nick",
	"Event_OnPublicFlood","<$1> Channel,<$2> Source_Nick",
	"Event_OnMeAwayChange","<$0> Server reply if away , $_null if back",
	"Event_OnMiddleDoubleClick","<$1> Channel <$2> Clicked_Nickname"
};
KviEventManager::KviEventManager()
{
	setEventNames();
	m_lastGeometry="";
	m_iLastEdited=0;
	readFromFile();
}
KviEventManager::~KviEventManager()
{
	saveToFile();
	for(int i=0;i<KVI_EVENTS_NUMBER;i++)delete lpEvent[i];
}
//============ setEventNames ============//
void KviEventManager::setEventNames()
{
	_debug_entertrace("setEventNames");
	for(int i=0;i<KVI_EVENTS_NUMBER;i++){
		lpEvent[i]=new KviEventStruct;
		lpEvent[i]->szName=appStr[i*2];
		lpEvent[i]->szBuffer="/<\n    echo $_window Empty event;\n>;";
		lpEvent[i]->bEnabled=false;
	}
	_debug_leavetrace("setEventNames");
}
//============ saveToFile ============//
void KviEventManager::saveToFile()
{
	_debug_entertrace("saveToFile");
	QString szFileName(_macro_getKVircHomeDirectory("Config/kvi.event.conf"));

	QFile config(szFileName.data());
	if(!config.open(IO_WriteOnly|IO_Truncate)){ cantWriteError(); return; }
	//Write the alias number
	uint cnt=KVI_EVENTS_NUMBER;
	if(config.writeBlock("KVIrc CONFIGURATION FILE - PLEASE DO NOT EDIT\n",46)<0){ cantWriteError(); return; };
	if(config.writeBlock((char *)&cnt,sizeof(cnt))<0){ cantWriteError(); return; };

	for(uint i=0;i<cnt;i++){
		uint len=lpEvent[i]->szName.length();
		if(config.writeBlock((char *)&len,sizeof(len))<0){ cantWriteError(); return; };
		if(config.writeBlock(lpEvent[i]->szName.data(),len)<0){ cantWriteError(); return; };
		len=lpEvent[i]->szBuffer.length();
		if(config.writeBlock((char *)&len,sizeof(len))<0){ cantWriteError(); return; };
		if(config.writeBlock(lpEvent[i]->szBuffer.data(),len)<0){ cantWriteError(); return; };
		if(config.writeBlock((char *)&(lpEvent[i]->bEnabled),sizeof(lpEvent[i]->bEnabled))<0){ cantWriteError(); return; };
	}
	config.close();
	_debug_leavetrace("saveToFile");
}
//============ cantWriteError ============//
void KviEventManager::cantWriteError()
{
	_debug_entertrace("cantWriteError");
	KMsgBox::message(0,i18n("WARNING File I/O Error"),i18n("Can't write to the kvi.event.conf file.\nThe current event handlers will be lost."));
	_debug_leavetrace("cantWriteError");
}
//============ cantReadError ============//
void KviEventManager::cantReadError()
{
	_debug_entertrace("cantReadError");
	KMsgBox::message(0,i18n("WARNING File I/O Error"),i18n("Can't read the kvi.event.conf file.\nThe current event handlers will be lost."));
	_debug_leavetrace("cantReadError");
}
//============ internalError ============//
void KviEventManager::internalError()
{
	_debug_entertrace("internalError");
	KMsgBox::message(0,i18n("WARNING"),i18n("Internal error.\nEvent configuration file messed up\nThe current event handlers will be lost."));
	_debug_leavetrace("internalError");
}
//============ readFromFile ============//
void KviEventManager::readFromFile()
{
	_debug_entertrace("readFromFile");
	QString szFileName(_macro_getKVircHomeDirectory("Config/kvi.event.conf"));

	QFile config(szFileName.data());
	if(!config.exists()){
		config.open(IO_WriteOnly);
		config.close();
		return;
	}
	if(!config.open(IO_ReadOnly)){ cantReadError(); return; }
	//Write the alias number
	uint cnt;
	char dummyBuf[100];
	if(config.readBlock(dummyBuf,46)<0)return;
	if(config.readBlock((char *)&cnt,sizeof(cnt))<0)return;
	if(cnt!=KVI_EVENTS_NUMBER)return;

	for(uint i=0;i<cnt;i++){
		uint len;
		char szBuffer[4096];
		if(config.readBlock((char *)&len,sizeof(len))<0){ cantReadError(); return; };
		if(len>4096){
			internalError();
			return;
		}
		if(config.readBlock(szBuffer,len)<0){ cantReadError(); return; };
		lpEvent[i]->szName=QString(szBuffer,len+1);
		if(config.readBlock((char *)&len,sizeof(len))<0){ cantReadError(); return; };
		if(len>4096){
			internalError();
			return;
		}
		if(config.readBlock(szBuffer,len)<0){ cantReadError(); return; };
		lpEvent[i]->szBuffer=QString(szBuffer,len+1);
		if(config.readBlock((char *)&(lpEvent[i]->bEnabled),sizeof(lpEvent[i]->bEnabled))<0){ cantReadError(); return; };
	}
	config.close();
	_debug_leavetrace("readFromFile");
}

//
// $Log: kvi_event.cpp,v $
// Revision 1.4  1998/09/20 20:22:27  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.3  1998/09/16 17:16:09  fritz
// Starting i18n.
//
// Revision 1.2  1998/09/16 16:13:11  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
