//   $Id: kvi_debug.h,v 1.2 1998/09/23 23:15:05 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_DEBUG_H_INCLUDED_
#define _KVI_DEBUG_H_INCLUDED_

/////////////////////////////////////////
// MAIN DEBUG SWITCHES
/////////////////////////////////////////

// Commenting out the line below turns off the debug output
//#define _KVI_DEBUG_SESSION_

// Commenting this line out will stop the range check warnings
#define _KVI_RANGE_CHECK_

/////////////////////////////////////////
// SECONDARY SWITCHES
/////////////////////////////////////////

/////////////////////////////////////////
//In order to turn on the debug output
//for a single class please 
//#define _KVI_DEBUG_CLASS_NAME "className"
//#define _KVI_DEBUG_CHECK_RANGE_
//at the beginning of the .cpp file containing
//the class.

// Other small switches
//------Trace function calls
#define _KVI_DEBUG_TRACE_
//------Trace huge function calls like eventFiters..
#define _KVI_DEBUG_TRACE_HUGE_
//------Trace debug warnings...
#define _KVI_DEBUG_WARNINGS_

/////////////////////////////////////////
/////////////////////////////////////////
/////////////////////////////////////////
#ifndef _KVI_DEBUG_SESSION_
	#undef _KVI_DEBUG_CLASS_NAME_
#endif //ifndef _KVI_DEBUG_SESSION_

#ifndef _KVI_RANGE_CHECK_
	#undef _KVI_DEBUG_CHECK_RANGE_
#endif

#ifndef _KVI_DEBUG_CLASS_NAME_
	#undef _KVI_DEBUG_TRACE_
	#undef _KVI_DEBUG_TRACE_HUGE_
	#undef _KVI_DEBUG_WARNINGS_
#endif //ifndef _KVI_DEBUG_CLASS_NAME_

#ifdef _KVI_DEBUG_TRACE_
	#define _debug_entertrace(_methodname) debug(" --> %s:%s()",_KVI_DEBUG_CLASS_NAME_,_methodname)
	#define _debug_checkpoint(_methodname) debug("---- %s:%s()",_KVI_DEBUG_CLASS_NAME_,_methodname)
	#define _debug_leavetrace(_methodname) debug("<--  %s:%s()",_KVI_DEBUG_CLASS_NAME_,_methodname)
#endif //ifdef _KVI_DEBUG_TRACE_CONSTRUCTORS_
#ifndef _KVI_DEBUG_TRACE_
	#define _debug_entertrace(_methodname)
	#define _debug_checkpoint(_methodname)
	#define _debug_leavetrace(_methodname)
#endif //ifndef __KVI_DEBUG_TRACE_

#ifdef _KVI_DEBUG_TRACE_HUGE_
	#define _debug_entertrace_huge(_methodname) debug(" --> %s:%s()",_KVI_DEBUG_CLASS_NAME_,_methodname)
	#define _debug_leavetrace_huge(_methodname) debug("<--  %s:%s()",_KVI_DEBUG_CLASS_NAME_,_methodname)
#endif //ifdef _KVI_DEBUG_TRACE_CONSTRUCTORS_
#ifndef _KVI_DEBUG_TRACE_
	#define _debug_entertrace_huge(_methodname)
	#define _debug_leavetrace_huge(_methodname)
#endif //ifndef __KVI_DEBUG_TRACE_HUGE_

#ifdef _KVI_DEBUG_WARNINGS_
	#define _debug_warning(_string) debug("WARNING : %s:%s",_KVI_DEBUG_CLASS_NAME_,_string)
#endif //ifdef_KVI_DEBUG_WARNINGS_
#ifndef _KVI_DEBUG_WARNINGS_
	#define _debug_warning(_string)
#endif //ifndef _KVI_DBG_WARNINGS_

#ifdef _KVI_DEBUG_CHECK_RANGE_
	#define _range_warning(_string) debug("RANGE WARNING : %s in %s (%d)",_string,__FILE__,__LINE__)
	#define _range_valid(_x) if(!(_x)) debug("RANGE ASSERT : \"%s\" is false in %s (%d)",#_x,__FILE__,__LINE__)
	#define _range_invalid(_x) if(_x) debug("RANGE ASSERT : \"%s\" is true in %s (%d)",#_x,__FILE__,__LINE__)
#endif
#ifndef _KVI_DEBUG_CHECK_RANGE_
	#define _range_warning(_string)
	#define _range_valid(_x)
	#define _range_invalid(_x)
#endif

#define _debug_fatal(_string) { debug(_string); exit(-1); }

#endif //_KVI_DEBUG_H_INCLUDED_
