//   $Id: kvi_clrbox.cpp,v 1.2 1998/09/20 20:22:20 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#include "kvi_clrbox.h"
#include "kvi_frame.h"

#include <qbrush.h>
#include <qdrawutil.h>

KviClrBox::KviClrBox(QWidget *parent,KviFrame *lpFrame,const char *name) : QFrame(parent,name)
{
	m_lpFrame=lpFrame;
	m_lpParent=parent;
	setFrameStyle(Panel | Raised);
	resize(274,19); //ahah!
	hide();
}

KviClrBox::~KviClrBox(){}

void KviClrBox::drawContents(QPainter *p)
{
	QColorGroup g=colorGroup();
	for(int i=0;i<16;i++){
		QBrush fill(*(m_lpFrame->m_lpColor[i]));
		qDrawShadePanel(p,17*i,1,17,17,g,true,1,&fill);
		QString szNum;
		szNum.setNum(i);
		int lightness=(m_lpFrame->m_lpColor[i]->red())+(m_lpFrame->m_lpColor[i]->green())+(m_lpFrame->m_lpColor[i]->blue());
		if(lightness>(240))p->setPen(black);
		else p->setPen(white);
		p->drawText(17*i,1,16,16,AlignCenter,szNum.data());
	}
}

void KviClrBox::mousePressEvent(QMouseEvent *)
{
	hide();
} 
#include "m_kvi_clrbox.moc"
