//   $Id: kvi_child.h,v 1.2 1998/09/20 20:22:16 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_CHILD_H_INCLUDED_
#define _KVI_CHILD_H_INCLUDED_

#define KVI_MDI_NORESIZE 0
#define KVI_MDI_RESIZE_LEFT   1 
#define KVI_MDI_RESIZE_RIGHT  2 
#define KVI_MDI_RESIZE_TOP    4 
#define KVI_MDI_RESIZE_BOTTOM 8 
#define KVI_MDI_RESIZE_TOPLEFT     (KVI_MDI_RESIZE_LEFT|KVI_MDI_RESIZE_TOP) 
#define KVI_MDI_RESIZE_TOPRIGHT    (KVI_MDI_RESIZE_RIGHT|KVI_MDI_RESIZE_TOP) 
#define KVI_MDI_RESIZE_BOTTOMLEFT  (KVI_MDI_RESIZE_LEFT|KVI_MDI_RESIZE_BOTTOM) 
#define KVI_MDI_RESIZE_BOTTOMRIGHT (KVI_MDI_RESIZE_RIGHT|KVI_MDI_RESIZE_BOTTOM) 
#define KVI_MDI_CHILD_RESIZE_TIMES 10
#define KVI_MDI_CHILD_SLEEP_TIME 100

//#include <qmlined.h>

#include <qframe.h>
#include <qlabel.h>
#include <qpopupmenu.h>
#include <qpixmap.h>

class KviView;
class KviInterface;
class KviMdiManager;
class KviFrame;

#include "kvi_sysbtn.h"

class KviMdiChild : public QFrame
{
	friend class KviMdiManager;
	Q_OBJECT;
public:	
	KviMdiChild(KviMdiManager *parent,KviFrame *frame,const char *name,int aid,int atype);
	virtual ~KviMdiChild();
public:
	int				m_iId;
	int				m_iType;
	const char 		*m_szIconName;
	KviMdiManager	*m_lpMdi;
	KviInterface	*m_lpInt;
	KviFrame		*m_lpFrm;
	KviView         *m_lpOutput;
	bool			m_bMaximized;
	bool			m_bMinimized;
	bool			m_bCloseEnabled;
	bool            m_bIdentParsingEnabled;
	/////TEST
	//QMultiLineEdit	*m_lpLineEdit;
private:
	QLabel			*m_lpSysLabel;
	KviSysWinButton	*m_lpCloseBtn;
	KviSysWinButton	*m_lpMaximizeBtn;
	KviSysWinButton	*m_lpMinimizeBtn;
	KviSysWinButton	*m_lpIconBtn;
	QWidget			*m_lpFocusOwner;
	QPopupMenu		*m_lpSystemPopup;
	bool			m_bCanMove;
	int				m_iResizeCorner;
	QRect			m_restoredRect;
	bool			m_bLabelRaised;
public:
	int id(){ return m_iId; };
	int type(){ return m_iType; };
	const QPixmap * getIcon(){ return m_lpIconBtn->pixmap(); };
	void setIcon(const char *szIconName);
	void enableClose(bool bEnable);
	void raiseLabel(bool bRaise);
	bool killWindow();
	virtual void doOutput(int nType,const char *szText);
	virtual void doFmtOutput(int nType,const char *szFmt,...);
	virtual void applyOptions();
	virtual void sendData(const char *szData);
public slots:
	virtual void maximizeWindow(bool bAnimate=true);
	virtual void minimizeWindow(bool bAnimate=true);
	void maximize(){ maximizeWindow(true); };
	void minimize(){ minimizeWindow(true); };
	virtual void closeSlot();
	void closeButtonSlot();
	void saveBuffer();
	void clearBuffer();
	void toggleIdentParsing();
	void toggleTimestamp();
	void toggleShowPixmaps();
	void setViewPixmap();
	void setViewFont();
	void setupLogging();
	void autoLog();
signals:
	void closeButtonPressed();
	void windowMaximized(KviMdiChild *);
	void windowMinimized(KviMdiChild *);
protected:
	void setFocusOwner(QWidget *lpC);
	void updateRects();
	QRect viewSizeHint();
	void showSystemMenu(QPoint where);
	void applyOptionsInternal();
	virtual void focusInEvent(QFocusEvent *);
	virtual void focusOutEvent(QFocusEvent *);
	virtual void resizeEvent(QResizeEvent *);
	virtual bool eventFilter(QObject *ob,QEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *);
	virtual void mouseMoveEvent(QMouseEvent *);
private:
	void linkChildren(QWidget *widget,QWidget *focusedOne);
	void highlightWindow();
public:
	void setName(const char *name);
private:
	void resizeWindow(int resizeCorner);
	int getResizeCorner(int ax,int ay);
//	void drawDragRectangle( QRect &rectToDraw);
	void moveWindow();
	void drawResizeAnimation(QRect &start,QRect &finish);
};
#endif // _KVI_CHILD_H_INCLUDED_
