//   $Id: kvi_child.cpp,v 1.6 1998/09/23 12:41:33 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#define _KVI_DEBUG_CLASS_NAME_ "KviMdiChild"

#include "kvi_macros.h"
#include "kvi_child.h"
#include "kvi_mdi.h"
#include "kvi_debug.h"
#include "kvi_frame.h"
#include "kvi_view.h"
#include "kvi_app.h"
#include "kvi_taskbar.h"
#include "kvi_int.h"
#include "kvi_opt.h"

#include <kfontdialog.h>
//#include <kfiledialog.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include <X11/Xlib.h>

#include <sys/types.h>
#include <unistd.h>

////////////////////
// WARNING :
// You MUST call set focus owner
// with a windows child to work

////////////////////////////////////////////////////////////////////////////////////////////////////////
//// The caption buttons
////////////////////////////////////////////////////////////////////////////////////////////////////////

//static const char * _the_default_kvi_icon_xpm_[] = {
//"16 16 9 1",
//" 	s None c None",
//".	c #7BDE7BDE7BDE",
//"X	c #739C739C739C",
//"o	c #5AD65AD65AD6",
//"O	c #000000000000",
//"+	c #4A524A524A52",
//"@	c #BDEEBDEEBDEE",
//"#	c #C630C630C630",
//"$	c #CE72D6B4E738",
//"                ",
//"                ",
//"  ...X.XXooooo  ",
//"  .OOOOOOOOOOo  ",
//"  .XXoooooooo+  ",
//"  X@@@@@@@@@@o  ",
//"  .@@#@#@#@#$o  ",
//"  X@#@#@#@#$#+  ",
//"  X@@#$$$#$#$+  ",
//"  X@###$$$#$$+  ",
//"  X@@##$$$$$$+  ",
//"  X@#$$$$$$$$+  ",
//"  oooooo++++++  ",
//"                ",
//"                ",
//"                "};
static const char * _the_default_kvi_maximize_xpm_[] = {
"16 16 3 1",
" 	s None	c None",
".	c white",
"X	c #707070",
"                ",
"                ",
"                ",
"   ...........  ",
"   .XXXXXXXXXX  ",
"   .X       .X  ",
"   .X       .X  ",
"   .X       .X  ",
"   .X       .X  ",
"   .X       .X  ",
"   .X       .X  ",
"   .X       .X  ",
"   .X........X  ",
"   .XXXXXXXXXX  ",
"                ",
"                "};
static const char * _the_default_kvi_minimize_xpm_[] = {
"16 16 3 1",
" 	s None	c None",
".	c white",
"X	c #707070",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                ",
"       ...      ",
"       . X      ",
"       .XX      ",
"                ",
"                ",
"                ",
"                ",
"                ",
"                "};
static const char * _the_default_kvi_close_xpm_[] = {
"16 16 3 1",
" 	s None	c None",
".	c white",
"X	c #707070",
"                ",
"                ",
"                ",
"   .X        .X ",
"   .XX      .XX ",
"    .XX    .XX  ",
"     .XX  .XX   ",
"      .XX.XX    ",
"       .XXX     ",
"       .XXX     ",
"      .XX.XX    ",
"     .XX  .XX   ",
"    .XX    .XX  ",
"   .XX      .XX ",
"   .X        .X ",
"                "};

//============ KviMdiChild ============//

KviMdiChild::KviMdiChild(KviMdiManager *parent,KviFrame *frame,const char *name,int aid,int atype):QFrame(parent,name)
{
	_debug_entertrace("KviMdiChild");
	hide();
	m_iId			=aid;
	m_iType			=atype;
	m_szIconName	="";
	m_lpMdi			=parent;
	m_lpFrm			=frame;
	m_lpInt			=m_lpFrm->m_lpInt;
	m_bCloseEnabled	=true;
	m_bCanMove		=false;
	m_bMaximized	=false;
	m_bMinimized	=false;
	setFrameStyle(WinPanel | Raised);
	setFocusPolicy(QWidget::StrongFocus);
	QPixmap close_pixmap(_the_default_kvi_close_xpm_);
	QPixmap minimize_pixmap(_the_default_kvi_minimize_xpm_);
	QPixmap maximize_pixmap(_the_default_kvi_maximize_xpm_);
//	QPixmap default_icon_pixmap(_the_default_kvi_icon_xpm_);
	m_lpCloseBtn = new KviSysWinButton(this);
	m_lpCloseBtn->setPixmap(close_pixmap);
	m_lpMaximizeBtn = new KviSysWinButton(this);
	m_lpMaximizeBtn->setPixmap(maximize_pixmap);
	m_lpMinimizeBtn = new KviSysWinButton(this);
	m_lpMinimizeBtn->setPixmap(minimize_pixmap);
	m_lpIconBtn = new KviSysWinButton(this);
	m_lpIconBtn->setPixmap(*(m_lpFrm->m_lpIcon[atype]));
	m_lpSysLabel = new QLabel(name,this);
	m_lpSysLabel->setLineWidth(1);
	m_lpSysLabel->setFrameStyle(Panel | Sunken);
	m_bIdentParsingEnabled=(!m_lpFrm->m_lpOpt->bIdentParsingOff);
	m_lpSystemPopup = new QPopupMenu();
	m_lpSystemPopup->insertItem(i18n("Maximize"),this,SLOT(maximize()));
	m_lpSystemPopup->setId(0,0);
	m_lpSystemPopup->insertItem(i18n("Minimize"),this,SLOT(minimize()));
	m_lpSystemPopup->insertItem(i18n("Close"),this,SLOT(closeButtonSlot()));
	m_lpSystemPopup->setId(2,2);
	m_lpSystemPopup->insertSeparator();
	m_lpSystemPopup->insertItem(i18n("Clear buffer"),this,SLOT(clearBuffer()));
	m_lpSystemPopup->insertItem(i18n("Save buffer to file"),this,SLOT(saveBuffer()));
	m_lpSystemPopup->insertSeparator();
	m_lpSystemPopup->insertItem(i18n("Toggle timestamp"),this,SLOT(toggleTimestamp()));
	m_lpSystemPopup->setId(7,7);
	m_lpSystemPopup->insertItem(i18n("Toggle message images"),this,SLOT(toggleShowPixmaps()));
	m_lpSystemPopup->setId(8,8);
	if(m_bIdentParsingEnabled)m_lpSystemPopup->insertItem(i18n("Disable identifiers parsing"),this,SLOT(toggleIdentParsing()));
	else m_lpSystemPopup->insertItem(i18n("Enable identifiers parsing"),this,SLOT(toggleIdentParsing()));
	m_lpSystemPopup->setId(9,9);
	m_lpSystemPopup->insertSeparator();
	m_lpSystemPopup->insertItem(i18n("Set background image (temp)"),this,SLOT(setViewPixmap()));
	m_lpSystemPopup->insertItem(i18n("Set font (temp)"),this,SLOT(setViewFont()));
	m_lpSystemPopup->insertSeparator();
	m_lpSystemPopup->insertItem(i18n("Logging ..."),this,SLOT(setupLogging()));
	m_lpOutput=0;
	setMinimumWidth(KVI_MDI_CHILD_MIN_WIDTH);
	setMinimumHeight(KVI_MDI_CHILD_MIN_HEIGHT);
	applyOptionsInternal();
	setMouseTracking(TRUE);
	_debug_leavetrace("KviMdiChild");
}
//============ ~KviMdiChild ============//
KviMdiChild::~KviMdiChild()
{
	_debug_entertrace("~KviMdiChild");
	delete m_lpCloseBtn;
	delete m_lpMaximizeBtn;
	delete m_lpMinimizeBtn;
	delete m_lpIconBtn;
	delete m_lpSysLabel;
	delete m_lpSystemPopup;
	_debug_leavetrace("~KviMdiChild");
}
//============ closeSlot ============//
void KviMdiChild::closeSlot()
{
	_debug_entertrace("closeSlot");
	_debug_leavetrace("closeSlot");
}
//============ toggleIdentParsing ============//
void KviMdiChild::toggleIdentParsing()
{
	_debug_entertrace("toggleIdentParsing");
	m_bIdentParsingEnabled=!m_bIdentParsingEnabled;
	if(m_bIdentParsingEnabled)m_lpSystemPopup->changeItem(i18n("Disable identifiers parsing"),9);
	else m_lpSystemPopup->changeItem(i18n("Enable identifiers parsing"),9);
	_debug_leavetrace("toggleIdentParsing");
}
//============ toggleTimestamp ============//
void KviMdiChild::toggleTimestamp()
{
	_debug_entertrace("toggleTimestamp");
	if(m_lpOutput){
		m_lpOutput->m_bTimestamp=!m_lpOutput->m_bTimestamp;
		if(m_lpOutput->m_bTimestamp)m_lpSystemPopup->changeItem(i18n("Disable timestamp"),7);
		else m_lpSystemPopup->changeItem(i18n("Enable timestamp"),7);
	}
	_debug_leavetrace("toggleTimestamp");
}
//============ toggleShowPixmaps ============//
void KviMdiChild::toggleShowPixmaps()
{
	_debug_entertrace("toggleShowPixmaps");
	if(m_lpOutput){
		m_lpOutput->m_bShowPixmaps=!m_lpOutput->m_bShowPixmaps;
		m_lpOutput->repaint(false);
		if(m_lpOutput->m_bShowPixmaps)m_lpSystemPopup->changeItem(i18n("Disable message images"),8);
		else m_lpSystemPopup->changeItem(i18n("Enable message images"),8);
	}
	_debug_leavetrace("toggleShowPixmaps");
}
//============ setViewPixmap ============//
void KviMdiChild::setViewPixmap()
{
	_debug_entertrace("setViewPixmap");
	if(!m_lpOutput)return;
	QString szImagesDir=_macro_getKVircHomeDirectory("/Images");
//	m_lpFrm->m_bFocusManagingEnabled=false;
//	QString szFileName=KFileDialog::getOpenFileName(szImagesDir.data(),0,this,0);
//	m_lpFrm->m_bFocusManagingEnabled=true;
	QString szFileName=_macro_getOpenFileName(i18n("Open image file..."),szImagesDir.data(),
		i18n("*.gif|Gif files (*.gif)\n*.xpm|X Pixmaps (*.xpm)\n*.ppm|Ppm files (*.ppm)\n*.*|All files"));
	if(!szFileName.isEmpty()){
//		debug("loading icon %s",szFileName.data());
		QPixmap pix=_macro_kviIconLoader->loadIcon(szFileName.data());
		if(pix.isNull()){
			m_lpFrm->m_bFocusManagingEnabled=false;
			KMsgBox::message(this,i18n("Image I/O error"),
					 i18n("The file can not be open or it is not a valid image.\n"\
					      "If you have the original KDE 1.0 release , \n"\
					      "this may be due to a KIconLoader bug with absolute paths.\n"\
					      "In that case try moving the image to $HOME/kvirc/Images and\n"\
					      "then use the /WINDOW setimage command."));
			m_lpFrm->m_bFocusManagingEnabled=true;
			return;
		}
		m_lpOutput->setUserBackground(szFileName.data());
		m_lpOutput->repaint(false);
	}
	_debug_leavetrace("setViewPixmap");
}
//============ setViewFont ============//
void KviMdiChild::setViewFont()
{
	_debug_entertrace("setViewFont");
	if(!m_lpOutput)return;
	KFontDialog aDialog(this,"KviFontChanger",true);
	aDialog.setCaption(i18n("Choose a font for the view (temp setting)"));
	aDialog.setFont(m_lpOutput->font());
	m_lpFrm->m_bFocusManagingEnabled=false;
	if(aDialog.exec()==QDialog::Accepted){
		m_lpOutput->setFont(aDialog.font());
		m_lpOutput->repaint(false);
	}
	m_lpFrm->m_bFocusManagingEnabled=true;
	_debug_leavetrace("setViewFont");
}
//============ setupLogging ============//
void KviMdiChild::setupLogging()
{
	_debug_entertrace("setupLogging");
	if(m_lpOutput)m_lpOutput->setupLogging(this);
	_debug_leavetrace("setupLogging");
}
//============ autoLog ============//
void KviMdiChild::autoLog()
{
	_debug_entertrace("autoLog");
	if(m_lpOutput)m_lpOutput->autoLog(this);
	_debug_leavetrace("autoLog");
}
//============ saveBuffer ============//
void KviMdiChild::saveBuffer()
{
	_debug_entertrace("saveBuffer");
	if(m_lpOutput)m_lpOutput->saveBuffer();
	_debug_leavetrace("saveBuffer");
}
//============ clearBuffer ============//
void KviMdiChild::clearBuffer()
{
	_debug_entertrace("clearBuffer");
	if(m_lpOutput)m_lpOutput->clearBuffer();
	_debug_leavetrace("clearBuffer");
}
//============ killWindow ============//
bool KviMdiChild::killWindow()
{
	_debug_entertrace("killWindow");
	WId theId=winId();
	QCloseEvent e;
	_macro_kviApplication->processEvents();
    bool acceptClose = QApplication::sendEvent( this, &e );
    if(!QWidget::find(theId))return true; //already deleted
    if(acceptClose){
		hide();
	    delete this;
    }
    return accept;
	_debug_leavetrace("killWindow");
}
//============ setName ===============//
void KviMdiChild::setName(const char *name)
{
	_debug_entertrace("setName");
	((QObject *)this)->setName(name);
	m_lpSysLabel->setText(name);
	m_lpSysLabel->repaint();
	m_lpMdi->m_lpTaskBar->changeButtonText(id(),name);
	_debug_leavetrace("setName");
}
//============= enableClose =============//
void KviMdiChild::enableClose(bool bEnable)
{
	_debug_entertrace("enableClose");
	m_bCloseEnabled=bEnable;
	m_lpSystemPopup->setItemEnabled(2,bEnable);
	m_lpCloseBtn->setEnabled(bEnable);
	_debug_leavetrace("enableClose");
}
//============== setFocusOwner ==============//
void KviMdiChild::setFocusOwner(QWidget *lpC)
{
	_debug_entertrace("setFocusOwner");
	m_lpFocusOwner=lpC;
	setFocusProxy(lpC);
	linkChildren(this,lpC);
	updateRects();
	setFocus();
	_debug_leavetrace("setFocusOwner");
}
//============== linkChildren ==================//
void KviMdiChild::linkChildren(QWidget *widget,QWidget *focusedOne)
{
	_debug_entertrace_huge("linkChildren");
	QList<QObject> *list = (QList<QObject> *)(widget->children());
	if(list){
		for (unsigned int i=0; i< list->count(); i++){
			QObject *w = list->at(i);
			if(w->inherits("QWidget"))linkChildren(((QWidget *)w),focusedOne);
		}
	}
	widget->installEventFilter(this);
	if(widget != focusedOne)widget->setFocusProxy(focusedOne);
	_debug_leavetrace_huge("linkChildren");
}
//================ setIcon ==================//
void KviMdiChild::setIcon(const char *szIconName)
{
	_debug_entertrace("setIcon");
	KIconLoader *lpIL = _macro_kviIconLoader;
	m_szIconName=szIconName;
	m_lpIconBtn->setPixmap(lpIL->loadIcon(szIconName));	
	_debug_leavetrace("setIcon");
}
//=============== raiseLabel =================//
void KviMdiChild::raiseLabel(bool bRaise)
{
	m_bLabelRaised=bRaise;
	QPalette labelPal=m_lpSysLabel->palette();
	QColorGroup aCG(labelPal.normal());
	if(bRaise){
		m_lpSysLabel->setFrameStyle(Panel | Sunken);
		QColorGroup nCG(aCG.foreground(),aCG.background(),aCG.light(),
			 	aCG.dark(), aCG.mid(),m_lpInt->clr_fr_act_caption, aCG.base()); 
		labelPal.setNormal(nCG);
		m_lpSysLabel->setPalette(labelPal);

		if(!(m_lpInt->pix_bk_caption.isNull())){
			m_lpSysLabel->setBackgroundPixmap(m_lpInt->pix_bk_caption);
		} else m_lpSysLabel->setBackgroundColor(m_lpInt->clr_bk_act_caption);
	} else {
		m_lpSysLabel->setFrameStyle(Panel | Raised);		
		QColorGroup nCG(aCG.foreground(),aCG.background(),aCG.light(),
					 		aCG.dark(), aCG.mid(),m_lpInt->clr_fr_ina_caption, aCG.base()); 
		labelPal.setNormal(nCG);
		m_lpSysLabel->setPalette(labelPal);		

		if(!(m_lpInt->pix_bk_caption.isNull())){
			m_lpSysLabel->setBackgroundPixmap(m_lpInt->pix_bk_caption);
		} else m_lpSysLabel->setBackgroundColor(m_lpInt->clr_bk_ina_caption);
	}
	m_lpSysLabel->repaint();
}
//============ focusInEvent ============//
void KviMdiChild::focusInEvent(QFocusEvent *)
{
	_debug_entertrace("focusInEvent");
	m_lpMdi->childFocusIn(this);
	raiseLabel(true);
	_debug_leavetrace("focusInEvent");
}
//============ focusOutEvent ============//
void KviMdiChild::focusOutEvent(QFocusEvent *)
{
	_debug_entertrace("focusOutEvent");
	m_lpMdi->childFocusOut(this);
	if(m_lpMdi->topChildInZOrder() != this)raiseLabel(false);
	_debug_leavetrace("focusOutEvent");
}
void KviMdiChild::resizeEvent(QResizeEvent *)
{
	_debug_entertrace_huge("resizeEvent");
	updateRects();
	_debug_leavetrace_huge("resizeEvent");
}
void KviMdiChild::updateRects()
{
	_debug_entertrace("updateRects");
	m_lpCloseBtn->setGeometry(	width()-(KVI_MDI_CHILD_BORDER+KVI_MDI_CHILD_SYSBTN_SIZE),
					KVI_MDI_CHILD_BORDER,
					KVI_MDI_CHILD_SYSBTN_SIZE,
					KVI_MDI_CHILD_SYSBTN_SIZE);
	m_lpMaximizeBtn->setGeometry(	width()-(KVI_MDI_CHILD_BORDER+(KVI_MDI_CHILD_SYSBTN_SIZE*2)+
							KVI_MDI_CHILD_SYSBTN_SEP),
					KVI_MDI_CHILD_BORDER,
					KVI_MDI_CHILD_SYSBTN_SIZE,
					KVI_MDI_CHILD_SYSBTN_SIZE);
	m_lpMinimizeBtn->setGeometry(	width()-(KVI_MDI_CHILD_BORDER+(KVI_MDI_CHILD_SYSBTN_SIZE*3)+
							(KVI_MDI_CHILD_SYSBTN_SEP*2)),
					KVI_MDI_CHILD_BORDER,
					KVI_MDI_CHILD_SYSBTN_SIZE,
					KVI_MDI_CHILD_SYSBTN_SIZE);
	m_lpIconBtn->setGeometry(	KVI_MDI_CHILD_BORDER,
					KVI_MDI_CHILD_BORDER,
					KVI_MDI_CHILD_SYSBTN_SIZE,
					KVI_MDI_CHILD_SYSBTN_SIZE);
	m_lpSysLabel->setGeometry(	KVI_MDI_CHILD_BORDER+KVI_MDI_CHILD_SYSBTN_SIZE+KVI_MDI_CHILD_SYSBTN_SEP,
					KVI_MDI_CHILD_BORDER,
					width()-((KVI_MDI_CHILD_BORDER*2)+(KVI_MDI_CHILD_SYSBTN_SIZE*4)+(KVI_MDI_CHILD_SYSBTN_SEP*3)),
					KVI_MDI_CHILD_SYSBTN_SIZE);
	_debug_leavetrace("updateRects");
}
QRect KviMdiChild::viewSizeHint(){
	return QRect(KVI_MDI_CHILD_BORDER,
					KVI_MDI_CHILD_BORDER+KVI_MDI_CHILD_SYSBTN_SIZE+KVI_MDI_CHILD_SEP,
					width()-(KVI_MDI_CHILD_BORDER*2),
					height()-((KVI_MDI_CHILD_BORDER*2)+KVI_MDI_CHILD_SYSBTN_SIZE+KVI_MDI_CHILD_SEP));		
}

bool KviMdiChild::eventFilter(QObject *ob,QEvent *e)
{
	//debug("@@@ KviMdiChild : event : %d from : %s",e->type(),ob->className());
	switch(e->type()){
		case Event_MouseButtonPress:
			mousePressEvent((QMouseEvent *)e);
			if(ob==m_lpSysLabel)m_bCanMove=true;
			break;
		case Event_MouseButtonRelease:
			if(ob==m_lpSysLabel)m_bCanMove=false;
			else if(ob==m_lpCloseBtn){
				if(m_bCloseEnabled)emit closeButtonPressed();
			} else if(ob==m_lpMaximizeBtn)maximizeWindow();
			else if(ob==m_lpMinimizeBtn)minimizeWindow();
			else if(ob==m_lpIconBtn){
				QPoint pnt=((QMouseEvent *)e)->pos();
				showSystemMenu(mapToGlobal(pnt));
			}
			break;
		case Event_MouseButtonDblClick:
			if(ob==m_lpSysLabel)maximizeWindow();
			break;
		case Event_MouseMove:
			if(ob==m_lpSysLabel){
				if(((QMouseEvent *) e)->state() & LeftButton){
					if(m_bCanMove){
						m_bCanMove=FALSE;
						moveWindow();
					}
				}
			}
			break;
		case Event_Enter:
//			debug("Event_Enter from %s",ob->className());
			if(ob != this){
				setCursor (arrowCursor); 
				m_iResizeCorner=KVI_MDI_NORESIZE;
				if(ob->inherits("KviView")||
					ob->inherits("KviListBox")||
					ob->inherits("QLabel")||
					ob->inherits("KviSysWinButton"))((QWidget *)ob)->setCursor(arrowCursor);
			}
			break;
		case Event_FocusIn:
			if((m_lpMdi->topChildInZOrder() != this)||(!m_bLabelRaised))focusInEvent((QFocusEvent*)e);
			break;
		case Event_FocusOut:
			focusOutEvent((QFocusEvent *)e);
			break;
	}
	return false;
}
void KviMdiChild::showSystemMenu(QPoint where)
{
	m_lpSystemPopup->popup(where);
}
void KviMdiChild::closeButtonSlot()
{
	if(m_bCloseEnabled)emit closeButtonPressed();
}
void KviMdiChild::mousePressEvent(QMouseEvent *e)
{
	
	if(!isActiveWindow()){
		setActiveWindow();
		topLevelWidget()->raise();
	}
	setFocus();
	QPoint mousePressPoint = e->pos();
	m_iResizeCorner=getResizeCorner(mousePressPoint.x(),mousePressPoint.y());	
}
void KviMdiChild::mouseReleaseEvent(QMouseEvent *)
{
	if(m_iResizeCorner != KVI_MDI_NORESIZE){
		setCursor (arrowCursor); 
		m_iResizeCorner=KVI_MDI_NORESIZE;
	}
}
void KviMdiChild::mouseMoveEvent(QMouseEvent *e)
{
	if(e->state() & LeftButton){
		if(m_iResizeCorner){
			resizeWindow(m_iResizeCorner);
		}
	} else {
		QPoint currentPoint = e->pos();
        int r = getResizeCorner(currentPoint.x(), currentPoint.y());
		switch (r) { 
			case KVI_MDI_NORESIZE: 
				setCursor (arrowCursor); 
				break; 
			case KVI_MDI_RESIZE_LEFT: 
			case KVI_MDI_RESIZE_RIGHT: 
				setCursor (sizeHorCursor ); 
				break; 
			case KVI_MDI_RESIZE_TOP: 
			case KVI_MDI_RESIZE_BOTTOM: 
				setCursor ( sizeVerCursor ); 
				break; 
			case KVI_MDI_RESIZE_TOPLEFT: 
			case KVI_MDI_RESIZE_BOTTOMRIGHT: 
				setCursor ( sizeFDiagCursor ); 
				break; 
			case KVI_MDI_RESIZE_BOTTOMLEFT: 
			case KVI_MDI_RESIZE_TOPRIGHT: 
				setCursor ( sizeBDiagCursor ); 
				break; 
		} 
	}
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////
////// Move Window...
///////////////////////////////////////////////////////////////////////////////////////////////////////////
void KviMdiChild::moveWindow()
{
	QRect absoluteWinRect(x(), y(), width(), height());

	XGrabServer(qt_xdisplay());
	m_lpMdi->drawDragRectangle(absoluteWinRect);
	
	XEvent ev;
	Window dummyWin1, dummyWin2;
	int dummy1, dummy2;
	unsigned int dummy3;
   
	QPoint oldMousePos = QCursor::pos();
	int mouseNewX;
	int mouseNewY;
	
	while ((!XCheckMaskEvent(qt_xdisplay(),  (ButtonPressMask|ButtonReleaseMask), &ev))){
		XQueryPointer(qt_xdisplay(), qt_xrootwin(), &dummyWin1, &dummyWin2, &mouseNewX, &mouseNewY, &dummy1, &dummy2, &dummy3);
		
		QPoint mousePos = QPoint(mouseNewX, mouseNewY);
		if (oldMousePos != mousePos){
			m_lpMdi->drawDragRectangle(absoluteWinRect);
			int nX = absoluteWinRect.x() + (mousePos.x()-oldMousePos.x());
			nX = QMAX(nX, KVI_MDI_CHILD_MIN_VISIBLE_EDGE-width());
			nX = QMIN(nX, parentWidget()->width()-KVI_MDI_CHILD_MIN_VISIBLE_EDGE);
			int nY = absoluteWinRect.y() + (mousePos.y()-oldMousePos.y());
			nY = QMAX(nY, 0);
			nY = QMIN(nY, parentWidget()->height()-KVI_MDI_CHILD_MIN_VISIBLE_EDGE);
			absoluteWinRect = QRect(nX, nY,  absoluteWinRect.width(), absoluteWinRect.height());
			m_lpMdi->drawDragRectangle(absoluteWinRect);
			oldMousePos = mousePos;
		}
	}
	m_lpMdi->drawDragRectangle(absoluteWinRect);
	XUngrabServer(qt_xdisplay());
	move(absoluteWinRect.x(), absoluteWinRect.y());
	m_bMaximized=false;
	emit windowMaximized(0);
	m_lpSystemPopup->changeItem(i18n("Maximize"),0);
}

//static void KviMdiChild::m_lpMdi->drawDragRectangle( QRect &rectToDraw)
//{
//	if (!rectToDraw.isNull()){
//		XGCValues gcvals;
//		gcvals.foreground=black.pixel();
//		gcvals.subwindow_mode=IncludeInferiors;
//		gcvals.function=GXinvert;
  //      
//		GC gc=XCreateGC(x11Display(),m_lpMdi->handle(),GCForeground|GCSubwindowMode|GCFunction,&gcvals);
//		XDrawRectangle(x11Display(),m_lpMdi->handle(),gc,rectToDraw.x(),rectToDraw.y(),rectToDraw.width(),rectToDraw.height());
//		XDrawRectangle(x11Display(),m_lpMdi->handle(),gc,rectToDraw.x()+1,rectToDraw.y()+1,rectToDraw.width()-2,rectToDraw.height()-2);
//		XFreeGC(x11Display(),gc);
//	}
//}

int KviMdiChild::getResizeCorner(int ax,int ay)
{
	int ret = KVI_MDI_NORESIZE; 
	if((ax>0)&&(ax<KVI_MDI_CHILD_RESIZE_BORDER)) 
		ret |= KVI_MDI_RESIZE_LEFT; 
	if((ax<width())&&(ax>(width()-KVI_MDI_CHILD_RESIZE_BORDER))) 
		ret |= KVI_MDI_RESIZE_RIGHT; 
	if((ay>0)&&(ay<(KVI_MDI_CHILD_RESIZE_BORDER))) 
		ret |= KVI_MDI_RESIZE_TOP; 
	if((ay<(height()))&&(ay>(height()-KVI_MDI_CHILD_RESIZE_BORDER))) 
		ret |= KVI_MDI_RESIZE_BOTTOM; 
//	debug("get resize corenr returns %d",ret);
	return ret; 
}

void KviMdiChild::resizeWindow(int resizeCorner)
{
	m_iResizeCorner=KVI_MDI_NORESIZE;
	QRect resizeRect(x(), y(), width(), height());
    
	XGrabServer(qt_xdisplay());
	m_lpMdi->drawDragRectangle(resizeRect);
	XEvent ev;
	QPoint oldMousePos = QCursor::pos();
	while (!XCheckMaskEvent(qt_xdisplay(),  (ButtonPressMask|ButtonReleaseMask), &ev)){
		Window dw1, dw2;
		int t1, t2;
		unsigned int t3;
		int newX, newY;
		XQueryPointer(qt_xdisplay(), qt_xrootwin(), &dw1, &dw2, &newX, &newY, &t1, &t2, &t3);
		QPoint mousePos = QPoint(newX, newY);
		if (oldMousePos != mousePos){
			m_lpMdi->drawDragRectangle(resizeRect);
			int rX = resizeRect.x();
			int rY = resizeRect.y();
			int rW = resizeRect.width();
			int rH = resizeRect.height();
			int dX = mousePos.x() - oldMousePos.x();
			int dY = mousePos.y()-oldMousePos.y();
			switch (resizeCorner){
			case KVI_MDI_RESIZE_LEFT: 
				rX += dX; rW -= dX; 
				break; 
			case KVI_MDI_RESIZE_RIGHT: 
				rW += dX; 
				break; 
			case KVI_MDI_RESIZE_TOP: 
				rY += dY; rH -= dY; 
				break; 
			case KVI_MDI_RESIZE_BOTTOM: 
				rH += dY; 
				break; 
			case KVI_MDI_RESIZE_BOTTOMRIGHT:
				rW += dX; rH += dY;
				break;
			case KVI_MDI_RESIZE_TOPRIGHT:
				rY += dY; rW += dX; rH -= dY;
				break;
			case KVI_MDI_RESIZE_BOTTOMLEFT:
				rX += dX; rW -= dX; rH += dY;
				break;
			case KVI_MDI_RESIZE_TOPLEFT:
				rX += dX; rY += dY; rW -= dX; rH -= dY;
				break;
			}
			resizeRect = QRect(QMIN(rX, x() + width()-KVI_MDI_CHILD_MIN_WIDTH), \
					QMIN(rY, y() + height()-KVI_MDI_CHILD_MIN_HEIGHT), \
					QMAX(rW, KVI_MDI_CHILD_MIN_WIDTH), QMAX(rH, KVI_MDI_CHILD_MIN_HEIGHT));
			m_lpMdi->drawDragRectangle(resizeRect);
			oldMousePos = mousePos;
		}	
	}
	m_lpMdi->drawDragRectangle(resizeRect);
	XUngrabServer(qt_xdisplay());
	setGeometry(resizeRect.x(), resizeRect.y(), resizeRect.width(), resizeRect.height());
	setCursor (arrowCursor);
	m_bMaximized=false;
	emit windowMaximized(0);
	m_lpSystemPopup->changeItem(i18n("Maximize"),0);
}
//
void KviMdiChild::drawResizeAnimation(QRect &start, QRect &finish)
{
    int times = KVI_MDI_CHILD_RESIZE_TIMES;
    QRect r;
    int cX = start.x();
    int cY = start.y();
    int cW = start.width();
    int cH = start.height();
    XGrabServer(qt_xdisplay());
    for (int i=0; i<times; i++)
    {
        r = QRect(cX, cY, cW, cH);
        m_lpMdi->drawDragRectangle(r);
        XFlush(qt_xdisplay());
        XSync(qt_xdisplay(), False);
		//loose some time....don't use sleep
#ifdef HAVE_USLEEP
        usleep(KVI_MDI_CHILD_SLEEP_TIME);
#endif
        m_lpMdi->drawDragRectangle(r);
        cX += (finish.x()-start.x())/(times);
        cY +=  (finish.y()-start.y())/(times);
        cW += (finish.width()-start.width())/times;
        cH += (finish.height()-start.height())/times;
    }
    XUngrabServer(qt_xdisplay());
}

void KviMdiChild::maximizeWindow(bool bAnimate)
{
	if (m_bMaximized){
		m_bMaximized = false;
		QWidget *p = (QWidget *)parent();
		QRect e(0,0, p->width(), p->height());
		if(bAnimate)drawResizeAnimation(e,m_restoredRect);
		setGeometry(m_restoredRect);
		emit windowMaximized(0);
		m_lpSystemPopup->changeItem(i18n("Maximize"),0);
	}else{
		m_bMaximized = true;
		QWidget *p = (QWidget *)parent();
		m_restoredRect.setRect(x(),y(),width(),height());
		QRect e(0,0, p->width(), p->height());
		if(bAnimate)drawResizeAnimation(m_restoredRect, e);
		setGeometry (0, 0, p->width(), p->height());
		emit windowMaximized(this);
		m_lpSystemPopup->changeItem(i18n("Restore"),0);
	}
}
void KviMdiChild::minimizeWindow(bool bAnimate)
{
	if (m_bMinimized){
		m_bMinimized = false;
		QRect e(x()+(width()/2),y()+(height()/2),0,0);
		QRect r(x(),y(),width(),height());
		if(bAnimate)drawResizeAnimation(e,r);
		raise();
		show();
		setFocus();
	}else{
		m_bMinimized = true;
		lower();
		hide();
		QRect e(x()+(width()/2),y()+(height()/2),0,0);
		QRect r(x(),y(),width(),height());
		if(bAnimate)drawResizeAnimation(r, e);
		emit windowMinimized(this);
	}
}
void KviMdiChild::highlightWindow()
{
	m_lpMdi->highlightWindow(m_iId);
}
//============ applyOptionsInternal ============//
void KviMdiChild::applyOptionsInternal()
{
	_debug_entertrace("applyOptionsInternal");
	m_lpSysLabel->setFont(m_lpInt->fnt_caption);
	raiseLabel(m_bLabelRaised);
	_debug_leavetrace("applyOptionsInternal");
}
void KviMdiChild::doOutput(int nType,const char *szText)
{
	debug("pure virtual doOutput called (%d:%s)!",nType,szText);
	ASSERT(false);
}
void KviMdiChild::doFmtOutput(int nType,const char *szFmt,...)
{
	debug("pure virtual doFmtOuptut called (%d:%s)!",nType,szFmt);
	ASSERT(false);
}
void KviMdiChild::applyOptions()
{
	debug("pure virtual applyOptions called");
	ASSERT(false);
}
void KviMdiChild::sendData(const char *szData)
{
	debug("pure virtual sendData (%s) called",szData);
	ASSERT(false);
}
#include "m_kvi_child.moc"

//
// $Log: kvi_child.cpp,v $
// Revision 1.6  1998/09/23 12:41:33  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.5  1998/09/20 20:22:15  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.4  1998/09/18 03:57:06  pragma
// Not so much changes...only a couple of bug fixes.
//
// Revision 1.3  1998/09/16 17:16:03  fritz
// Starting i18n.
//
// Revision 1.2  1998/09/16 16:13:09  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
