//
//   File : kvi_chan.cpp (/usr/cvs/kvirc/kvirc/kvi_chan.cpp)
//   Last modified : Mon Dec 7 1998 04:51:42 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#define _KVI_DEBUG_CLASS_NAME_ "KviChanWnd"
#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_defs.h"
#include "kvi_chan.h"
#include "kvi_translate.h"
#include "kvi_debug.h"
#include "kvi_listbox.h"
#include "kvi_frame.h"
#include "kvi_input.h"
#include "kvi_view.h"
#include "kvi_opt.h"
#include "kvi_socket.h"
#include "kvi_bandlg.h"
#include "kvi_int.h"
#include "kvi_mdi.h"
#include "kvi_uparser.h"
#include "kvi_event.h"
#include "kvi_status.h"
#include "kvi_support.h"
//#include "kvi_uglobal.h"

#include <kapp.h>

#include <qpainter.h>
#include <qdrawutil.h>
#include <qtooltip.h>

#include <stdarg.h>

//*********************************************************************************************//
//
// INTERNAL CLASSES
//

KviPushButton::KviPushButton(const char *text,QWidget *parent):QPushButton(text,parent){}

KviPushButton::~KviPushButton(){};

void KviPushButton::drawButton(QPainter *paint)
{
	register QPainter *p = paint;
    GUIStyle gs   = style();
    QColorGroup g = colorGroup();
    int x1, y1, x2, y2;
    rect().coords( &x1, &y1, &x2, &y2 );	// get coordinates
    int w = x2 + 1;
    int h = y2 + 1;
    p->setPen( g.foreground() );
    p->setBrush( QBrush(g.background(),NoBrush) );
    if ( gs == WindowsStyle ) {		// Windows push button
		bool clearBackground = TRUE;
		if ( isDown() ) {
			qDrawWinButton( p, x1, y1, w, h, g, TRUE );
		} else {
		    if (isOn() && isEnabled() ) {
				QBrush fill(white, Dense4Pattern );
				qDrawWinButton( p, x1, y1, x2-x1+1, y2-y1+1, g, TRUE, &fill );
				clearBackground = FALSE;
		    } else {
				qDrawWinButton( p, x1, y1, x2-x1+1, y2-y1+1, g, isOn() );
		    }
		}
		if (clearBackground)p->fillRect( x1+2, y1+2, x2-x1-3, y2-y1-3, g.background() );
    } else if ( gs == MotifStyle ) {		// Motif push button
		QBrush fill;
		if ( isDown() )fill = QBrush( g.mid() );
		else if ( isOn() )fill = QBrush( g.mid(), Dense4Pattern );
		else fill = QBrush( g.background() );
		qDrawShadePanel( p, x1, y1, x2-x1+1, y2-y1+1, g, isOn() || isDown(),2, &fill );
    }
    if ( p->brush().style() != NoBrush )p->setBrush( NoBrush );
	QRect r = rect();
    r.rect( &x1, &y1, &w, &h );
    if ((isDown() || isOn()) && style() == WindowsStyle ) {
       x1++;y1++;
    }
    x1 += 1;  y1 += 1;  w -= 4;  h -= 4;
    qDrawItem( p, style(), x1, y1, w, h,AlignCenter|ShowPrefix,colorGroup(), isEnabled(),0, text() );
}

KviTopicLabel::KviTopicLabel(const char *text,QWidget *parent):QLabel(text,parent){}

KviTopicLabel::~KviTopicLabel(){}

void KviTopicLabel::mouseDoubleClickEvent(QMouseEvent *){emit doubleClicked();}

KviModeLabel::KviModeLabel(QWidget *parent):QFrame(parent)
{
	m_lpI=new KviPushButton("I",this);
	m_lpT=new KviPushButton("T",this);
	m_lpP=new KviPushButton("P",this);
	m_lpN=new KviPushButton("N",this);
	m_lpM=new KviPushButton("M",this);
	m_lpS=new KviPushButton("S",this);

	QToolTip::add(m_lpI,i18n("Invite only"));
	QToolTip::add(m_lpT,i18n("Topic restricted"));
	QToolTip::add(m_lpP,i18n("Private"));
	QToolTip::add(m_lpN,i18n("No external messages"));
	QToolTip::add(m_lpM,i18n("Moderated"));
	QToolTip::add(m_lpS,i18n("Secret"));

	m_lpI->setToggleButton(true);
	m_lpT->setToggleButton(true);
	m_lpP->setToggleButton(true);
	m_lpN->setToggleButton(true);
	m_lpM->setToggleButton(true);
	m_lpS->setToggleButton(true);

	connect(m_lpI,SIGNAL(clicked()),this,SLOT(modeIPressed()));
	connect(m_lpT,SIGNAL(clicked()),this,SLOT(modeTPressed()));
	connect(m_lpN,SIGNAL(clicked()),this,SLOT(modeNPressed()));
	connect(m_lpM,SIGNAL(clicked()),this,SLOT(modeMPressed()));
	connect(m_lpS,SIGNAL(clicked()),this,SLOT(modeSPressed()));
	connect(m_lpP,SIGNAL(clicked()),this,SLOT(modePPressed()));
	m_lpLabel=new QLabel("",this);
	QToolTip::add(m_lpLabel,i18n("Other modes"));
	setFontPropagation(QWidget::AllChildren);
}
KviModeLabel::~KviModeLabel()
{
	delete m_lpI;
	delete m_lpT;
	delete m_lpP;
	delete m_lpN;
	delete m_lpM;
	delete m_lpS;
	delete m_lpLabel;
}
void KviModeLabel::resizeEvent(QResizeEvent *)
{
	QRect rct=contentsRect();
	int hgh=rct.height();
	m_lpT->setGeometry(rct.left(),rct.top(),hgh,hgh);
	m_lpN->setGeometry(rct.left()+hgh,rct.top(),hgh,hgh);
	m_lpI->setGeometry(rct.left()+(hgh*2),rct.top(),hgh,hgh);
	m_lpM->setGeometry(rct.left()+(hgh*3),rct.top(),hgh,hgh);
	m_lpS->setGeometry(rct.left()+(hgh*4),rct.top(),hgh,hgh);
	m_lpP->setGeometry(rct.left()+(hgh*5),rct.top(),hgh,hgh);
	int wdth=rct.width();
	if(wdth<=(hgh*6))wdth=1;
	else wdth-=(hgh*6);
	m_lpLabel->setGeometry(rct.left()+(hgh*6),rct.top(),wdth,hgh);
}
void KviModeLabel::getMode(QString &szMode)
{
	szMode="";
	if(m_lpLabel->text())szMode=m_lpLabel->text();
	if(m_lpT->isOn())szMode+='t';
	if(m_lpN->isOn())szMode+='n';
	if(m_lpI->isOn())szMode+='i';
	if(m_lpM->isOn())szMode+='m';
	if(m_lpS->isOn())szMode+='s';
	if(m_lpP->isOn())szMode+='p';
}
void KviModeLabel::modeTPressed()
{
	if(m_lpT->isOn())emit modeChanged("+t");
	else emit modeChanged("-t");
}
void KviModeLabel::modeIPressed()
{
	if(m_lpI->isOn())emit modeChanged("+i");
	else emit modeChanged("-i");
}
void KviModeLabel::modePPressed()
{
	if(m_lpP->isOn())emit modeChanged("+p");
	else emit modeChanged("-p");
}
void KviModeLabel::modeSPressed()
{
	if(m_lpS->isOn())emit modeChanged("+s");
	else emit modeChanged("-s");
}
void KviModeLabel::modeNPressed()
{
	if(m_lpN->isOn())emit modeChanged("+n");
	else emit modeChanged("-n");
}
void KviModeLabel::modeMPressed()
{
	if(m_lpM->isOn())emit modeChanged("+m");
	else emit modeChanged("-m");
}
void KviModeLabel::setBackgroundPixmap(const QPixmap &pixmap)
{
	m_lpLabel->setBackgroundPixmap(pixmap);
}
void KviModeLabel::setBackgroundColor(const QColor &color)
{
	m_lpLabel->setBackgroundColor(color);
}
void KviModeLabel::setPalette(const QPalette &palette)
{
	m_lpLabel->setPalette(palette);
}
void KviModeLabel::setEnabled(bool bEnabled)
{
	m_lpT->setEnabled(bEnabled);
	m_lpN->setEnabled(bEnabled);
	m_lpI->setEnabled(bEnabled);
	m_lpM->setEnabled(bEnabled);
	m_lpS->setEnabled(bEnabled);
	m_lpP->setEnabled(bEnabled);
}
void KviModeLabel::setMode(char mode,bool bAdd)
{
	
	switch(mode){
		case 't':
		case 'T':
			m_lpT->setOn(bAdd);
			break;
		case 'n':
		case 'N':
			m_lpN->setOn(bAdd);
			break;
		case 'i':
		case 'I':
			m_lpI->setOn(bAdd);
			break;
		case 'm':
		case 'M':
			m_lpM->setOn(bAdd);
			break;
		case 's':
		case 'S':
			m_lpS->setOn(bAdd);
			break;
		case 'p':
		case 'P':
			m_lpP->setOn(bAdd);
			break;
		default:
			{
				QString szCurMode=m_lpLabel->text();
				if(bAdd){
					if(szCurMode.isEmpty()){
						szCurMode="";
						szCurMode+=mode;
					} else {
						if(szCurMode.find(mode)==-1){
							szCurMode+=mode;
						}
					}
				} else {
					int idx=szCurMode.find(mode);
					if(idx != -1){
						szCurMode.remove(idx,1);
						if(szCurMode.isEmpty())szCurMode="";
					}
				}
				m_lpLabel->setText(szCurMode.data());
			}
			break;
	}

}

KviTopicLineEdit::KviTopicLineEdit(QWidget *parent):QLineEdit(parent){}
KviTopicLineEdit::~KviTopicLineEdit(){}
void KviTopicLineEdit::focusOutEvent(QFocusEvent *e){ QLineEdit::focusOutEvent(e);emit lostFocus();}







//****************************************************************************************************//
//****************************************************************************************************//
//****************************************************************************************************//
//****************************************************************************************************//
//****************************************************************************************************//
//****************************************************************************************************//
//****************************************************************************************************//
//****************************************************************************************************//









//========== KviChanWnd ==========//

KviChanWnd::KviChanWnd(KviMdiManager *parent,KviFrame *frame,const char *aname,int aid)
           :KviMdiChild(parent,frame,aname,aid,KVI_WND_TYPE_CHAN)
{
	_debug_entertrace("KviChanWnd");
	m_lpPanner         = new KNewPanner(this,"KviPanner",KNewPanner::Vertical,KNewPanner::Percent,m_lpFrm->m_iLastChanPannerPosition);
	m_lpInput          = new KviInput(this,aid,KVI_WND_TYPE_CHAN,aname,frame,"KviInputClass");
	m_lpOutput         = new KviView(m_lpPanner,frame,"KviViewClass");
	m_lpListBox        = new KviListBox(m_lpPanner,this,frame,"KviListBoxClass");

	m_lpPanner->activate(m_lpOutput,m_lpListBox);

	m_lpLabelPanner    = new KNewPanner(this,"KviLabelPanner",KNewPanner::Vertical,KNewPanner::Percent,70);
	m_lpTopicLabel     = new KviTopicLabel(i18n("[ No topic is set ]"),m_lpLabelPanner);
	connect(m_lpTopicLabel,SIGNAL(doubleClicked()),this,SLOT(allowTopicChange()));
	m_lpTopicLabel->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	m_lpInfoPanner     = new KNewPanner(m_lpLabelPanner,"KviInfoPanner",KNewPanner::Vertical,KNewPanner::Percent,50);
	m_lpModeLabel      = new KviModeLabel(m_lpInfoPanner);
	connect(m_lpModeLabel,SIGNAL(modeChanged(const char *)),this,SLOT(userChangedMode(const char *)));
	m_lpModeLabel->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	m_lpUserLabel      = new QLabel("0 [ o:0 v:0 n:0 b:0 ]",m_lpInfoPanner);
	m_lpUserLabel->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	m_lpInfoPanner->activate(m_lpModeLabel,m_lpUserLabel);
	m_lpLabelPanner->activate(m_lpTopicLabel,m_lpInfoPanner);
	m_lpUserHostTimer=0;
	m_bIsMeOp          = false;
	m_lpOutput->m_lpChanParent=this;

	m_szLastOper=KVI_IMPOSSIBLE_NICKNAME;
	m_szLastDeoper=KVI_IMPOSSIBLE_NICKNAME;
	m_szLastBanner=KVI_IMPOSSIBLE_NICKNAME;
	m_szLastKicker=KVI_IMPOSSIBLE_NICKNAME;
	m_szLastFlooder=KVI_IMPOSSIBLE_NICKNAME;

	m_timeLastOp=new QList<QTime>;
	m_timeLastOp->setAutoDelete(true);
	m_timeLastDeop=new QList<QTime>;
	m_timeLastDeop->setAutoDelete(true);
	m_timeLastBan=new QList<QTime>;
	m_timeLastBan->setAutoDelete(true);
	m_timeLastKick=new QList<QTime>;
	m_timeLastKick->setAutoDelete(true);
	m_timeLastFlood=new QList<QTime>;
	m_timeLastFlood->setAutoDelete(true);

	m_uMassOpCnt=0;
	m_uMassDeopCnt=0;
	m_uMassKickCnt=0;
	m_uMassBanCnt=0;
	m_uPublicFloodCnt=0;

	QToolTip::add(m_lpTopicLabel,i18n("Channel topic : double click to edit"));

	setFocusOwner(m_lpInput);

	//Create it AFTER SetFocusOwner;
	m_lpTopicInput=new KviTopicLineEdit(m_lpLabelPanner);
	m_lpTopicInput->setMaxLength(80); //at least on ircnet is 80!
	m_lpTopicInput->hide();
	connect(m_lpTopicInput,SIGNAL(returnPressed()),this,SLOT(topicEditComplete()));

	m_iB=0;
	m_bAutoUpdateUsers = true;
	m_bHasAllNames     = false;
	m_bHasBanList      = false;
	m_bSentBanList     = false;

	m_lpBanList        = new QList<KviBanEntry>;
	m_lpBanList->setAutoDelete(true);
	m_lpTempList       = new QList<KviListBoxEntry>;
	m_lpTempList->setAutoDelete(false);
	m_lpCloneTimer     = new QTimer;

	connect(m_lpCloneTimer,SIGNAL(timeout()),this,SLOT(clonescanDoIt()));
	connect(this,SIGNAL(closeButtonPressed()),this,SLOT(slotClose()));

	applyOptions();
	_debug_leavetrace("KviChanWnd");
}

//========== ~KviChanWnd ==========//

KviChanWnd::~KviChanWnd()
{
	_debug_entertrace("~KviChanWnd");
	m_lpFrm->m_iLastChanPannerPosition=m_lpPanner->separatorPos();
	if(m_lpUserHostTimer){
		if(m_lpUserHostTimer->isActive())m_lpUserHostTimer->stop();
		delete m_lpUserHostTimer;
		m_lpUserHostTimer=0;
	}
	if(m_lpCloneTimer->isActive())m_lpCloneTimer->stop();
	delete m_lpCloneTimer;
	while(!m_lpTempList->isEmpty())m_lpTempList->removeLast();
	delete m_lpTempList;
	while(!m_lpBanList->isEmpty())m_lpBanList->removeLast();

	while(!m_timeLastOp->isEmpty())m_timeLastOp->removeFirst();
	delete m_timeLastOp;
	while(!m_timeLastDeop->isEmpty())m_timeLastDeop->removeFirst();
	delete m_timeLastDeop;
	while(!m_timeLastBan->isEmpty())m_timeLastBan->removeFirst();
	delete m_timeLastBan;
	while(!m_timeLastKick->isEmpty())m_timeLastKick->removeFirst();
	delete m_timeLastKick;
	while(!m_timeLastFlood->isEmpty())m_timeLastFlood->removeFirst();
	delete m_timeLastFlood;

	delete m_lpBanList;
	delete m_lpInput;
	delete m_lpOutput;
	delete m_lpListBox;
	delete m_lpPanner;
	delete m_lpUserLabel;
	delete m_lpModeLabel;
	delete m_lpInfoPanner;
	delete m_lpTopicLabel;
	delete m_lpTopicInput;
	delete m_lpLabelPanner;
	_debug_leavetrace("~KviChanWnd");
}

//////////////// CHECKS ///////////////////

//============ checkMassOp ============//
bool KviChanWnd::checkMassOp(QString &szNick)
{
	_debug_entertrace("checkMassOp");
	//Check if the last oper is szNick
	if(!strcasecmp(szNick.data(),m_szLastOper.data())){
		//Yes....
		m_uMassOpCnt++;
		//Check if we reached the max count
		if(m_uMassOpCnt>=m_lpFrm->m_lpOpt->massOpDeadline){
			//Yep! He mass Deoped ?
			//Check the time of the first deop he did...
			QTime *t=m_timeLastOp->first();
			if(!t)return false; //0 deadline ? (should be impossible), or what?....
			if(((uint)t->msecsTo(QTime::currentTime()))<=m_lpFrm->m_lpOpt->massOpTime){
				m_uMassOpCnt=0; //fire it!
				m_szLastOper=KVI_IMPOSSIBLE_NICKNAME; //next time empty the list
				return true;
			} else {
				//did it in greater time..
				//recheck again next time (remove the first entry)
				m_timeLastOp->removeFirst();
				m_uMassOpCnt--;
			}
		}
		m_timeLastOp->append(new QTime(QTime::currentTime()));
	} else {
		//Last oper is not szNick , store him
		m_szLastOper=szNick.copy();
		//remove the previous records
		while(!m_timeLastOp->isEmpty())m_timeLastOp->removeLast();
		//place the current time as the first entry
		m_timeLastOp->append(new QTime(QTime::currentTime()));
		m_uMassOpCnt=1;
	}
	_debug_leavetrace("checkMassOp");
	return false;
}
//============ checkMassDeop ============//
bool KviChanWnd::checkMassDeop(QString &szNick)
{
	_debug_entertrace("checkMassDeop");
	if(!strcasecmp(szNick.data(),m_szLastDeoper.data())){
		m_uMassDeopCnt++;
		if(m_uMassDeopCnt>=m_lpFrm->m_lpOpt->massDeopDeadline){
			QTime *t=m_timeLastDeop->first();
			if(!t)return false; //0 deadline ? (should be impossible), or what?....
			if(((uint)t->msecsTo(QTime::currentTime()))<=m_lpFrm->m_lpOpt->massDeopTime){
				m_uMassDeopCnt=0; //fire it!
				m_szLastDeoper=KVI_IMPOSSIBLE_NICKNAME; //next time empty the list
				return true;
			} else {
				m_timeLastDeop->removeFirst();
				m_uMassDeopCnt--;
			}
		}
		m_timeLastDeop->append(new QTime(QTime::currentTime()));
	} else {
		m_szLastDeoper=szNick.copy();
		while(!m_timeLastDeop->isEmpty())m_timeLastDeop->removeLast();
		m_timeLastDeop->append(new QTime(QTime::currentTime()));
		m_uMassDeopCnt=1;
	}
	_debug_leavetrace("checkMassDeop");
	return false;
}
/*
//============ checkMassDeop ============//
bool KviChanWnd::checkMassDeop(QString &szNick)
{
	_debug_entertrace("checkMassDeop");
	if(!strcasecmp(szNick.data(),m_szLastDeoper.data())){
		m_uMassDeopCnt++;
		if(m_uMassDeopCnt>=m_lpFrm->m_lpOpt->massDeopDeadline){
			QTime t=QTime::currentTime();
			if(((uint)m_timeLastDeop.secsTo(t))<=m_lpFrm->m_lpOpt->massDeopTime){
				m_uMassDeopCnt=0; //fire it!
				m_szLastDeoper="";
				m_timeLastDeop=QTime(0,0,0,0);
				return true;
			} else {
				m_timeLastDeop=m_timeLastDeop.addSecs(m_lpFrm->m_lpOpt->massDeopTime);
				//did it in greater time..
				//recheck again next time
				if(m_timeLastDeop > t)m_timeLastDeop=t;
			}
		}
	} else {
		m_szLastDeoper=szNick.copy();
		m_timeLastDeop=QTime::currentTime();
		m_uMassDeopCnt=1;
	}
	_debug_leavetrace("checkMassDeop");
	return false;
}*/
//============ checkMassKick ============//
bool KviChanWnd::checkMassKick(QString &szNick)
{
	_debug_entertrace("checkMassKick");
	if(!strcasecmp(szNick.data(),m_szLastKicker.data())){
		m_uMassKickCnt++;
		if(m_uMassKickCnt>=m_lpFrm->m_lpOpt->massKickDeadline){
			QTime *t=m_timeLastKick->first();
			if(!t)return false; //0 deadline ? (should be impossible), or what?....
			if(((uint)t->msecsTo(QTime::currentTime()))<=m_lpFrm->m_lpOpt->massKickTime){
				m_uMassKickCnt=0; //fire it!
				m_szLastKicker=KVI_IMPOSSIBLE_NICKNAME; //next time empty the list
				return true;
			} else {
				m_timeLastKick->removeFirst();
				m_uMassKickCnt--;
			}
		}
		m_timeLastKick->append(new QTime(QTime::currentTime()));
	} else {
		m_szLastKicker=szNick.copy();
		while(!m_timeLastKick->isEmpty())m_timeLastKick->removeLast();
		m_timeLastKick->append(new QTime(QTime::currentTime()));
		m_uMassKickCnt=1;
	}
	_debug_leavetrace("checkMassKick");
	return false;
}
/*
//============ checkMassKick ============//
bool KviChanWnd::checkMassKick(QString &szNick)
{
	_debug_entertrace("checkMassKick");
	if(!strcasecmp(szNick.data(),m_szLastKicker.data())){
		m_uMassKickCnt++;
		if(m_uMassKickCnt>=m_lpFrm->m_lpOpt->massKickDeadline){
			QTime t=QTime::currentTime();
			if(((uint)m_timeLastKick.secsTo(t))<=m_lpFrm->m_lpOpt->massKickTime){
				m_uMassKickCnt=0; //fire it!
				m_szLastKicker="";
				m_timeLastKick=QTime(0,0,0,0);
				return true;
			} else {
				m_timeLastKick=m_timeLastKick.addSecs(m_lpFrm->m_lpOpt->massKickTime);
				//did it in greater time..
				//recheck again next time
				if(m_timeLastKick > t)m_timeLastKick=t;
			}
		}
	} else {
		m_szLastKicker=szNick.copy();
		m_timeLastKick=QTime::currentTime();
		m_uMassKickCnt=1;
	}
	_debug_leavetrace("checkMassKick");
	return false;
}
*/
//============ checkMassBan ============//
bool KviChanWnd::checkMassBan(QString &szNick)
{
	_debug_entertrace("checkMassBan");
	if(!strcasecmp(szNick.data(),m_szLastBanner.data())){
		m_uMassBanCnt++;
		if(m_uMassBanCnt>=m_lpFrm->m_lpOpt->massBanDeadline){
			QTime *t=m_timeLastBan->first();
			if(!t)return false; //0 deadline ? (should be impossible), or what?....
			if(((uint)t->msecsTo(QTime::currentTime()))<=m_lpFrm->m_lpOpt->massBanTime){
				m_uMassBanCnt=0; //fire it!
				m_szLastBanner=KVI_IMPOSSIBLE_NICKNAME; //next time empty the list
				return true;
			} else {
				m_timeLastBan->removeFirst();
				m_uMassBanCnt--;
			}
		}
		m_timeLastBan->append(new QTime(QTime::currentTime()));
	} else {
		m_szLastBanner=szNick.copy();
		while(!m_timeLastBan->isEmpty())m_timeLastBan->removeLast();
		m_timeLastBan->append(new QTime(QTime::currentTime()));
		m_uMassBanCnt=1;
	}
	_debug_leavetrace("checkMassBan");
	return false;
}
/*
//============ checkMassBan ============//
bool KviChanWnd::checkMassBan(QString &szNick)
{
	_debug_entertrace("checkMassBan");
	if(!strcasecmp(szNick.data(),m_szLastBanner.data())){
		m_uMassBanCnt++;
		if(m_uMassBanCnt>=m_lpFrm->m_lpOpt->massBanDeadline){
			QTime t=QTime::currentTime();
			if(((uint)m_timeLastBan.secsTo(t))<=m_lpFrm->m_lpOpt->massBanTime){
				m_uMassBanCnt=0; //fire it!
				m_szLastBanner="";
				m_timeLastBan=QTime(0,0,0,0);
				return true;
			} else {
				m_timeLastBan=m_timeLastBan.addSecs(m_lpFrm->m_lpOpt->massBanTime);
				//did it in greater time..
				//recheck again next time
				if(m_timeLastBan > t)m_timeLastBan=t;
			}
		}
	} else {
		m_szLastBanner=szNick.copy();
		m_timeLastBan=QTime::currentTime();
		m_uMassBanCnt=1;
	}
	_debug_leavetrace("checkMassBan");
	return false;
}
*/
//============ checkPublicFlood ============//
bool KviChanWnd::checkPublicFlood(QString &szNick)
{
	_debug_entertrace("checkPublicFlood");
	if(!strcasecmp(szNick.data(),m_szLastFlooder.data())){
		m_uPublicFloodCnt++;
		if(m_uPublicFloodCnt>=m_lpFrm->m_lpOpt->publicFloodDeadline){
			QTime *t=m_timeLastFlood->first();
			if(!t)return false; //0 deadline ? (should be impossible), or what?....
			if(((uint)t->msecsTo(QTime::currentTime()))<=m_lpFrm->m_lpOpt->publicFloodTime){
				m_uPublicFloodCnt=0; //fire it!
				m_szLastFlooder=KVI_IMPOSSIBLE_NICKNAME; //next time empty the list
				return true;
			} else {
				m_timeLastFlood->removeFirst();
				m_uPublicFloodCnt--;
			}
		}
		m_timeLastFlood->append(new QTime(QTime::currentTime()));
	} else {
		m_szLastFlooder=szNick.copy();
		while(!m_timeLastFlood->isEmpty())m_timeLastFlood->removeLast();
		m_timeLastFlood->append(new QTime(QTime::currentTime()));
		m_uPublicFloodCnt=1;
	}
	_debug_leavetrace("checkMassFlood");
	return false;
}
/*
//============ checkPublicFlood ============//
bool KviChanWnd::checkPublicFlood(QString &szNick)
{
	_debug_entertrace("checkPublicFlood");
	if(!strcasecmp(szNick.data(),m_szLastFlooder.data())){
		m_uPublicFloodCnt++;
		if(m_uPublicFloodCnt>=m_lpFrm->m_lpOpt->publicFloodDeadline){
			QTime t=QTime::currentTime();
			if(((uint)m_timeLastFlood.secsTo(t))<=m_lpFrm->m_lpOpt->publicFloodTime){
				m_uPublicFloodCnt=0; //fire it!
				m_szLastFlooder="";
				m_timeLastFlood=QTime(0,0,0,0);
				return true;
			} else {
				m_timeLastFlood=m_timeLastFlood.addSecs(m_lpFrm->m_lpOpt->publicFloodTime);
				//did it in greater time..
				//recheck again next time
				if(m_timeLastFlood > t)m_timeLastFlood=t;
			}
		}
	} else {
		m_szLastFlooder=szNick.copy();
		m_timeLastFlood=QTime::currentTime();
		m_uPublicFloodCnt=1;
	}
	_debug_leavetrace("checkPublicFlood");
	return false;
}*/
//============== userChangedMode ==========//
void KviChanWnd::userChangedMode(const char *mode)
{
	_debug_entertrace("userChangedMode");
	m_lpFrm->m_lpSock->sendFmtData("MODE %s %s",name(),mode);
	_debug_leavetrace("userChangedMode");
}
//============ doBanDialog ============//
void KviChanWnd::doBanDialog()
{
	_debug_entertrace("doBanDialog");
	KviBanDialog theDlg(this,m_lpFrm);
	theDlg.exec();
	_debug_leavetrace("doBanDialog");
}
//============== setMode ===============//
void KviChanWnd::setMode(char szMode,bool bAdd)
{
	_debug_entertrace("setMode");
	m_lpModeLabel->setMode(szMode,bAdd);
	setLabelsPalette();
	_debug_leavetrace("setMode");
}
//============= setTopic ==============//
void KviChanWnd::setTopic(const char *szTopic)
{
	_debug_entertrace("setTopic");
	QString szT(szTopic);
	if(m_lpFrm->m_lpOpt->bUseTranslation)m_lpFrm->m_lpTranslator->translateToClient(szT);
	m_lpTopicLabel->setText(szT.data());
	m_lpTopicLabel->update();
	_debug_leavetrace("setTopic");
}
//============= getTopic =============//
void KviChanWnd::getTopic(QString &szTopic)
{
	_debug_entertrace("getTopic");
	const char * szT=m_lpTopicLabel->text();
	szTopic= (szT ? szT : "");
	if(m_lpFrm->m_lpOpt->bUseTranslation)m_lpFrm->m_lpTranslator->translateToServer(szTopic);
	_debug_leavetrace("getTopic");
}
void KviChanWnd::updateUsersLabel()
{
	if(!m_bAutoUpdateUsers)return;
	QString szU;
	uint uinorm=m_lpListBox->m_iTotal-(m_lpListBox->m_iOp+m_lpListBox->m_iVoice);
	szU.sprintf("%d [ o:%d v:%d n:%d b:%d ]",m_lpListBox->m_iTotal,m_lpListBox->m_iOp,m_lpListBox->m_iVoice,uinorm,m_iB);
	m_lpUserLabel->setText(szU.data());
	m_lpUserLabel->update();
}

//============ getNickEntry ============//

KviListBoxEntry * KviChanWnd::getNickEntry(const char *szNick)
{
	_debug_entertrace("getNickEntry");
	return m_lpListBox->findEntry(szNick);
	_debug_leavetrace("getNickEntry");
}
//============ nickJoin ============//
void KviChanWnd::nickJoin(KviNewNick &kN,bool bOp,bool bVoice)
{
	_debug_entertrace("nickJoin");
	m_lpListBox->nickJoin(kN,bOp,bVoice);
	updateUsersLabel();
	_debug_leavetrace("nickJoin");
}
void KviChanWnd::nickJoin(QString &szN)
{
	_debug_entertrace("nickJoin");
	KviNewNick kN(szN);
	_range_valid(szN.data());
	if(*szN.data()=='@')m_lpListBox->nickJoin(kN,true,false);
	else {
		if(*szN.data()=='+')m_lpListBox->nickJoin(kN,false,true);
		else m_lpListBox->nickJoin(kN,false,false);
	}
	updateUsersLabel();
	_debug_leavetrace("nickJoin");
}
void KviChanWnd::nickJoin(const char *szN){ QString szNk(szN);nickJoin(szNk); }
//============ nickPart ============//
void KviChanWnd::nickPart(const char *szN)
{
	_debug_entertrace("nickPart");
	KviListBoxEntry *lpE=getNickEntry(szN);
	_range_valid(lpE);
	if(lpE){
		_range_valid(lpE->lpNick);
		if(m_lpCloneTimer->isActive())m_lpTempList->removeRef(lpE);
		m_lpListBox->nickPart(lpE->lpNick->szNick.data());
		updateUsersLabel();
	}
	_debug_leavetrace("nickPart");
}
void KviChanWnd::nickPart(QString &szN){ nickPart(szN.data()); }
void KviChanWnd::nickPart(KviNewNick &kN){ nickPart(kN.szNick.data()); }
//============ nickVoice ============//
void KviChanWnd::nickVoice(KviNewNick &kN,bool bVoice){nickVoice(kN.szNick.data(),bVoice);}
void KviChanWnd::nickVoice(QString &szN,bool bVoice){nickVoice(szN.data(),bVoice);}
void KviChanWnd::nickVoice(const char *szN,bool bVoice)
{
	_debug_entertrace("nickVoice");
	m_lpListBox->voiceNick(szN,bVoice);
	updateUsersLabel();
	_debug_leavetrace("nickVoice");
}
//============ nickOp ============//
void KviChanWnd::nickOp(KviNewNick &kN,bool bVoice){nickOp(kN.szNick.data(),bVoice);}
void KviChanWnd::nickOp(QString &szN,bool bVoice){nickOp(szN.data(),bVoice);}
void KviChanWnd::nickOp(const char *szN,bool bVoice)
{
	_debug_entertrace("nickOp");
	m_lpListBox->opNick(szN,bVoice);
	updateUsersLabel();
	_debug_leavetrace("nickOp");
}
//============ getNick ============//
KviNewNick * KviChanWnd::getNick(KviNewNick &kN){return getNick(kN.szNick.data());}
KviNewNick * KviChanWnd::getNick(QString &szN){return getNick(szN.data());}
KviNewNick * KviChanWnd::getNick(const char *szN)
{
	_debug_entertrace("getNick");
	KviListBoxEntry *lpE=getNickEntry(szN);
	_debug_leavetrace("getNick");
	if(lpE)return lpE->lpNick;
	else return 0;
}

//============ isModeSet ============//

bool KviChanWnd::isModeSet(char mode)
{
	_debug_entertrace("isModeSet");
	QString szMode;
	m_lpModeLabel->getMode(szMode);
	return (szMode.find(mode) != (-1));
	_debug_leavetrace("isModeSet");
}

//============ setLabelsPalette ============//

void KviChanWnd::setLabelsPalette()
{
	_debug_entertrace("setLabelsPalette");
	QPalette actPal=m_lpTopicLabel->palette();
	QColorGroup aCG(actPal.normal());
	QColorGroup actCG(aCG.foreground(),aCG.background(),aCG.light(),
			 		aCG.dark(), aCG.mid(),m_lpInt->clr_fr_act_chanlabels, aCG.base()); 
	QColorGroup inaCG(aCG.foreground(),aCG.background(),aCG.light(),
			 		aCG.dark(), aCG.mid(),m_lpInt->clr_fr_chanlabels, aCG.base()); 
	actPal.setNormal(actCG);
	QPalette inaPal;
	inaPal.setNormal(inaCG);

	if(m_bIsMeOp||(!isModeSet('t')))m_lpTopicLabel->setPalette(actPal);
	else m_lpTopicLabel->setPalette(inaPal);
	if(m_bIsMeOp){
		m_lpModeLabel->setPalette(actPal);
		m_lpModeLabel->setEnabled(true);
	} else {
		m_lpModeLabel->setPalette(inaPal);
		m_lpModeLabel->setEnabled(false);
	}
	m_lpUserLabel->setPalette(actPal);
	m_lpTopicLabel->update();
	m_lpUserLabel->update();
	m_lpModeLabel->update();
	_debug_leavetrace("setLabelsPalette");
}
//=========== applyOptions ===========//
void KviChanWnd::applyOptions()
{
	_debug_entertrace("applyOptions");
	m_lpInput->enableColorBox(m_lpFrm->m_lpOpt->bShowColorBox);
	m_lpInput->setDefaultBackgroundColor(m_lpInt->clr_bk_input);
	m_lpInput->setDefaultForegroundColor(m_lpInt->clr_fr_input);
	m_lpInput->setMarkBackgroundColor(m_lpInt->clr_bk_sel_input);
	m_lpInput->setMarkForegroundColor(m_lpInt->clr_fr_sel_input);
	m_lpInput->setCursorColor(m_lpInt->clr_cursor_input);
	m_lpInput->setFont(m_lpInt->fnt_input);
	if(!m_lpInt->pix_bk_input.isNull())m_lpInput->setBackgroundPixmap(m_lpInt->pix_bk_input);
	m_lpOutput->setFont(m_lpInt->fnt_output);
	m_lpListBox->setFont(m_lpInt->fnt_listbox);
	m_lpTopicLabel->setFont(m_lpInt->fnt_chanlabels);
	m_lpUserLabel->setFont(m_lpInt->fnt_chanlabels);
	m_lpModeLabel->setFont(m_lpInt->fnt_chanlabels);
	m_lpTopicInput->setFont(m_lpInt->fnt_chanlabels);
	m_lpOutput->m_bTimestamp=m_lpFrm->m_lpOpt->bTimestamp;
	m_lpOutput->m_bShowPixmaps=m_lpFrm->m_lpOpt->bShowPixmaps;
	if(!m_lpInt->pix_bk_chanlabels.isNull()){
		m_lpModeLabel->setBackgroundPixmap(m_lpInt->pix_bk_chanlabels);
		m_lpUserLabel->setBackgroundPixmap(m_lpInt->pix_bk_chanlabels);
		m_lpTopicLabel->setBackgroundPixmap(m_lpInt->pix_bk_chanlabels);
	} else {
		m_lpModeLabel->setBackgroundColor(m_lpInt->clr_bk_chanlabels);
		m_lpUserLabel->setBackgroundColor(m_lpInt->clr_bk_chanlabels);
		m_lpTopicLabel->setBackgroundColor(m_lpInt->clr_bk_chanlabels);
	}
	setLabelsPalette();
	const QSize sz=size();
	QResizeEvent e(sz,sz);
	resizeEvent(&e);
	_debug_leavetrace("applyOptions");
}
//============= resizeEvent =============//
void KviChanWnd::resizeEvent(QResizeEvent *)
{
	_debug_entertrace("resizeEvent");
	updateRects();
	QRect rct=viewSizeHint();
	QFontMetrics fnt=m_lpInput->fontMetrics();
	int input_hght=fnt.lineSpacing()+8;
	QFontMetrics fm=m_lpTopicLabel->fontMetrics();
	int labl_hght=fm.lineSpacing()+6;
	m_lpInput->setGeometry(rct.left(),rct.top()+rct.height()-input_hght,rct.width(),input_hght);
	m_lpLabelPanner->setGeometry(rct.left(),rct.top(),rct.width(),labl_hght);
	m_lpPanner->setGeometry(rct.left(),rct.top()+labl_hght+KVI_MDI_VIEW_SEP,
				rct.width(),rct.height()-(input_hght+labl_hght+(KVI_MDI_VIEW_SEP*2)));
	_debug_leavetrace("resizeEvent");
}
//============= doFmtOutput ==============//
void KviChanWnd::doFmtOutput(int nType,const char *szFmt,...)
{
	_debug_entertrace("doFmtOutput");
	char szText[600]; //It should be big enough... I hope...
	va_list list;
	va_start(list,szFmt);
	if(vsnprintf(szText,600,szFmt,list)==-1)debug("WARNING : Output string truncated."); // Fritz: Why not vsnprinf and dynamic realloc if too large?
	va_end(list);
	m_lpMdi->highlightWindow(m_iId);
	m_lpOutput->appendText(nType,(const char *) &szText);
	_debug_leavetrace("doFmtOutput");
}
//============== doOutput ===============//
void KviChanWnd::doOutput(int nType,const char *szText)
{
	_debug_entertrace("doOutput");
	m_lpMdi->highlightWindow(m_iId);
	m_lpOutput->appendText(nType,szText);
	_debug_leavetrace("doOutput");
}
//============ allowTopicChange ============//
void KviChanWnd::allowTopicChange()
{
	_debug_entertrace("allowTopicChange");
	if(m_lpTopicInput)abortTopicEdit();
	if(m_bIsMeOp || (!isModeSet('t'))){
		QRect rct=m_lpTopicLabel->rect();
		m_lpTopicInput->setEnabled(true);
		m_lpTopicInput->setGeometry(rct);
		m_lpTopicInput->show();
		m_lpTopicInput->raise();
		m_lpTopicInput->setText(m_lpTopicLabel->text());
		m_lpTopicInput->setFocus();
		connect(m_lpTopicInput,SIGNAL(lostFocus()),this,SLOT(abortTopicEdit()));
	}
	_debug_leavetrace("allowTopicChange");
}
//============ topicEditComplete ============//
void KviChanWnd::topicEditComplete()
{
	_debug_entertrace("topicEditComplete");
	QString szNewTopic=m_lpTopicInput->text();
	abortTopicEdit();
	QString szOldTopic=m_lpTopicLabel->text();
	if(szNewTopic !=  szOldTopic){
		if(m_lpFrm->m_lpOpt->bUseTranslation)m_lpFrm->m_lpTranslator->translateToServer(szNewTopic);	
		m_lpFrm->m_lpSock->sendFmtData("TOPIC %s :%s",name(),szNewTopic.data());
	}
	_debug_leavetrace("topicEditComplete");
}
//============ abortTopicEdit ============//
void KviChanWnd::abortTopicEdit()
{
	_debug_entertrace("abortTopicEdit");
	if(m_lpTopicInput){
		if(m_lpTopicInput->isEnabled()){
			disconnect(m_lpTopicInput,SIGNAL(lostFocus()),this,SLOT(abortTopicEdit()));	
			m_lpTopicInput->hide();
			m_lpTopicInput->setEnabled(false);
			m_lpMdi->focusTopChild();
		}
	}
	_debug_leavetrace("abortTopicEdit");
}
//============ slotClose ============//
void KviChanWnd::slotClose()
{
	_debug_entertrace("slotClose");
	abortTopicEdit();
	doOutput(KVI_OUT_INTERNAL,i18n("Part message sent to server, waiting for reply."));
	QString szPart="/PART ";
	szPart+=name();
	m_lpFrm->m_lpUserParser->parseUserInput(this,KVI_WND_TYPE_CHAN,name(),szPart);
	enableClose(false);
	_debug_leavetrace("slotClose");
}
//============ startUpdateUserList ============//
void KviChanWnd::startUpdateUserList()
{
	_debug_entertrace("startUpdateUserList");
	if((!m_lpUserHostTimer)){
		m_lpUserHostTimer=new QTimer();
		connect(m_lpUserHostTimer,SIGNAL(timeout()),this,SLOT(queryUserHost()));
		if(m_lpFrm->m_lpOpt->iUserListUpdateTime<2)m_lpFrm->m_lpOpt->iUserListUpdateTime=2;
		m_lpUserHostTimer->start(m_lpFrm->m_lpOpt->iUserListUpdateTime * 1000);
	}
	_debug_leavetrace("startUpdateUserList");
}
//============ queryUserHost ============//
void KviChanWnd::queryUserHost()
{
	_debug_entertrace("queryUserHost");
	if(!m_bSentBanList){
		KviNewNick *lpN;
		KviListBoxEntry *lpE;
		int nReq=0;
		int alen=strlen(KVI_STR_NULL);
		QString szReq="";
		for(lpE=m_lpListBox->m_lpNickList->first();lpE;lpE=m_lpListBox->m_lpNickList->next()){
			lpN=lpE->lpNick;
			if(!strncmp(lpN->szAddress.data(),KVI_STR_NULL,alen)){
				szReq+=' ';
				szReq+=lpN->szNick;
				nReq++;
				if(nReq==5){
					szReq.remove(0,1);
					m_lpFrm->queryUserHost(szReq);
					szReq="";
					nReq=0;
					_debug_leavetrace("queryUserHost");
					return;
				}
			}
		}
		if(nReq){
			szReq.remove(0,1);
			m_lpFrm->queryUserHost(szReq);
			szReq="";
			nReq=0;
			_debug_leavetrace("queryUserHost");
			return;
		}
		m_bSentBanList=true;
		if(!m_bHasBanList){
			m_lpFrm->m_lpSock->sendFmtData("MODE %s +b",name());
			_debug_leavetrace("queryUserHost");
			return;
		}
	}
	if(m_lpUserHostTimer){
		if(m_lpUserHostTimer->isActive())m_lpUserHostTimer->stop();
		delete m_lpUserHostTimer;
		m_lpUserHostTimer=0;
	}
	doOutput(KVI_OUT_INTERNAL,i18n("Internal users list query complete.(Waiting for the ban list)"));
	_debug_leavetrace("queryUserHost");
}
//============ doUserList ============//
void KviChanWnd::doUserList()
{
	_debug_entertrace("doUserList");
	KviNewNick *lpN;
	KviListBoxEntry *lpE;
	for(lpE=m_lpListBox->m_lpNickList->first();lpE;lpE=m_lpListBox->m_lpNickList->next()){
		lpN=lpE->lpNick;
		QString szWho="[ USER : ";
		szWho+=lpN->szNick;
		if(szWho.length()<19)szWho.setExpand(18,' ');
		szWho+=" ] is ";
		szWho+=lpN->szNick;
		szWho+='!';
		szWho+=lpN->szUserName;
		szWho+='@';
		szWho+=lpN->szAddress;
		doOutput(KVI_OUT_WHO,szWho.data());
	}
	_debug_leavetrace("doUserList");
}
//============ doSingleCloneScan ============//
bool KviChanWnd::doSingleCloneScan(KviNewNick *lpN)
{
	_debug_entertrace("doSingleCloneScan");
	if(!strcmp(lpN->szAddress.data(),KVI_STR_NULL)){
		doFmtOutput(KVI_OUT_ERROR,i18n("Can't execute clonescan on %s (the adress is still unknown)"),lpN->szNick.data());
		return false;
	}
	KviNewNick *lpX;
	QString szClone=lpN->szNick.copy();
	bool gotIt=false;
	KviListBoxEntry *lpE;
	for(lpE=m_lpListBox->m_lpNickList->first();lpE;lpE=m_lpListBox->m_lpNickList->next()){
		lpX=lpE->lpNick;
		if(!strcmp(lpX->szAddress.data(),lpN->szAddress.data())){
			if(strcasecmp(lpN->szNick.data(),lpX->szNick.data())){
				gotIt=true;
				szClone+=',';
				szClone+=lpX->szNick;
			}
		}
	}
	if(gotIt){
		doFmtOutput(KVI_OUT_CLONE,"Clone : %s [%s]",szClone.data(),lpN->szAddress.data());
		if(m_lpFrm->m_lpEventManager->lpEvent[KVI_Event_OnClone]->bEnabled){
			QString szPara=name();
			szPara+=" *!*@";
			szPara+=lpN->szAddress;
			szPara+=" ";
			szPara+=szClone;
			m_lpFrm->m_lpUserParser->executeEvent(m_lpFrm->m_lpConsole,
							m_lpFrm->m_lpEventManager->lpEvent[KVI_Event_OnClone],szPara);
		}
	}	
	return gotIt;
	_debug_leavetrace("doSingleCloneScan");
}
//============ doGlobalCloneScan ============//
void KviChanWnd::doGlobalCloneScan()
{
	_debug_entertrace("doGlobalCloneScan");
	if(m_lpCloneTimer->isActive()){
		doOutput(KVI_OUT_ERROR,i18n("Another clonescan in progress."));
		return;
	}
	while(!m_lpTempList->isEmpty())m_lpTempList->removeLast();
	KviListBoxEntry *lpN=0;
	for(lpN=m_lpListBox->m_lpNickList->first();lpN;lpN=m_lpListBox->m_lpNickList->next()){
		m_lpTempList->append(lpN);
	}
	doOutput(KVI_OUT_CLONE,i18n("Starting global clone scan."));
	m_lpCloneTimer->start(100); //do it every 100 ms...
	m_bInScan=false;
	_debug_leavetrace("doGlobalCloneScan");
}
//============ clonescanDoIt ============//
void KviChanWnd::clonescanDoIt()
{
	_debug_entertrace("clonescanDoIt");
	if(m_bInScan)return;
	if(m_lpTempList->isEmpty()){
		m_bInScan=false;
		m_lpCloneTimer->stop();
		doOutput(KVI_OUT_CLONE,i18n("Clonescan terminated."));
	} else {
		m_bInScan=true;
		KviListBoxEntry *lpE=m_lpTempList->first();
		KviNewNick *lpN=lpE->lpNick;
		m_lpTempList->removeFirst();
		if(strcmp(lpN->szAddress.data(),KVI_STR_NULL)){
			KviNewNick *lpX=0;
			QString szClone=lpN->szNick.copy();
			bool gotIt=false;
			for(lpE=m_lpTempList->first();lpE;lpE=m_lpTempList->next()){
				lpX=lpE->lpNick;
				if(!strcmp(lpX->szAddress.data(),lpN->szAddress.data())){
					if(strcasecmp(lpN->szNick.data(),lpX->szNick.data())){
						gotIt=true;
						szClone+=',';
						szClone+=lpX->szNick;
						m_lpTempList->removeRef(lpE);
						lpE=m_lpTempList->first();
						lpX=lpE->lpNick;
					}
				}
			}
			if(gotIt){
				doFmtOutput(KVI_OUT_CLONE,i18n("Clone : %s [%s]"),szClone.data(),lpN->szAddress.data());
				if(m_lpFrm->m_lpEventManager->lpEvent[KVI_Event_OnClone]->bEnabled){
					QString szPara=name();
					szPara+=" *!*@";
					szPara+=lpN->szAddress;
					szPara+=" ";
					szPara+=szClone;
					m_lpFrm->m_lpUserParser->executeEvent(m_lpFrm->m_lpConsole,
								m_lpFrm->m_lpEventManager->lpEvent[KVI_Event_OnClone],szPara);
				}
			}
		}
		m_bInScan=false;
	}
	_debug_leavetrace("clonescanDoIt");
}
//============ changeBanList ============//
void KviChanWnd::changeBanList(const char *szBanSetBy,const char *szBanMask,bool bAdd)
{
	_debug_entertrace("changeBanList");
	if(bAdd){
		KviBanEntry *lpB=new KviBanEntry;
		lpB->szBanMask=szBanMask;
		lpB->szBanSetBy=( szBanSetBy ? szBanSetBy : i18n("Unknown") );
		KviBanEntry *lpT=0;
		for(lpT=m_lpBanList->first();lpT;lpT=m_lpBanList->next()){
			if(!strcasecmp(lpT->szBanMask.data(),lpB->szBanMask.data())){
				//Already have that ban
				delete lpB;
				return;
			}
		}
		m_lpBanList->append(lpB);
		m_iB++;
		updateUsersLabel();
	} else {
		KviBanEntry *lpB=0;
		for(lpB=m_lpBanList->first();lpB;lpB=m_lpBanList->next()){
			if(!strcasecmp(lpB->szBanMask.data(),szBanMask)){
				m_lpBanList->removeRef(lpB);
				m_iB--;
				updateUsersLabel();
				return;
			}
		}
	}
	_debug_leavetrace("changeBanList");
}

#include "m_kvi_chan.moc"

//
// $Log: kvi_chan.cpp,v $
// Revision 1.5  1998/10/06 14:42:08  pragma
// Tons of changes
//
// Revision 1.4  1998/09/23 23:15:03  pragma
// Ignore list. Still needs testing.
// Added some ASSERT-Like macros to kvi_chan.cpp and kvi_listbox.cpp
// to discover a strange bug :
// Sometimes the a single nick on a random channel gets wrong username...
// Just like a hollow pointer...but still can't guess how to reproduce it.
// It happened only a couple of times...
//
//
