//   $Id: kvi_audio.cpp,v 1.5 1998/10/06 14:42:07 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_

#include "kvi_audio.h"
#include "kvi_debug.h"
#include "kvi_macros.h"
#include "kvi_app.h"
#include "kvi_opt.h"

#include <qfile.h>

//============ KviAudio ============//

KviAudio::KviAudio(KviOptions *lpOpt):KAudio()
{
	_debug_entertrace("KviAudio");
	m_lpOpt=lpOpt;
	//Check if the $HOME/Audio directory exists
	QString szHome(_macro_getKVircHomeDirectory("Audio"));
	QDir aDir(szHome.data());
	if(!aDir.exists())aDir.mkdir(szHome.data(),true);
	_debug_leavetrace("KviAudio");
}

//============ ~KviAudio ============//

KviAudio::~KviAudio()
{
	_debug_entertrace("~KviAudio");
	_debug_leavetrace("~KviAudio")
}

//============ playSound ============//

int KviAudio::playSound(const char *szFileName)
{
	_debug_entertrace("playSound");
	if(serverStatus() != 0)return KVI_AUDIO_NO_SOUND_SERVER;
	QString szAudioFile(szFileName);
	int idx=szAudioFile.find('/');
	if(idx==-1){
		QString szHome(_macro_getKVircHomeDirectory("Audio/"));
		szAudioFile.prepend(szHome.data());
	}
	QFile audioFile(szAudioFile);
	if(!audioFile.open(IO_ReadOnly)){
		QString szOtherFileName(szFileName);
		int idx=szOtherFileName.find('/');
		if(idx==-1){
			QString szHome(_macro_getKVircHomeDirectory("Scripts/Audio/"));
			szOtherFileName.prepend(szHome.data());
		}
		QFile audioFile2(szOtherFileName);
		if(!audioFile2.open(IO_ReadOnly))return KVI_AUDIO_FILE_NOT_FOUND;
		else audioFile2.close();
		if(play(szOtherFileName.data()))return KVI_AUDIO_SUCCESS;
		else return KVI_AUDIO_NO_SOUND_SERVER;
	} else audioFile.close();
	//rely on maudio first.
	if(szAudioFile.find(".wav") != -1){
		if(m_lpOpt->bExternalWavPlayer){
			QString szCmdLine=m_lpOpt->szWavPlayerCmd.copy();
			if(szCmdLine.isEmpty())return KVI_AUDIO_NO_SOUND_SERVER;
			_macro_boolSubstitutePercent(szCmdLine,szAudioFile);
			if(_macro_boolRunThroughShell(szCmdLine))return KVI_AUDIO_SUCCESS;
		} else {
			if(play(szAudioFile.data()))return KVI_AUDIO_SUCCESS;
		}
	} else {
		if(szAudioFile.find(".au") != -1){
			if(m_lpOpt->bExternalAuPlayer){
				QString szCmdLine=m_lpOpt->szAuPlayerCmd.copy();
				if(szCmdLine.isEmpty())return KVI_AUDIO_NO_SOUND_SERVER;
				_macro_boolSubstitutePercent(szCmdLine,szAudioFile);
				if(_macro_boolRunThroughShell(szCmdLine))return KVI_AUDIO_SUCCESS;
			}
		} else if(szAudioFile.find(".mp3") != -1){
			if(m_lpOpt->bExternalMp3Player){
				QString szCmdLine=m_lpOpt->szMp3PlayerCmd.copy();
				if(szCmdLine.isEmpty())return KVI_AUDIO_NO_SOUND_SERVER;
				_macro_boolSubstitutePercent(szCmdLine,szAudioFile);
				if(_macro_boolRunThroughShell(szCmdLine))return KVI_AUDIO_SUCCESS;
			}
		} else if(szAudioFile.find(".mid") != -1){
			if(m_lpOpt->bExternalMidPlayer){
				QString szCmdLine=m_lpOpt->szMidPlayerCmd.copy();
				if(szCmdLine.isEmpty())return KVI_AUDIO_NO_SOUND_SERVER;
				_macro_boolSubstitutePercent(szCmdLine,szAudioFile);
				if(_macro_boolRunThroughShell(szCmdLine))return KVI_AUDIO_SUCCESS;
			}
		}
	}
	_debug_leavetrace("playSound");
	return KVI_AUDIO_NO_SOUND_SERVER;
}

#include "m_kvi_audio.moc"

//
// $Log: kvi_audio.cpp,v $
// Revision 1.5  1998/10/06 14:42:07  pragma
// Tons of changes
//
// Revision 1.4  1998/09/20 20:22:03  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.3  1998/09/17 16:14:29  pragma
// Moving to handle mp3 , au and mid files by external players.
//
// Revision 1.2  1998/09/16 16:13:07  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
