//   $Id: kvi_ascii.cpp,v 1.3 1998/09/20 20:22:02 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_ascii.h"
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_macros.h"
#include "kvi_frame.h"
#include "kvi_mdi.h"
#include "kvi_global.h"
#include "kvi_socket.h"
#include "kvi_chat.h"
#include "kvi_nick.h"

//============ KviAsciiPlayer ============//

KviAsciiPlayer::KviAsciiPlayer(KviFrame *lpFrm)
{
	_debug_entertrace("KviAsciiPlayer");
	m_lpFrm=lpFrm;
	m_lpAsciiList=new QList<KviAsciiStruct>;
	m_lpAsciiList->setAutoDelete(true);
	_debug_leavetrace("KviAsciiPlayer");
}

//============ ~KviAsciiPlayer ============//

KviAsciiPlayer::~KviAsciiPlayer()
{
	_debug_entertrace("~KviAsciiPlayer");
	killTimers();
	while(!m_lpAsciiList->isEmpty()){
		KviAsciiStruct *lpA=m_lpAsciiList->first();
		lpA->lpFile->close();
		delete lpA->lpStream;
		delete lpA->lpFile;
		m_lpAsciiList->removeFirst();
	}
	delete m_lpAsciiList;
	_debug_leavetrace("~KviAsciiPlayer");
}

//============ playAscii ============//

bool KviAsciiPlayer::playAscii(const char *fileName,KviMdiChild *lpWindow,int timeout)
{
	_debug_entertrace("playAscii");
	if(!lpWindow)return false;
	QString szFileName(fileName);
	if(szFileName.find('/') == -1){
		//relative path
		szFileName=_macro_getKVircHomeDirectory("Ascii/");
		szFileName+=fileName;
		QFile aFile(szFileName.data());
		if(!aFile.exists()){
			szFileName=_macro_getKVircHomeDirectory("Scripts/Ascii/");
			szFileName+=fileName;
			aFile.setName(szFileName.data());
			if(!aFile.exists())return false;
		}
	} else {
		QFile aFile(szFileName.data());
		if(!aFile.exists())return false;
	}
	QFile *lpFile=new QFile(szFileName.data());
	if(!lpFile->open(IO_ReadOnly)){
		delete lpFile;
		return false;
	}
	KviAsciiStruct *lpA=new KviAsciiStruct;
	lpA->lpFile=lpFile;
	QTextStream *lpStr=new QTextStream(lpFile);
	lpA->lpStream=lpStr;
	lpA->lpWindow=lpWindow;
	if(timeout<50)timeout=50;
	m_lpAsciiList->append(lpA);
	lpA->timerId=startTimer(timeout);
	_debug_leavetrace("playAscii");
	return true;
}


//============ stopAll ============//

void KviAsciiPlayer::stopAll()
{
	_debug_entertrace("stopAll");
	killTimers();
	while(!m_lpAsciiList->isEmpty()){
		KviAsciiStruct *lpA=m_lpAsciiList->first();
		lpA->lpFile->close();
		delete lpA->lpStream;
		delete lpA->lpFile;
		m_lpAsciiList->removeFirst();
	}
	_debug_leavetrace("stopAll");
}


//============ timerEvent ============//

void KviAsciiPlayer::timerEvent(QTimerEvent *e)
{
	_debug_entertrace("timerEvent");
	KviAsciiStruct *lpA=0;
	for(lpA=m_lpAsciiList->first();lpA;lpA=m_lpAsciiList->next()){
		if(e->timerId()==lpA->timerId){
			if(m_lpFrm->m_lpMdi->m_lpChildList->findRef(lpA->lpWindow)<0){
				//the window was closed...kill the timer
				killTimer(lpA->timerId);
				lpA->lpFile->close();
				delete lpA->lpStream;
				delete lpA->lpFile;
				m_lpAsciiList->removeRef(lpA);
				return;
			} else {
				//ok right window....attempt to read a line of text...
				if(lpA->lpStream->eof()){
					//remove the ascii struct and stop the timer
					killTimer(lpA->timerId);
					lpA->lpFile->close();
					delete lpA->lpStream;
					delete lpA->lpFile;
					m_lpAsciiList->removeRef(lpA);
					return;
				}
				QString szLine=lpA->lpStream->readLine();
				//check for the window type
				int type=lpA->lpWindow->type();
				if((type==KVI_WND_TYPE_CHAN)||
					(type==KVI_WND_TYPE_QUERY)||
					(type==KVI_WND_TYPE_CHAT)){
					switch(type){
						case KVI_WND_TYPE_CHAN:
						case KVI_WND_TYPE_QUERY:
							{
								QString szNicko;
								m_lpFrm->formatNickOutputString(szNicko,m_lpFrm->m_lpGlb->szNick);
								lpA->lpWindow->doFmtOutput((type==KVI_WND_TYPE_CHAN ? KVI_OUT_OWN : KVI_OUT_PRIVMSG),"%s%s",szNicko.data(),szLine.data());
								m_lpFrm->m_lpSock->sendFmtData("PRIVMSG %s :%s",lpA->lpWindow->name(),szLine.data());	
							}
							break;
						case KVI_WND_TYPE_CHAT:
							{
								if(!((KviChatWnd *)lpA->lpWindow)->m_bConnected)return;
								lpA->lpWindow->sendData(szLine.data());
								QString szNicko;
								m_lpFrm->formatNickOutputString(szNicko,m_lpFrm->m_lpGlb->szNick);
								lpA->lpWindow->doFmtOutput(KVI_OUT_OWN,"%s%s",szNicko.data(),szLine.data());
							}
							break;
					}
//					m_lpFrm->m_lpUserParser->parseUserInput(lpA->lpWindow,type,lpA->lpWindow->name(),szLine);
				} else { //echo it
//					m_lpFrm->m_lpUserParser->m_lpIdentifiers->substitute(lpA->lpWindow,szLine,0);
					lpA->lpWindow->doOutput(KVI_OUT_ECHO,szLine.data());
				}
			}
			return;
		}
	}
	_debug_leavetrace("timerEvent");
}


#include "m_kvi_ascii.moc"

//
// $Log: kvi_ascii.cpp,v $
// Revision 1.3  1998/09/20 20:22:02  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.2  1998/09/16 16:13:07  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
