//
//   File : kvi_app.cpp (/usr/cvs/kvirc/kvirc/kvi_app.cpp)
//   Last modified : Mon Nov 23 1998 21:37:24 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviApp"
//#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_defs.h"
#include <kfiledialog.h>
#include "kvi_macros.h"
#include "kvi_frame.h"
#include <X11/Xlib.h>

#include <X11/Xatom.h>
#include <kprocess.h>

//============ main ============//

int main( int argc , char **argv)
{
	_debug_entertrace("main");
	QString szAppName=argv[0];
//	debug("Running : %s,%d",argv[0],argc);
	KviApp *lpApp=new KviApp(argc,argv,"kvirc");
	lpApp->startup();
	int retCode=lpApp->exec();
	if(lpApp->m_bRestart){
		KProcess proc;
		proc << szAppName.data();
		proc.start(KProcess::DontCare,KProcess::NoCommunication);
	}
	delete lpApp;
	return retCode;
	_debug_leavetrace("main");
}

//============ KviApp ============//

KviApp::KviApp( int &argc , char **argv , const char *szAppName): KApplication( argc , argv , szAppName )
{
	_debug_entertrace("KviApp");
	m_bRestart=false;
	_debug_leavetrace("KviApp");
}

//============ ~KviApp ============//

KviApp::~KviApp()
{
	_debug_entertrace("~KviApp");
	_macro_kviConfig->setGroup("Main");
	_macro_kviConfig->writeEntry("szKVircHomeDir",szKVircHomeDir);
	if(szKVircHomeDir.isEmpty())_debug_warning("KVirc home directory is NOT set!");
//	delete m_lpFrm;
	_debug_leavetrace("~KviApp");
}

//============ startup ============//

void KviApp::startup()
{
	_debug_entertrace("startup");
	_macro_kviConfig->setGroup("Main");
	szKVircHomeDir=_macro_kviConfig->readEntry("szKVircHomeDir","");
	m_lpFrm = new KviFrame();
	setMainWidget(m_lpFrm);
	_debug_leavetrace("startup");
}

//============ getKVircHomeDirectory ============//

QString KviApp::getKVircHomeDirectory(const char *subdir)
{
	_debug_entertrace("getKVircHomeDirectory");
	QString szRet=szKVircHomeDir.copy();
	if(szKVircHomeDir.isEmpty())return szRet;
	if(subdir){
		szRet+='/';
		szRet+=subdir;
	}
	_debug_leavetrace("getKVircHomeDirectory");
	return szRet;
}

//============ substitutePercent ============//

bool KviApp::substitutePercent(QString &szCmdLine,QString &szParam)
{
	_debug_entertrace("substitutePercent");
	int idxPercent=szCmdLine.find('%');
	if(idxPercent == -1)return false;
	while(idxPercent != -1){
		szCmdLine.replace(idxPercent,1,szParam.data());
		idxPercent=szCmdLine.find('%',idxPercent+1);
	}
	_debug_leavetrace("substitutePercent");
	return true;
}

//============ runThroughShell ============//

bool KviApp::runThroughShell(QString &szCmdLine)
{
	_debug_entertrace("runThroughShell");
	if(szCmdLine.isEmpty())return false;
	KShellProcess *proc=new KShellProcess();
	QString szArg;
	while(!szCmdLine.isEmpty()){
		szArg=getStringToken(szCmdLine);
		(*proc) << szArg.data();
	}
	bool bRet=proc->start(KProcess::DontCare,KProcess::NoCommunication);
	delete proc;
	_debug_leavetrace("runThroughShell");
	return bRet;
}

//============ getOpenFileName ============//

QString KviApp::getOpenFileName(const char *szCaption,const char *szDir,const char *szFilter)
{
	_debug_entertrace("getOpenFileName");
	KFileDialog *pFileDialog=new KFileDialog(szDir,szFilter,0,0,true,false);
	if(szCaption)pFileDialog->setCaption(szCaption);
	else pFileDialog->setCaption(i18n("Choose a file to open..."));
	m_lpFrm->m_bFocusManagingEnabled=false;
	bool bAccept=pFileDialog->exec();
	m_lpFrm->m_bFocusManagingEnabled=true;
	if(!bAccept){
		delete pFileDialog;
		QString empty;
		return empty;
	}
	QString szFileName(pFileDialog->selectedFile().data());
	delete pFileDialog;
	_debug_leavetrace("getOpenFileName");
	return szFileName;
}

//============ getSaveFileName ============//

QString KviApp::getSaveFileName(const char *szCaption,const char *szDir,const char *szFile)
{
	_debug_entertrace("getSaveFileName");
	KFileDialog *pFileDialog=new KFileDialog(szDir,0,0,0,true,false);
	if(szCaption)pFileDialog->setCaption(szCaption);
	else {
		if(szFile){
			QString szTxt;
			szTxt.sprintf("Save %s as...",szFile);
			pFileDialog->setCaption(szTxt.data());
		} else pFileDialog->setCaption(i18n("Save file as..."));
	}
	if(szFile)pFileDialog->setSelection(szFile);
	m_lpFrm->m_bFocusManagingEnabled=false;
	bool bAccept=pFileDialog->exec();
	m_lpFrm->m_bFocusManagingEnabled=true;
	if(!bAccept){
		delete pFileDialog;
		QString empty;
		return empty;
	}
	QString szFileName(pFileDialog->selectedFile().data());
	delete pFileDialog;
	_debug_leavetrace("getSaveFileName");
	return szFileName;
}

//============ ringBell ============//

void KviApp::ringBell(int volume)
{
	_debug_entertrace("ringBell");
	_range_valid(((volume<101)&&(volume>-101)));
	XBell(getDisplay(),volume);
	_debug_leavetrace("ringBell");
}



#include "m_kvi_app.moc"

//
// $Log: kvi_app.cpp,v $
// Revision 1.6  1998/10/06 14:42:04  pragma
// Tons of changes
//
// Revision 1.5  1998/09/23 12:41:28  pragma
// Another big commit.
// Added user list (Still have to fix ignore things)
// User list dialogs
// Some code rearrangements
// Minor bugfixes
//
// Revision 1.4  1998/09/20 20:22:00  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.3  1998/09/17 16:14:27  pragma
// Moving to handle mp3 , au and mid files by external players.
//
// Revision 1.2  1998/09/16 16:13:05  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
