//   $Id: kvi_alidlg.h,v 1.3 1998/09/20 20:22:00 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_ALIDLG_H_INCLUDED_
#define _KVI_ALIDLG_H_INCLUDED_

#include "kvi_types.h"

#include <krestrictedline.h>

#include <qdialog.h>
#include <qlist.h>

class KviFrame;
class KviAliasManager;
class KviMultiLineEdit;

#define _KVI_ALIDLG_MODE_NONE 0
#define _KVI_ALIDLG_MODE_RENAME 1
#define _KVI_ALIDLG_MODE_NEW 2

class KviAliasDialog : public QDialog {
	Q_OBJECT
public:
	KviAliasDialog(KviFrame *lpFrame);
	~KviAliasDialog();
public:
	KviFrame		*m_lpFrm;
	KviAliasManager	*m_lpMng;
private:
	KviMultiLineEdit	*m_lpEdit;
	QPushButton		*m_lpDone;
	QPushButton     *m_lpCancel;
	QPushButton     *m_lpHelp;
	QComboBox		*m_lpBox;
	QPushButton		*m_lpRename;
	QPushButton		*m_lpRemove;
	QPushButton		*m_lpNew;
	KRestrictedLine *m_lpLined;
	int				m_iMode;
	QString			m_szLastSelection;
	QString			m_szTmpBuf;
	QString			m_szTmpName;
	QList<KviAliasStruct> *m_lpAliasList;
protected:
	virtual void resizeEvent(QResizeEvent *);
	void enableLined(bool bEnable);
	void fillBox();
protected slots:
	void invokeHelp();
	void okPressed();
	void newAlias();
	void removeAlias();
	void renameAlias();
	void enterPressed();
	void selectionChanged(const char *szSel);
};

#endif //_KVI_ALIDLG_H_INCLUDED_
