///*
//** adpcm.h - include file for adpcm coder.
//**
//** Version 1.0, 7-Jul-92.
//*/

//average compression rate experiment: P166MMX 32MEG
// INPUT        | OUTPUT    | TIME
// shorts bytes | bytes     | min msec.   avrg.    high peak (1 time)
// 512   1024   | 256       | ~4          4          34
// 1024  2048   | 512       | ~7          8          75
// 2048  4096   | 1024      | ~13         15         175 (!!!)
// 4096  8192   | 2048      | ~26         33         91
// 8192  16384  | 4096      | ~57         80         220 (~1 sec of audio)
// 16384 32768  | 8192      | ~110        250        290

typedef struct adpcm_state{
    short	valprev;	/* Previous output value */
    char	index;		/* Index into stepsize table */
} ADPCM_state;

void ADPCM_compress(short indata[],char outdata[],int len,struct ADPCM_state * state);
void ADPCM_uncompress(char indata[],short outdata[],int len,struct ADPCM_state * state);

