#include <qdir.h>
#include <qfiledlg.h>
#include "StringToken.h"
#include "webServerPage.h"
#include "webServerPage.moc"

#include <iostream.h>
#include <qlayout.h>
#include "ircApp.h"

WebServerPage::WebServerPage(IrcClient* Client, QWidget* parent, const char* Name):
  OutputPage(Client, parent, Name)
{
  lbMsg     = new QListBox(panWidget,"lbMsg");

  webServer = ircapp->webServer;

  // Connected
  connect(inpCmd, 
	  SIGNAL(signReturn(const char*)), 
	  client, 
	  SLOT  (slotInputParse(const char*)));
  connect(webServer,
	  SIGNAL(signWriteMsg(int, const char*, bool)),
	  ircHtml(),
	  SLOT  (slotWrite   (int, const char*, bool))
	  );
  connect(webServer,
	  SIGNAL(signConnected(IrcServer*)),
	  this,
	  SLOT  (slotConnected(IrcServer*))
	  );
  connect(webServer,
	  SIGNAL(signDisconnected(IrcServer*)),
	  this,
	  SLOT  (slotDisconnected(IrcServer*))
	  );

  createPopup();
  createToolbar();
  topLayout->activate();
  show();
  resize(width(), height());
}

WebServerPage::~WebServerPage()
{
#ifdef EDEBUG
  cout << "Destruktor WebServerPage" << endl;
#endif
  delete lbMsg;
}

void WebServerPage::createPopup()
{
  IrcPopup* popup;
  if (!(popup = client->popup.find("WebServer")))
     popup = client->popup.find("Default");

  if (popup){
     connect(ircHtml()->htmlWidget(),
	     SIGNAL(popupMenu (const char*, const QPoint&)),
	     this,
	     SLOT  (slotPopup (const char*, const QPoint&))); 

     connect(popup,
	     SIGNAL(signPopup(const char*)),
	     this,
	     SLOT  (slotPopupAction(const char*)));
  }
}

void WebServerPage::createToolbar()
{
}

void WebServerPage::slotConnected(IrcServer* is)
{
  QString s = "Connection established from "+is->Host()+" on port "+is->Port();
  webServer->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
}

void WebServerPage::slotDisconnected(IrcServer* is)
{
  QString s = "Disconnected from "+is->Host()+" on port "+is->Port();
  webServer->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
}

void WebServerPage::resizeEvent(QResizeEvent* e)
{
  OutputPage::resizeEvent(e);
}

void WebServerPage::slotPopup(const char* url, const QPoint& pos)
{
  IrcPopup* popup = client->popup.find("WebServer");
  if (!popup)
     return;
  QPopupMenu* pu=popup->find("Main");
  if (pu){
    pu->popup(pos);
  }
}

void WebServerPage::slotPopupAction(const char* Action)
{
  if ( IsSelected()==true && isActiveWindow()==true)
     client->slotInputParse(Action);
}









