#ifndef  __WEBSERVER_H__
#define  __WEBSERVER_H__

#include <qlist.h>
#include <qstrlist.h>
#include <qdict.h>
#include <qsocknot.h>
#include "clientCore.h"
#include "ClientSocket.h"
#include "ServerSocket.h"
#include "ircServer.h"
#include "ircUser.h"

class WebParser;
class WebServer;
class IrcClient;

class WebClient : public IrcCore
{
  Q_OBJECT
  friend class WebParser;
public:
  WebServer* webServer;
  WebParser* webParser;
  QStrList   clientInfo;
  IrcServer* host;
  ClientSocket*     socket;
  QSocketNotifier*  sn;
  static QList<WebClient> clientList;
protected:
  QString path;
  QString methode;
  QString protocol;
  QString connection;
  QString userAgent;
public:
  WebClient(QObject* parent=0, const char* name=0);
  ~WebClient();
  void setSocket(ClientSocket* cs);
  void doReply  ();
protected:
  void sendFile(const char* File);
  void sendDir (const char* File);
  void sendHeader();
signals:
  void signConnected   (IrcServer* host);
  void signDisconnected(IrcServer* host);
  void signWriteMsg(int Type, const char* Txt, bool Filter=1);
public slots:
  void slotDisconnected();
  void slotMsgParse(int);
  void slotCusTimeout(IrcCore*);
};

class WebServer : public ClientCore
{
  Q_OBJECT
  friend class WebParser;
public:
  WebServer (IrcClient* client, QObject* Parent=0, const char* Name=0);
  ~WebServer();
public:
  int           getState (){return state; }
  ServerSocket& getSocket(){return server;}
  void sendFile(const char* File);
public:
  QDict<char>* mimeTypes;
  QString      version;
  int          port;
  int          current;
protected:
  int          state;
  ServerSocket server;
  IrcClient*   client;
private:
  void Init();
public slots:
  int slotOpen ();
  int slotOpen (int Port);
  virtual void slotServe   (IrcCore*);
  virtual void slotAccept  (ClientSocket* cs);
  virtual void slotClosed  ();
signals:
  void signConnected   (IrcServer*);
  void signDisconnected(IrcServer*);
};

#endif





