#ifndef __WEBPARSER_H__
#define __WEBPARSER_H__

#include <qobject.h>
#include <qstring.h>

class WebParser;
class WebClient;

typedef int (WebParser::*webCmdFunc)(const char* txt);
typedef struct WebCmdTabTag {
  const char* name;
  webCmdFunc     func;
} WebCmdTab;

class WebParser : public QObject
{
protected:
  static WebCmdTab cmdTab [];
  WebClient* webClient;
public:
  // Konstructor
  WebParser(QObject* Parent, const char* Name=0);
  ~WebParser(){};
  // Member Funktionen
  int parseLine (const char* txt);
protected:
  int cmdGet       (const char* txt);
  int cmdConnection(const char* txt);
  int cmdUserAgent (const char* txt);
  int cmdHost      (const char* txt);
  int cmdAccept    (const char* txt);
};

#endif







