#ifndef __OUTPUTPAGE_H__
#define __OUTPUTPAGE_H__

#include <iostream.h>
#include "ircClient.h"
#include <qdict.h>
#include <qframe.h>
#include <qlistbox.h>
#include <ktoolbar.h>
#include <qpopmenu.h>
#include <qmenubar.h>
#include <knewpanner.h>
#include <qlined.h> 
#include <qlayout.h> 
#include "ircHtml.h"
#include "ircLine.h"
#include "ircDefine.h"
#include "MDI.h"

class IrcMDI;

class OutputPage : public QWidget
{
  Q_OBJECT
  friend class IrcMDI;
protected:
  static int barHeight;
  IrcClient*  client;
  QWidget*    outWidget;
  QWidget*    panWidget;
  KNewPanner* panner;
  KToolBar*   toolbar;
  IrcHtml*    htmlMsg;
  IrcLine*    inpCmd;
  MDIWindow*  mdiWnd;

  QVBoxLayout*      topLayout;
  QDict<QPopupMenu> menu;
protected:
  virtual void resizeEvent(QResizeEvent* e);
  virtual bool eventFilter(QObject *, QEvent *e);
  virtual void mousePressEvent(QMouseEvent* e);
  void createPopup();
  void createToolbar();
  void initAll();
  bool IsSelected(){
    if (mdiWnd!=0L)
       return mdiWnd->IsSelected();
    else
       return false;
  }
signals:
  void signSetFlag(int Type, bool value);
  void signDetach (bool state, const char* name);
  void signNewMsg();
public slots:
  void slotToolbarMoved();
  void slotInputPopup(const QPoint&);
  void slotInputPopupAction(const char*);
  void setMDIWindow(MDIWindow* w);
  void setCaption(const char* name){
     if (mdiWnd!=0L)
        mdiWnd->setCaption(name);
  }
  virtual void slotBack();
  virtual void slotForward();
  virtual void slotEditCopy();
  void slotToggleLog (bool);
  void slotToggleDetach(bool);
  void slotHtmlClear();
  void slotSelected(MDIWindow*){
     inpCmd->setFocus();
  }
  virtual void slotExit(MDIWindow*);
  virtual void slotWriteOnActive(int type, const char* txt, bool Filter);
public:
  OutputPage(IrcClient* Client, QWidget* parent, const char* Name=0L);
  virtual ~OutputPage();
  IrcHtml*         ircHtml();
  IrcLine*         ircLine();

protected:
  int idTbCounter;
  int idTbDetach;
  int idTbBack;
  int idTbForward;
  int idTbClear;
  int idTbLog;
};

class WindowPage : public OutputPage
{
  Q_OBJECT
public:
  WindowPage(IrcClient* Client, QWidget* parent, const char* Name=0L);
  virtual ~WindowPage();
signals:
  void  signPopup(const char*);
public slots:
  void slotPopup(const char* url, const QPoint& pos);
  void slotPopupAction(const char*);
  virtual void slotExit(MDIWindow*);
  void slotWriteMsg(int type, const char* txt, bool parse=true);
};

#endif 



