#ifndef __ONUSERLISTPAGE_H__
#define __ONUSERLISTPAGE_H__

#include <qwidget.h>
#include <qbttngrp.h> 
#include <qgrpbox.h>
#include <qmlined.h>
#include <qlined.h>
#include <qlayout.h> 
#include <qchkbox.h> 
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include "ircUser.h"
#include "ircBan.h"
#include "ktablistbox.h"
#include "ircClient.h"
#include "ircApp.h"

class OnUserPage : public QWidget
{
  Q_OBJECT
protected:
  IrcClient* client;
  QHBoxLayout* horLayout;
  QDict<QCheckBox>    checkBox;
  QStrList            checkText;
  QDict<QLineEdit>    lineEdit;
public:
  OnUserPage(IrcClient* Client, QWidget *parent = 0L, const char *name = 0L );
  ~OnUserPage();
signals:
protected:
  void    Init();
  void    readConfig();
  void    createBox();
  void    createPushButton();
protected slots:
  void slotApply();
};


class FriendListPage : public QWidget
{
  Q_OBJECT
protected:
  FriendList*  fList;
  KTabListBox* listBox;

  QHBoxLayout* horLayout;
  QVBoxLayout* lVerLayout;
  QVBoxLayout* rVerLayout;
  
  QCheckBox*   checkBox;
public:
  FriendListPage(FriendList* list, QWidget *parent = 0L, const char *name = 0L);
  ~FriendListPage();
protected:
  void    readConfig();
  void    createButton();
  void    createListBox();
protected slots:
  void slotAdd();
  void slotEdit();
  void slotDelete();
  void slotApply();
  void slotCurrentPage(const char* page);
};


class BanListPage : public QWidget
{
  Q_OBJECT
protected:
  BanList*  bList;
  KTabListBox* listBox;

  QHBoxLayout* horLayout;
  QVBoxLayout* lVerLayout;
  QVBoxLayout* rVerLayout;

  QCheckBox*   checkBox;
public:
  BanListPage(BanList* list, QWidget *parent = 0L, const char *name = 0L);
  ~BanListPage();
protected:
  void    readConfig();
  void    createButton();
  void    createListBox();
protected slots:
  void slotAdd();
  void slotEdit();
  void slotDelete();
  void slotApply();
  void slotCurrentPage(const char* page);
};

class IgnListPage : public QWidget
{
  Q_OBJECT
protected:
  IgnoreList*  iList;
  KTabListBox* listBox;

  QHBoxLayout* horLayout;
  QVBoxLayout* lVerLayout;
  QVBoxLayout* rVerLayout;

  QCheckBox*   checkBox;
public:
  IgnListPage(IgnoreList* list, QWidget *parent = 0L, const char *name = 0L);
  ~IgnListPage();
protected:
  void    readConfig();
  void    createButton();
  void    createListBox();
protected slots:
  void slotAdd();
  void slotEdit();
  void slotDelete();
  void slotApply();
  void slotCurrentPage(const char* page);
};


#endif


