#include <stdlib.h>
#include <iostream.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qlayout.h>
#include "ircDefine.h"
#include "onEventPage.h"
#include "ircClient.h"
#include "ircApp.h"

void OnEventOutputPage::Init()
{
  btnGroup.setAutoDelete(false);
  radioBtn.setAutoDelete(false);

  eventText.setAutoDelete(true);
  valueText.setAutoDelete(true);
  dlgEvent.setAutoDelete (true);
}

OnEventOutputPage::OnEventOutputPage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  verLayout  = new QVBoxLayout(this, 10);

  createValueRadioBtn();
  createEventRadioBtn();

  verLayout->activate();
  readConfig();
  show();
}

OnEventOutputPage::~OnEventOutputPage()
{
#ifdef EDEBUG
  cout << "Destruktor OnEventOutputPage" << endl;
#endif
}


void OnEventOutputPage::createValueRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("OnEventValue", bg=new QButtonGroup(0L, this));
  verLayout->addWidget(bg);

  connect(bg, SIGNAL(clicked(int)), SLOT(slotValueClicked(int)));

  QHBoxLayout* hbox;
  
  hbox = new QHBoxLayout(bg, 10);
  hbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  valueText.append(entry=qstrdup("Status"));
  radioBtn.insert(entry, rb = new QRadioButton("On Status", bg));
  rb->setFixedHeight(25);
  hbox->addWidget(rb);

  valueText.append(entry=qstrdup("Active"));
  radioBtn.insert(entry, rb = new QRadioButton("On Active/Channel", bg));
  rb->setFixedHeight(25);
  hbox->addWidget(rb);

  valueText.append(entry=qstrdup("Dialog"));
  radioBtn.insert(entry, rb = new QRadioButton("On Dialog", bg));
  rb->setFixedHeight(25);
  rb->setEnabled(false);
  hbox->addWidget(rb);
  hbox->addSpacing(bg->fontMetrics().height());
  hbox->activate();
}

void OnEventOutputPage::createEventRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("OnEventOutput", bg=new QButtonGroup(" Event ", this));
  verLayout->addWidget(bg, 10);

  connect(bg, SIGNAL(clicked(int)), SLOT(slotEventClicked(int)));

  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  
  hbox = new QHBoxLayout(bg, 10);
  vbox = new QVBoxLayout;
  hbox->addLayout(vbox, 10);

  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;

  eventText.append(entry=qstrdup("OnEventOutputTOPIC"));
  radioBtn.insert(entry, rb = new QRadioButton("Event TOPIC", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  eventText.append(entry=qstrdup("OnEventOutputJOIN"));
  radioBtn.insert(entry, rb = new QRadioButton("Event JOIN", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  eventText.append(entry=qstrdup("OnEventOutputPART"));
  radioBtn.insert(entry, rb = new QRadioButton("Event PART", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  eventText.append(entry=qstrdup("OnEventOutputMODE"));
  radioBtn.insert(entry, rb = new QRadioButton("Event MODE", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  eventText.append(entry=qstrdup("OnEventOutputNICK"));
  radioBtn.insert(entry, rb = new QRadioButton("Event NICK", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  eventText.append(entry=qstrdup("OnEventOutputKICK"));
  radioBtn.insert(entry, rb = new QRadioButton("Event KICK", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  vbox->addStretch(10);

  vbox = new QVBoxLayout;
  hbox->addLayout(vbox, 10);

  vbox->addSpacing(bg->fontMetrics().height());

  eventText.append(entry=qstrdup("OnEventOutputERROR"));
  radioBtn.insert(entry, rb = new QRadioButton("Event ERROR", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  eventText.append(entry=qstrdup("OnEventOutputISON"));
  radioBtn.insert(entry, rb = new QRadioButton("Event ISON", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  eventText.append(entry=qstrdup("OnEventOutputWHOIS"));
  radioBtn.insert(entry, rb = new QRadioButton("Event WHOIS", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);
  // Add to dialog
  dlgEvent.append(entry);

  eventText.append(entry=qstrdup("OnEventOutputQUIT"));
  radioBtn.insert(entry, rb = new QRadioButton("Event QUIT", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  eventText.append(entry=qstrdup("OnEventOutputKILL"));
  radioBtn.insert(entry, rb = new QRadioButton("Event KILL", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  eventText.append(entry=qstrdup("OnEventOutputCTCP"));
  radioBtn.insert(entry, rb = new QRadioButton("Event CTCP", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  vbox->addStretch(10);

  hbox->activate();
}

void OnEventOutputPage::readConfig()
{
#ifdef EDEBUG
  cout << "OnEventOutputPage::readConfig"<<endl;
#endif
  QString entry;
  QString value;

  QDictIterator<QRadioButton> it(radioBtn);
  QRadioButton* rbtn;
  for (;(rbtn=it.current())!=0L;++it)
     rbtn->setChecked(false);
  
  entry = "OnEventOutputWHOIS";
  if (dlgEvent.find(entry)>=0)
     radioBtn["Dialog"]->setEnabled(true);
  else
     radioBtn["Dialog"]->setEnabled(false);

  radioBtn[entry]->setChecked(true);

  value = ircapp->readEntry(entry, "Active");

  radioBtn[value]->setChecked(true);
}

void OnEventOutputPage::slotValueClicked(int)
{
#ifdef EDEBUG
  cout << "OnEventOutputPage::slotValueClicked:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  for (value=valueText.first();value;value=valueText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 break;
  }

  for (entry=eventText.first();entry;entry=eventText.next()){
      rb=radioBtn[entry];
      if (!rb)
	 continue;
      if (rb->isChecked()){
	 ircapp->writeEntry(entry, value);
	 return;
      }
  }
}

void OnEventOutputPage::slotEventClicked(int)
{
#ifdef EDEBUG
  cout << "OnEventOutputPage::slotEventClicked:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  for (entry=eventText.first();entry;entry=eventText.next()){
      rb=radioBtn[entry];
      if (!rb)
	 continue;
      if (rb->isChecked()){
	 break;
      }
  }
  
  if (dlgEvent.find(entry)>=0)
     radioBtn["Dialog"]->setEnabled(true);
  else
     radioBtn["Dialog"]->setEnabled(false);

  value = ircapp->readEntry(entry, "Active");
  radioBtn[value]->setChecked(true);
}

#include "onEventPage.moc"








