#ifndef __ONDCCCHATPAGE_H__
#define __ONDCCCHATPAGE_H__

#include <qwidget.h>
#include <qbttngrp.h> 
#include <qgrpbox.h>
#include <qmlined.h>
#include <qlined.h>
#include <qlayout.h> 
#include <qchkbox.h> 
#include <qdict.h>
#include <qstrlist.h>
#include <qlabel.h>
#include <qradiobt.h> 
#include "kintegerline.h"
#include "ircClient.h"
#include <kconfig.h>

class OnDCCChatPage : public QWidget
{
  Q_OBJECT
protected:
  IrcClient* client;
  QVBoxLayout* topLayout;
  QGridLayout* grid;
  QDict<QButtonGroup> btnGroup;
  QDict<QRadioButton> radioBtn;
  QStrList            actionText;
  QDict<QGroupBox>    groupBox;
  QStrList            configText;
  QDict<KIntegerLine> intLine;
public:
  OnDCCChatPage(IrcClient* Client, QWidget *parent = NULL, const char *name = NULL );
  ~OnDCCChatPage();
signals:
protected:
  void    Init();
  void    readConfig();
  void    createActionRadioBtn();
  void    createConfigBox();
  void    createPushButton();
protected slots:
  void slotApply();
  void slotCurrentPage(const char* page){
      if (!stricmp(page, name()))
	 readConfig();
  } 
};

#endif
