#ifndef __KEIRC_H__
#define __KEIRC_H__

#include <qframe.h>
#include <qaccel.h>
#include <qmsgbox.h>
#include <ktopwidget.h>
#include <kconfig.h>
#include <ktoolbar.h>   
#include <kstatusbar.h>
#include <ktoolbar.h>
#include <qdict.h>
#include "ircClient.h"
#include "ircMDI.h"
#include "ircPopup.h"
#include "ircApp.h"


class KEIrc : public KTopLevelWidget
{
    Q_OBJECT;
protected:
    QString name;
public:
    KEIrc(const char *name=NULL);
    virtual ~KEIrc();
public slots:
     void slotFileNew()  ;
     void slotFileClientSetup();
     void slotFileConnect();
     void slotFileDisconnect();
     void slotFileClose();
     void slotFileExit() ;

     void slotOptionsPref();
     void slotOptionsToolbar();
     void slotOptionsStatusbar();
     void slotOptionsSave();

     void slotToolOpActionDlg();
     void slotToolChannelDlg();
     void slotToolWhoisDlg();

     void slotWindow(int id);

     void slotHelpUsing();
     void slotHelpAbout();

     void slotCurServer(IrcServer* is);
     void slotLiveStatus(IrcCore*);
     // Slot von ToolBar
     void slotComboServer(const char*);
     void slotComboAddServer(IrcServer* is);
     void slotComboCurServer(IrcServer* is);
     void slotComboDelServer(const char* s);

     void slotOptPref();
     
     // Slot von Socket -> Statusbar
     void slotConnected (IrcServer*);
     void slotDisconnected(IrcServer*);
     void slotLagging(const char*);
     
     void slotCurNick(const char* nick);
     void slotMode   (const char* txt);

     void slotDCCChat();
     void slotDCCSend();
     void slotCtcpSound();
     virtual void slotWriteOnActive(int Type, const char* txt, bool Filter);
     
     void slotWebServer(bool);
protected:
     void closeEvent (QCloseEvent*  e);
     void resizeEvent(QResizeEvent* e);
     void enableMenuItems();
private:
     void createMenu();
     void createToolbar();
     void createStatusbar();
     void readConfig();

private:
     IrcMDI*            view;
     KMenuBar*          menubar;
     KToolBar*          toolbar;
     KStatusBar*        statusbar;
     QDict<QPopupMenu>  menu;

     int idFileNew;
     int idFileClientSetup;
     int idFileConnect;
     int idFileDisconnect;
     int idFileClose;
     int idFileExit;

     int idOptPref;
     int idOptToolbar;
     int idOptStatusbar;
     int idOptSave;

     int idToolOpActionDlg;;
     int idToolChannelDlg;
     int idToolWhoisDlg;

     int  idTbCounter;
     int  idTbClientSetup;
     int  idTbConnect;
     int  idTbDisconnect;
     int  idTbCombo;
     int  idTbDCCChat;
     int  idTbDCCSend;
     int  idTbCtcpSound;
     int  idTbWebServer;

     int  idSbNick;
     int  idSbStatus;
     int  idSbMode;
     int  idSbLagging;
     int  idSbLive;

     bool showToolbar;
     bool showStatusbar;

     IrcClient*  client;

     static int          nClient;
     static QList<KEIrc> keircList;
};

#endif





