#ifndef __IRCPRIVMSG_H__
#define __IRCPRIVMSG_H__

#include <qobject.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qdict.h>
#include "ircUser.h"
#include "clientCore.h"

class IrcClient;

class IrcPrivMsg : public ClientCore
{
  Q_OBJECT
protected:
public:
  IrcClient* client;
  IrcUser*   user;
  int        firstJoin;
public:
  IrcPrivMsg(const char* User, QObject* Parent=0, const char* Name=0);
  ~IrcPrivMsg();
  virtual QString cmdSubstitution(const char* Txt);
  int  changeNick (const char* nick, const char* NewNick);
  void setUser    (const char* nick, const char* user, const char* host);
  virtual int onMsg      (const char* from, const char* txt);
  bool checkFlood(const char* who);
signals:
  void signChangeNick(const char* NewNick);
public slots:
  void slotInputParse(const char* Txt);
};

#endif


