#include <qkeycode.h>
#include "ircMultiLine.moc"
#include "ircMultiLine.h"

IrcMultiLine::IrcMultiLine(QWidget* parent, const char* name) : 
  QMultiLineEdit(parent, name)
{

}

IrcMultiLine::~IrcMultiLine()
{
}

void IrcMultiLine::keyPressEvent(QKeyEvent *e)
{
  int k = e->key();

  if (e->state() & ControlButton){
     int l, c;
     cursorPosition(&l, &c);
     QString s="";
     switch (k) {
     case Key_B:
       //insertChar (0x02);
       s += 0x02;
       s += " ";
       insertAt (s, l, c);
       emit textChanged();
       return;
       break;
     case Key_U:
       insertChar(0x1F);
       return;
       break;
     case Key_I:
       insertChar(0x16);
       return;
       break;
     case Key_K:
       insertChar(0x03);
       return;
       break;
     case Key_O:
       insertChar(0x0F);
       return;
       break;
     }
  }
  QMultiLineEdit::keyPressEvent(e);
}
