#include <iostream.h>
#include <qfile.h>
#include <qtstream.h> 
#include <qfiledlg.h> 
#include "ircEdit.h"
#include "ircEdit.moc"
#include "ircApp.h"

IrcEdit::IrcEdit(const char *name, const char* file) : KTopLevelWidget(name)
{
   setName("IrcEdit");
   idSbLine = 1;

   
   setFocusPolicy(QWidget::StrongFocus);
   qApp->installEventFilter(this);

   createMenu     ();
   createStatusbar();

   setMenu        (menubar);
   menubar->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
   menubar->setLineWidth(2);

   setStatusBar   (statusbar);

   setFrameBorderWidth(0);
   setView(view=new IrcMultiLine(this));

   menubar->show();

   enableStatusBar(KStatusBar::Show);

   setMinimumSize( 550, 300 );

   QString geometry = ircapp->readEntry(this->name+"Geometry", "" );
   if (!geometry.isEmpty()){
      int width, height;
      sscanf( geometry, "%dx%d", &width, &height );
      resize( width, height );
   }
   // Connection

   resize(width(), height());
   setCaption("IrcEdit");

   show();
}


IrcEdit::~IrcEdit()
{
#ifdef EDEBUG
    cout << "Destruktor IrcEdit" << endl;
#endif 
    delete menubar;
    delete statusbar;
    delete view;
}

void IrcEdit::createMenu()
{
   menu.setAutoDelete (false);

   QPopupMenu* pm;
   menu.insert("file", pm=new QPopupMenu);
   idFileNew     = pm->insertItem("&New ",  this, SLOT(slotFileNew()),   CTRL+Key_N);
   idFileOpen    = pm->insertItem("&Open",  this, SLOT(slotFileOpen()),  CTRL+Key_O);

   pm->insertSeparator();

   idFileSave    = pm->insertItem("&Save",   this, SLOT(slotFileSave()),  CTRL+Key_S);
   idFileSaveAs  = pm->insertItem("&Save as",this, SLOT(slotFileSaveAs()));

   idFileExit    = pm->insertItem("E&xit",   this, SLOT(slotFileExit()),    CTRL+Key_X);

   menubar = new KMenuBar( this );
   CHECK_PTR(menubar);
   menubar->insertItem("&File",    menu["file"]);
}


void IrcEdit::createStatusbar()
{
   statusbar = new KStatusBar(this);
   statusbar->insertItem("Line: 1234", idSbLine);

   statusbar->changeItem("Line:     ", idSbLine);
}

void IrcEdit::resizeEvent( QResizeEvent * )
{
   QString Geometry;
   Geometry.sprintf("%dx%d", geometry().width(), geometry().height());
   ircapp->writeEntry(name+"Geometry", Geometry);
   view->setGeometry(0,0,view_right, view_bottom);
}

void IrcEdit::closeEvent (QCloseEvent *)
{
    delete this;
}

void IrcEdit::slotFileNew()
{
  setCaption("Untitled");
  view->clear();
}

void IrcEdit::slotFileOpen()
{  
  QString dir=ircapp->readEntry("TclScriptDir", ircapp->home);
  QString fileName = QFileDialog::getOpenFileName(dir, "*.tcl");
  if (!fileName.isEmpty()){
     QFile f(fileName);
     if ( f.open(IO_ReadOnly) ) {
        setCaption(fileName);
        QTextStream t( &f );
        QString s;
        while ( !t.eof() ) {
            s = t.readLine();  
	    view->insertLine(s);
        }
        f.close();
     }
  }
}

void IrcEdit::slotFileSave()
{
  QString fn=caption();
  
}

void IrcEdit::slotFileSaveAs()
{

}

void IrcEdit::slotFileExit()
{
  delete this;
}


