#include <iostream.h>
#include "StringToken.h"
#include "ircChannel.h"
#include "ircChannel.moc"
#include "ircDefine.h"
#include "ircClient.h"
#include "ircApp.h"

IrcChannel::IrcChannel(const char* Channel, QObject* Parent, const char*):
  ClientCore(Parent, Channel)
{
  firstJoin = 1;
  topic     = "";
  topicBy   = "";
  if (!Channel)
     return;
  client = (IrcClient*)Parent;
  cuList = new QDict<ChannelUser>(20,false, true);
  cuList->setAutoDelete(true);
  banList= new BanList(client);
  start();
}


IrcChannel::~IrcChannel()
{
#ifdef EDEBUG
  cout << "Destruktor IrcChannel" << endl;
#endif
  //emit signDelClient(name());
  delete cuList;
}

QString IrcChannel::cmdSubstitution(const char* Txt)
{
#ifdef EDEBUG
  cout << "IrcChannel::cmdSub" << Txt<<endl;
#endif
  QDict<char> list;
  list.setAutoDelete(true);
  list.insert("$c",    qstrdup(name()));
  list.insert("$to",   qstrdup(name()));
  
  return ClientCore::cmdSubstitution(list, Txt);
}

// Param: +b/+o param
int IrcChannel::setMode(const char* From, const char* Param)

{
#ifdef EDEBUG
  cout << "IrcChannel::setMode:" <<From<<":"<<Param<<endl;
#endif
  StringToken tf(From);
  StringToken tt(Param);
  QString nick = tf.nextToken(" !");
  
  QString mode   = tt.nextToken();
  QString param  = tt.toEnd();
  StringToken pt(param, " ");
  QString t;
  // Falls From ist empty dann nicht ausgegeben
  if (!nick.isEmpty()){
     t = "Mode change "+mode+" "+param+" by "+nick;
     
     QString entry=ircapp->readEntry("OnEventOutputMODE", "Active");
     if (!stricmp(entry, "Active"))
        slotWriteMsg(TYPE_INFO|TYPE_IMG, t);
     else if (!stricmp(entry, "Status"))
        client->slotWriteMsg(TYPE_INFO|TYPE_IMG, t);
  }
  char    sign='+';
  for (uint i=0;i<mode.length();i++){
     QString ms="";
     switch(mode[i]){
       case '+':
	 sign = '+';
	 break;
       case '-':
	 sign = '-';
	 break;
       case 'o':
       case 'v':{
	 QString nick   = pt.nextToken();
	 ms += mode[i];
	 if ( sign == '+' )
	    addUserMode(nick, ms);
	 else 
            delUserMode(nick, ms);
	 break;
       }
       case 'b':
       case 'k':
       case 'l':{
         
	 QString ps =  pt.nextToken();
	 ms += mode[i];
	 if ( sign == '+' )
	    getMode().addMode(ms, ps);
	 else
	    getMode().delMode(ms, ps);
	 break;
       }
       default:
	 ms += mode[i];
	 if ( sign == '+' )
	    getMode().addMode(ms, "");
	 else
	    getMode().delMode(ms, "");
	 break;
     }
  }
  return 1;      
}


int IrcChannel::setTopic(const char* Topic, const char* From)
{
  if (!Topic && !From)
     return 1;
  QString t;
  QString nick;
  if (Topic){
     t="";
     topic = Topic;
     t = "Topic is "+topic;
  }
  if (From){
     t="";
     topicBy = From;
     StringToken token(From);
     nick=token.nextToken(" !");
     t += "Topic set by "+nick;
  }
  if (Topic && From)
     t = nick+" has changed topic to "+topic;
  emit signTopic(topic, topicBy);

  QString entry=ircapp->readEntry("OnEventOutputTOPIC", "Active");
  if (!stricmp(entry, "Active"))
     slotWriteMsg(TYPE_INFO|TYPE_IMG, t);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, t);
  return 1;      
}

int IrcChannel::partChannel(const char* Who)
{
  QString who = Who;
  StringToken t(Who);
  QString nick=t.nextToken(" !");
  if (!cuList->find(nick))
     return 0;
  cuList->remove(nick);
  emit signDelUser (nick);
  QString s;
  s=nick+" ("+who+") has left channel "+QString(name());

  QString entry=ircapp->readEntry("OnEventOutputPART", "Active");
  if (!stricmp(entry, "Active"))
     slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);

  return 1;      
}

int IrcChannel::joinChannel(const char* Who)
{
#ifdef EDEBUG
  cout << "IrcChannel::joinChannel("<<Who<<")"<<endl;
#endif
  QString who = Who;
  StringToken t(Who);
  QString nick=t.nextToken(" !");
  QString user=t.nextToken(" !@");
  QString host=t.nextToken(" @");
  if (cuList->find(nick))
     return 0;
  cuList->insert(nick, new ChannelUser(nick, user, host));
  emit signAddUser (nick);
  QString s;
  if (nick==mNick){
     QString cmd=QString("/MODE ")+name();
     emit signCommand(name(), cmd);
     emit signCommand(name(), cmd+" b");
     emit signCommand(name(), "/TOPIC");
     s="You have joined to channel "+QString(name());
  }
  else
     s=nick+" ("+who+") has joined to channel "+QString(name());

  QString entry=ircapp->readEntry("OnEventOutputJOIN", "Active");
  if (!stricmp(entry, "Active"))
     slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);

  return 1;      
}


int IrcChannel::addUser(const char* Nick, const char* User, const char* Host)
{
#ifdef EDEBUG
  cout << "IrcChannel::addUser("<<Nick<<")"<<endl;
#endif
  QString mode = "";
  QString nick = Nick;
  if (cuList->find(nick))
     return 0;
  ChannelUser* cu;
  cuList->insert(nick, cu=new ChannelUser(nick, User, Host));
  emit signAddUser (nick);
  cu->addMode(mode);
  emit signChangeUserMode (nick, cu->code());
  return 1;      
}

int IrcChannel::delUser(const char* Nick)
{
  StringToken token(Nick);
  QString nick=token.nextToken(" +@");

  cuList->remove  (nick);
  emit signDelUser(nick);
  return 1;      
}

int IrcChannel::addUserMode(const char* Nick, const char* Mode)
{
#ifdef EDEBUG
  cout << "IrcChannel::addUserMode("<<Nick<<","<<Mode<<")"<<endl;
#endif
  QString mode =Mode;
  QString nick =Nick;
  ChannelUser* cu = cuList->find(nick);
  if (!cu)
     return 0;
  QString m;
  cu->addMode(Mode);
  emit signChangeUserMode(nick, cu->code());
  return 1;      
}

int IrcChannel::delUserMode(const char* Nick, const char* Mode)
{
  QString mode=Mode;
  QString nick=Nick;
  ChannelUser* cu = cuList->find(nick);
  if (!cu)
     return 0;
  QString m;
  cu->delMode(Mode);
  emit signChangeUserMode(nick, cu->code());
  return 1;      
}

int IrcChannel::changeNick(const char* Nick, const char* NewNick)
{
  QString nnick=NewNick;
  QString nick =Nick;
  ChannelUser* cu = cuList->take(nick);
  if (!cu)
     return 0;
  cuList->insert(nnick, cu);
  emit signChangeNick(nick, nnick);
  QString s;
  s = nick+" is now known as "+nnick; 

  QString entry=ircapp->readEntry("OnEventOutputNICK", "Active");
  if (!stricmp(entry, "Active"))
     slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
  return 1;      
}

int IrcChannel::onKick(const char* Who, const char* Txt)
{
#ifdef EDEBUG
  cout << "IrcChannel::onKick:"<<Txt<<endl;
#endif
  QString who = Who;
  StringToken tf(Who);
  StringToken tt(Txt);
  QString nick=tf.nextToken(" !");
  
  QString kicked=tt.nextToken();
  QString kom   =tt.toEnd(" :");
  if (!cuList->find(kicked))
     return 0;
  cuList->remove(kicked);
  emit signDelUser (kicked);
  QString t;
  t = kicked+ " has been kicked by "+nick+" ("+who+") "+"("+kom+")";

  QString entry=ircapp->readEntry("OnEventOutputKICK", "Active");
  if (!stricmp(entry, "Active"))
     slotWriteMsg(TYPE_INFO|TYPE_IMG, t);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, t);
  return 1;      
}

int IrcChannel::onKill(const char* Who, const char* Txt)
{
  QString who = Who;
  StringToken tf(Who);
  StringToken tt(Txt);
  QString killed=tt.nextToken();
  QString kom   =tt.toEnd    ();

  if (!cuList->find(killed))
     return 0;
  cuList->remove(killed);
  emit signDelUser (killed);
  QString t;
  t = killed+" has been killed by "+who+ " ("+kom+")";

  QString entry=ircapp->readEntry("OnEventOutputKILL", "Active");
  if (!stricmp(entry, "Active"))
     slotWriteMsg(TYPE_INFO|TYPE_IMG, t);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, t);
  return 1;
}


int IrcChannel::onQuit(const char* Who, const char* Txt)
{
  QString who = Who;
  StringToken tf(Who);
  StringToken tt(Txt);
  QString nick=tf.nextToken(" !");
  
  QString kom = Txt;
  if (!cuList->find(nick))
     return 0;
  cuList->remove(nick);
  emit signDelUser (nick);
  QString t;
  t = "Signoff "+nick+" ("+who+") "+"("+kom+")";

  QString entry=ircapp->readEntry("OnEventOutputQUIT", "Active");
  if (!stricmp(entry, "Active"))
     slotWriteMsg(TYPE_INFO|TYPE_IMG, t);
  else if (!stricmp(entry, "Status"))
     client->slotWriteMsg(TYPE_INFO|TYPE_IMG, t);
  return 1;      
}

int IrcChannel::onMsg(const char* Who, const char* Txt)
{
#ifdef EDEBUG
  cout << "onMsg:"<<Who<<":"<<Txt<<endl;
#endif
  QString who = Who;
  StringToken tf(Who);
  StringToken tt(Txt);
  QString nick=tf.nextToken(" !");
  int Type;
  if (nick==mNick)
     Type=TYPE_TEXT;
  else
     Type=TYPE_MSG;
  QString t=tt.nextToken();
  QString s="";
  s += 0x02;
  if (t=="ACTION"){
     s += nick+0x02+" "+tt.toEnd("\n").remove(0, 1);
     emit signWriteMsg(TYPE_ACTION|TYPE_IMG, s, 1);
  }
  else{
     s += "<"+nick+">"+0x02+" ";
     s += Txt;
     emit signWriteMsg(Type, s, 1);
  }

  // From me
  if (Type==TYPE_TEXT)
     return 1;
  checkFlood(Who);
  return 1;      
}

void IrcChannel::slotInputParse(const char* Txt)
{
#ifdef EDEBUG
  cout << "IrcChannel::slotInputParse:"<<Txt<<endl;
#endif
  QString inp = client->alias->eval(Txt);
  inp = cmdSubstitution(inp);
  if (inp.isEmpty())
     return;
  emit signCommand(name(), inp);
}

ChannelMode& IrcChannel::getMode()
{
  return mode;
}

bool IrcChannel::checkFlood(const char* Who)
{
  QString who = Who;
  StringToken st(Who);
  QString nick=st.nextToken(" !");
  // Check Flood
  int inSecond, maxLine;
  QString entry, value;
  entry = "FloodProtectionActivate"; value = ircapp->readEntry(entry, "Yes");
  if (value=="No")
     return 0;

  IrcUser* user=cuList->find(nick);
  if (user==0L)
     return 0;
  entry = "FLOOD_SECOND"; value = ircapp->readEntry(entry, "1");
  inSecond = value.toInt();
  entry = "FLOOD_MAXLINE"; value = ircapp->readEntry(entry, "3");
  maxLine = value.toInt();
  bool status=user->checkFlood(inSecond, maxLine);
#ifdef TCL
  entry="BIND_FLOOD";
  value=ircapp->readEntry(entry, "Yes");
  if (status==true && value=="Yes"){
     QStrList funcName;
     funcName.setAutoDelete(TRUE);
     int nTcl=client->tclCmd->getBindProc("FLOOD", "c", funcName);
     if (nTcl){
       QString argv = nick+" c "+who+" "+QString(name());
       client->tclCmd->evalCmd(funcName, argv);
     }
  }
#endif
  return status;
}


void IrcChannel::addBan(const char* ident, ulong second)
{
  banList->addUser(ident, 0, name(), second);
  BanUser* bu = banList->getUser(ident, false);

  ChannelUser* cu=cuList->find(mNick);
  if (bu!=0L && cu!=0L && cu->haveOp()){
     QString s = QString(name())+" +b "+bu->getIdent();
     client->getSocket().sendMode(s);
  }
}

void IrcChannel::timeChecker()
{
  // Banlist
  BanUser* bu;
  for (bu=banList->first();bu!=0L;){
     if (bu->getSecond()>1){
        bu->decSecond();
	banList->setUpdate(true);
	bu=banList->next();
     }
     else if (bu->getSecond()==1){
        ChannelUser* cu=cuList->find(mNick);
	if (cu && cu->haveOp()){
	   QString s = QString(name())+" -b "+bu->getIdent();
	   client->getSocket().sendMode(s);
	}
        banList->delUser(bu->getIdent());
	banList->setUpdate(true);
	bu=banList->current();
     }
     else
        bu=banList->next();
  } 
}





