#ifndef __DCCFILEDIALOG_H__
#define __DCCFILEDIALOG_H__

#include <qdir.h>
#include <qlayout.h>
#include <qbttngrp.h>
#include <qframe.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qdialog.h>
#include <qdatetm.h>
#include <qtimer.h>
#include <qdict.h>
#include <qcombo.h> 
#include "fileListBox.h"
#include "ktablistbox.h"

class IrcClient;

class DCCFileDialog : public QDialog
{
  Q_OBJECT
protected:
  IrcClient* client;
  FileBox*   fileBox;
  QHBoxLayout* horLayout;
  QFrame*      frame;
  KTabListBox* listBox;     // file entry list with size
  QComboBox*   comboBox;    // user entry list
  QStrList     userList;
public:
  DCCFileDialog(IrcClient* Client, bool Modal=TRUE, QWidget *parent=NULL, const char *name=NULL);
  ~DCCFileDialog();
protected:
  void    Init();
  void    readConfig();
  void    createFileBox();
  void    createButton();
  void    createListBox();
  virtual void    resizeEvent(QResizeEvent*);
protected slots:
  void slotAddFile();
  void slotDelFile();
  void slotSend();
  void slotOk();
  void slotCancel();
  void slotClear();
public slots:
  virtual void show(const char* to=NULL);
};

#endif



