#include "ircClient.h"
#include "clientSetupTab.h"
#include <iostream.h>
#include <qstring.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qmsgbox.h>
#include "ktablistbox.h" 
#include "kmsgbox.h"
#include "ircServer.h"
#include "clientSetupTab.moc"
#include "lineDialog.h"
#include "serverDialog.h"

IrcSetup::IrcSetup(IrcClient* client, QWidget* parent, const char* name ) : 
  QDialog(parent, name, true)
{
#ifdef EDEBUG
  cout << "Konstruktor IrcSetup" << endl;
#endif
   setCaption("KEirc Client Setup");

   this->client = client;

   QVBoxLayout* vbox=new QVBoxLayout(this, 2);
   tabCtl       = new KTabCtl(this);
   vbox->addWidget(tabCtl, 10);

   vbox->addSpacing(2);

   QHBoxLayout* hbox=new QHBoxLayout;
   vbox->addLayout(hbox);

   vbox->addSpacing(2);

   hbox->addStretch(10);
   QPushButton* btn=new QPushButton("Ok", this);
   hbox->addWidget(btn);
   btn->setFixedSize(75, 25);
   connect(btn, SIGNAL(clicked()),
	   this,SLOT  (slotOk()));

   btn=new QPushButton("Cancel", this);
   hbox->addWidget(btn);
   btn->setFixedSize(75, 25);
   connect(btn, SIGNAL(clicked()),
	   this,SLOT  (slotCancel()));

   hbox->addStretch(10);

   clientSetupTab = new ClientSetupTab(client, tabCtl);
   tabCtl->addTab(clientSetupTab, "Client Setup");
   
   proxyTab = new OnProxyPage(client, tabCtl);
   tabCtl->addTab(proxyTab, "Firewall");

   listProxyTab = new SocksPage(client, tabCtl);
   tabCtl->addTab(listProxyTab, "Proxylist");

   vbox->activate();
   tabCtl->setTabEnabled ("Client Setup", true);
}

IrcSetup::~IrcSetup()
{
#ifdef EDEBUG
  cout << "Destruktor IrcSetup" << endl;
#endif
}

void IrcSetup::slotOk()
{
  clientSetupTab->slotApply();
  proxyTab->slotApply();
  listProxyTab->slotApply();
  done(Accepted);
}

void IrcSetup::slotCancel()
{
  done(Rejected);
}


ClientSetupTab::ClientSetupTab(IrcClient* client,  QWidget *parent, const char *name ) : 
  QFrame(parent, name)
{
#ifdef EDEBUG
  cout << "Konstruktor ClientSetupTab" << endl;
#endif
   this->client = client;
   pb.setAutoDelete(FALSE);
   cb.setAutoDelete(FALSE);
   
   horLayout  = new QHBoxLayout(this, 10);
   lVerLayout = new QVBoxLayout(0);
   horLayout->addLayout(lVerLayout,10);
   rVerLayout = new QVBoxLayout(0);
   horLayout->addLayout(rVerLayout,5);

   QFrame* listFrame;
   listFrame = new QFrame(this);
   listFrame->setLineWidth(2);
   listFrame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

   lVerLayout->addSpacing(5);
   lVerLayout->addWidget(listFrame, 10);
   //listFrame->setMinimumSize(400, 300);

   // Border 20
   QVBoxLayout* vlayout;
   vlayout     = new QVBoxLayout(listFrame, 5);
   serverBox   = new KTabListBox(listFrame, "serverBox", 3);
   vlayout->addWidget(serverBox, 10);
   serverBox->setFixedSize(300, 220);
   vlayout->activate();

   serverBox->setColumn(0, "Server");
   serverBox->setColumn(1, "Port");
   serverBox->setColumn(2, "Info");
   serverBox->setColumnWidth(0, 150);
   serverBox->setColumnWidth(1, 75 );
   serverBox->setColumnWidth(2, 150);
   serverBox->setSeparator  (':');

   QDictIterator<IrcServer> it(*client->server);
   for(;it.current();++it){
      IrcServer* is=it.current();
      serverBox->appendItem(is->toString());
   }
   setCurServer(client->curServer);

   lVerLayout->addSpacing(10);
   QBoxLayout* hlayout;
   hlayout = new QHBoxLayout;
   lVerLayout->addLayout(hlayout);

   QPushButton* btn;
   hlayout->addStretch(10);
   pb.insert("AddServer", btn=new QPushButton(" Add ", this));
   hlayout->addWidget(btn);
   btn->setFixedSize(70, 25);
   connect(btn, SIGNAL(clicked()), this, SLOT(slotAddServer()));

   pb.insert("EditServer", btn=new QPushButton(" Edit ", this));
   hlayout->addWidget(btn);
   btn->setFixedSize(70, 25);
   connect(btn, SIGNAL(clicked()), this, SLOT(slotEditServer()));

   pb.insert("DelServer", btn=new QPushButton(" Delete ", this));
   hlayout->addWidget(btn);
   btn->setFixedSize(70, 25); 
   connect(btn, SIGNAL(clicked()), this, SLOT(slotDelServer()));

   hlayout->addStretch(10);

   lVerLayout->addSpacing(10);

   QGroupBox* gb;
   gb = new QGroupBox("Nick", this);
   rVerLayout->addWidget(gb);


   vlayout = new QVBoxLayout(gb, 8);
   vlayout->addSpacing(10);

   QComboBox* combo;
   cb.insert("Nick", combo=new QComboBox(FALSE, gb, "comboNick"));
   combo->setInsertionPolicy(QComboBox::AtCurrent);
   QToolTip::add(combo, "Select nick name" );
   combo->insertStrList(&client->nick);
   setCurNick(client->curNick);
   vlayout->addWidget(combo);
   combo->setFixedSize(205, 25);

   hlayout = new QHBoxLayout();
   vlayout->addLayout(hlayout);
   pb.insert("AddNick", btn=new QPushButton(" Add ", gb));
   hlayout->addWidget(btn);
   btn->setFixedSize(100, 20);   
   connect(btn, SIGNAL(clicked()), this, SLOT(slotAddNick()));

   pb.insert("DelNick", btn=new QPushButton(" Delete ", gb));
   hlayout->addWidget(btn);
   btn->setFixedSize(100, 20); 
   connect(btn, SIGNAL(clicked()), this, SLOT(slotDelNick()));
   vlayout->activate();

   gb = new QGroupBox("User", this);
   rVerLayout->addWidget(gb);
   vlayout = new QVBoxLayout(gb, 8);
   vlayout->addSpacing(10);

   cb.insert("User", combo = new QComboBox(FALSE, gb, "comboUser"));
   combo->setInsertionPolicy(QComboBox::AtCurrent);
   QToolTip::add(combo, "Select user name" );
   combo->insertStrList(&client->user);
   combo->setCurrentItem(getTextId(combo, client->curUser));
   vlayout->addWidget(combo);
   combo->setFixedSize(205, 25);

   hlayout = new QHBoxLayout();
   vlayout->addLayout(hlayout);
   pb.insert("AddUser", btn=new QPushButton(" Add ", gb));
   hlayout->addWidget(btn);
   btn->setFixedSize(100, 20); 
   connect(btn, SIGNAL(clicked()), this, SLOT(slotAddUser()));

   pb.insert("DelUser", btn=new QPushButton(" Delete ", gb));
   hlayout->addWidget(btn);
   btn->setFixedSize(100, 20); 
   connect(btn, SIGNAL(clicked()), this, SLOT(slotDelUser()));
   vlayout->activate();

   gb = new QGroupBox("Ircname", this);
   rVerLayout->addWidget(gb);
   vlayout = new QVBoxLayout(gb, 8);
   vlayout->addSpacing(10);

   cb.insert("Ircname", combo=new QComboBox(FALSE, gb, "comboIrcname"));
   combo->setInsertionPolicy(QComboBox::AtCurrent);
   QToolTip::add(combo, "Select Ircname" );
   combo->insertStrList(&client->ircname);
   combo->setCurrentItem(getTextId(combo, client->curIrcname));
   vlayout->addWidget(combo);
   combo->setFixedSize(205, 25);

   hlayout = new QHBoxLayout();
   vlayout->addLayout(hlayout);
   pb.insert("AddIrcname", btn=new QPushButton(" Add ", gb));
   hlayout->addWidget(btn);
   btn->setFixedSize(100, 20); 
   connect(btn, SIGNAL(clicked()), this, SLOT(slotAddIrcname()));

   pb.insert("DelIrcname", btn=new QPushButton(" Delete ", gb));
   hlayout->addWidget(btn);
   btn->setFixedSize(100, 20); 
   connect(btn, SIGNAL(clicked()), this, SLOT(slotDelIrcname()));
   vlayout->activate();
   rVerLayout->addStretch(10);

   horLayout->activate();
   setConnect();
#ifdef EDEBUG
  cout << "Konstruktor ClientSetupTab...Ok" << endl;
#endif
   show();
}

ClientSetupTab::~ClientSetupTab()
{
#ifdef EDEBUG
  cout << "Destruktor ClientSetupTab" << endl;
#endif
}

int ClientSetupTab::getTextId(QComboBox* combo, const char* txt)
{
  for (int i=0;i<combo->count();i++)
      if (!stricmp(combo->text(i), txt))
	 return i;
  return -1;
}

void ClientSetupTab::setConnect()
{
   connect(client, SIGNAL(signCurNick  (const char*)),this, SLOT(setCurNick  (const char*)));
   connect(client, SIGNAL(signCurServer(IrcServer*)), this, SLOT(setCurServer(IrcServer*)));
   connect(client, SIGNAL(signAddServer(IrcServer*)), 
	   this,   SLOT  (addServer    (IrcServer*)));
   connect(client, SIGNAL(signAddNick  (const char*)), 
	   this,   SLOT  (addNick      (const char*)));

   // signal von widget
   // User selected from listBox
   connect (serverBox,  SIGNAL(highlighted  (int, int)),
	    this,       SLOT  (slotCurServer(int, int)));
   
   // User 
   connect (cb["Nick"]   , SIGNAL(activated    (int)),
	    this,          SLOT  (slotCurNick   (int)));
   connect (cb["User"]   , SIGNAL(activated    (int)),
	    this,          SLOT  (slotCurUser   (int)));
   connect (cb["Ircname"] ,SIGNAL(activated    (int)),
	    this,          SLOT  (slotCurIrcname(int)));
}

void ClientSetupTab::addServer(IrcServer* is)
{
   serverBox->appendItem(is->toString());
}

void ClientSetupTab::addNick(const char* s)
{
   cb["Nick"]->insertItem(s);
}

void ClientSetupTab::setCurServer(IrcServer* is)
{
  for (uint i=0;i<serverBox->count();i++){
      QString s = is->Host();
      QString p = is->Port();
      if (s==serverBox->text(i, 0) && p==serverBox->text(i, 1)){
	 serverBox->setCurrentItem(i);
	 serverBox->setTopItem(i);
	 return;
      }
  }
}

void ClientSetupTab::setCurNick(const char* nick)
{
  for (int i=0;i<cb["Nick"]->count();i++)
      if (!stricmp(cb["Nick"]->text(i), nick)){
         cb["Nick"]->setCurrentItem(i);
	 return;
      }
}

void ClientSetupTab::slotCurNick(int idx)
{
  if (client->getSocket().getSocket()<1)
     client->setCurNick(cb["Nick"]->text(idx));
  else
     client->getSocket().sendNick(cb["Nick"]->text(idx));
}

void ClientSetupTab::slotCurUser(int idx)
{
  client->curUser=cb["User"]->text(idx);
}

void ClientSetupTab::slotCurIrcname(int idx)
{
  client->curIrcname=cb["Ircname"]->text(idx);
}

void ClientSetupTab::slotCurServer(int idx, int)
{
  QString s=serverBox->text(idx, 0);
  QString p=serverBox->text(idx, 1);
  if (client->curServer->Host()==s && client->curServer->Port()==p)
     return;
  client->setCurServer(s+":"+p);
}

void ClientSetupTab::slotAddServer()
{
   QString se, po, in, pa;
   ServerDialog addServer(this);
   addServer.setCaption("Add Server");
   if (addServer.exec() ) {
      se=addServer.getHost();
      if (se.isNull() || se.isEmpty())
	 return;
      po=addServer.getPort();
      pa=addServer.getPasswd();
      in=addServer.getInfo();
      IrcServer* is;
      if ((is=client->server->find(se+":"+po))!=NULL){
	 KMsgBox::message(this, "ClientSetup Dialog", "This server "+
			  is->toString()+ " is already exist", KMsgBox::INFORMATION, "OK");
	 return;
      }
      QString n=se+":"+po+":"+pa+":"+in;
      client->addServer(n);
      client->setCurServer(n);
   }
}

void ClientSetupTab::slotEditServer()
{
   ServerDialog editServer(this, "Server Dialog");
   editServer.setCaption("Edit Server");
   int idx=serverBox->currentItem();
   IrcServer* is = client->curServer;

   QString s =is->Host();
   QString p =is->Port();
   QString i =is->Info();
   QString pw=is->Passwd();
   editServer.setHost  (s);
   editServer.setPort  (p);
   editServer.setInfo  (i);
   editServer.setPasswd(pw);

   if (editServer.exec() ) {
      QString se, po, pa, in;
      se=editServer.getHost();
      if (se.isNull() || se.isEmpty())
	 return;
      po=editServer.getPort();
      if (po.isNull()||po.isEmpty())
	 po="6667";
      pa=editServer.getPasswd();
      in=editServer.getInfo();
      serverBox->removeItem(idx);
      client->delServer(s+":"+p);
      client->addServer(se+":"+po+":"+pa+":"+in);

      client->setCurServer(se+":"+po);
   }
}

void ClientSetupTab::slotDelServer()
{
   if (serverBox->count()==1)
      return;
   int idx=serverBox->currentItem();
   IrcServer* is=client->curServer;
   
   client->delServer(is->Host()+":"+is->Port());
   serverBox->removeItem(idx);
   
   if (idx)
      idx--;
   serverBox->setCurrentItem(idx);
   client->setCurServer(serverBox->text(idx, 0)+":"+serverBox->text(idx, 1));
}

void ClientSetupTab::slotAddNick()
{
   SingleDialog addNick("Nick : ", "", "Nick Dialog");
   if (addNick.exec() ) {
       QString e = addNick.getText(TRUE);
       if (!e.isEmpty()){
	  if (client->nick.find(e) < 0)
	    client->setCurNick(e);
	  else
	    KMsgBox::message(this, "ClientSetup Dialog", "This nick "+ e+ " is already exist", 
			     KMsgBox::INFORMATION, "OK");
       }
   }
}


void ClientSetupTab::slotDelNick()
{
   if (client->nick.count()<2)
      return;
   QString nick = cb["Nick"]->currentText();
   client->nick.remove(nick);
   cb["Nick"]->removeItem(cb["Nick"]->currentItem());
   client->setCurNick(client->nick.current());
}

void ClientSetupTab::slotAddUser()
{
   SingleDialog addUser("User : ", "", "User Dialog");
   if (addUser.exec() ) {
       QString e = addUser.getText(TRUE);
       if (!e.isEmpty()){
	  if (client->user.find(e) < 0){
	      client->user.inSort(e);
	      client->curUser = e;
	      cb["User"]->insertItem(e);
	  }
	  else
	    KMsgBox::message(this, "ClientSetup Dialog", "This user "+ e+ " is already exist", 
			     KMsgBox::INFORMATION, "OK");
       }
   }
}

void ClientSetupTab::slotDelUser()
{
   if (cb["User"]->count()<2)
      return;
   QString user = cb["User"]->currentText();
   client->user.remove(user);
   cb["User"]->removeItem(cb["User"]->currentItem());
   client->curUser=client->user.current();
}

void ClientSetupTab::slotAddIrcname()
{
   SingleDialog addIrcname("Ircname : ", "", "Ircname Dialog");
   if (addIrcname.exec() ) {
       QString e = addIrcname.getText();
       if (!e.isEmpty()){
	  if (client->ircname.find(e) < 0){
	     client->ircname.inSort(e);
	     client->curIrcname = e;
	     cb["Ircname"]->insertItem(e);
	  }
	  else
	    KMsgBox::message(this, "ClientSetup Dialog", "This ircname "+ e+ " is already exist", 
			     KMsgBox::INFORMATION, "OK");
       }
   }
}


void ClientSetupTab::slotDelIrcname()
{
   if (cb["Ircname"]->count()==1)
      return;
   QString in = cb["Ircname"]->currentText();
   client->ircname.remove(in);
   cb["Ircname"]->removeItem(cb["Ircname"]->currentItem());
   client->curIrcname=client->ircname.current();
}

void ClientSetupTab::slotApply()
{
  if (!client->saveConfig()){
         QMessageBox::information(NULL, 
				  "kEirc Dialog",
				  "Unable to save config kEirc.cfg.\n");
  }
}

