#include <iostream.h>
#include <qregexp.h>
#include <qlist.h>
#include "StringToken.h"
#include "channelMode.h"
#include "channelMode.moc"

ChannelMode::ChannelMode() : IrcMode()
{
  modeVar = new QDict<char>(5, FALSE, TRUE);
  modeVar->setAutoDelete(TRUE);
  modeBan = new QList<IrcBan>();
  modeBan->setAutoDelete(TRUE);
}

ChannelMode::~ChannelMode()
{
  delete modeVar;
  delete modeBan;
}

QString ChannelMode::addMode(const char* Mode, const char* param)
{
#ifdef EDEBUG
	cout << "ChannelMode::addMode " << Mode << ":" << param << endl;
#endif
  StringToken t(param);
  QString Param;
  QString nm=IrcMode::addMode(Mode);

  for (uint i=0;i<nm.length();i++){
    if (nm[i]=='b' && param ){
       modeBan->append(new IrcBan(param));
       emit signAddMode(nm[i], param);
       continue;
    }
    else if (nm[i]=='k' && param){
       Param = t.nextToken();
       modeVar->insert("key",qstrdup(Param));
    }
    else if (nm[i]=='l' && param){
       Param = t.nextToken();
       modeVar->insert("limit",qstrdup(Param));
    }
    emit signAddMode(nm[i], Param);
  }
  return nm;
}

QString ChannelMode::delMode(const char* Mode, const char* Param)
{
#ifdef EDEBUG
  cout << "ChannelMode:delMode " << Mode << ":" << Param << endl;
#endif
  StringToken t(Param);
  QString ms    = IrcMode::delMode(Mode);
  QString param = t.nextToken();
  for (uint i=0;i<ms.length();i++){
      if (ms[i]=='b' && Param){
	 param.stripWhiteSpace();
	 QRegExp re(param, FALSE, TRUE);
	 QListIterator<IrcBan> it(*modeBan);
	 IrcBan* ib;
	 for (ib=modeBan->first();ib;){
	    QString key = ib->ban();
	    key = key.stripWhiteSpace(); 
	    int len;
	    re.match(key, 0, &len);
	    if (len==(int)key.length()){
	       modeBan->remove();
	       ib=modeBan->current();
	       emit signDelMode(ms[i], key);
	    }
	    else
	       ib=modeBan->next();
	 }
	 continue;
      }
      else if (ms[i]=='k')
	 modeVar->remove("key");
      else if (ms[i]=='l')
	modeVar->remove("limit");
      emit signDelMode(ms[i], param);
  }
  return ms;
} 

QString ChannelMode::key()
{
  return modeVar->find("key");
}

QString ChannelMode::limit()
{
  return modeVar->find("limit");
}

QList<IrcBan>* ChannelMode::banList()
{
  return modeBan;
}
