#ifndef __SOCKET_H__
#define __SOCKET_H__

#include <qstring.h>
#include <qobject.h>
#include <stdio.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include "InetAddress.h"

#define MAXBUFSOCK      4096

class Socket : public QObject
{
  Q_OBJECT
protected:
  int         sd;
  InetAddress inAddr;      //peer Internet Address
  InetAddress localInAddr;
  int         localPort;
  int         peerPort;
private:
  void Init();
signals:
  void signError();
  void signText (const char*);
public:
  // Konstructor
  Socket();
  // Member Funktionen
  InetAddress getInetAddress();
  InetAddress getLocalInetAddress();
  virtual int  Open (){return 1;};
  virtual void Close(){};
  int  getSocket();
  int  getLocalPort();
  int  getPeerPort();
  int  readData (QString& data, int length);
  int  readLine (QString& data);
  int  readStr  (QString& data);
  int  writeLine(const char* data);
};

#endif







